/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class IndentWriter
extends FilterWriter {
    private int indentation = 0;
    private final int indentAmount;
    private boolean indented = false;
    private final String lineSeparator;

    public IndentWriter(Writer writer, int n) {
        super(writer);
        this.indentAmount = n;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public void print(String string) throws IOException {
        this.checkIndentation();
        this.write(string);
    }

    public void print(char c) throws IOException {
        this.checkIndentation();
        this.write(c);
    }

    public void print(int n) throws IOException {
        this.checkIndentation();
        if (n == 0) {
            this.write(48);
            return;
        }
        if (n < 0) {
            this.write(45);
            n = -n;
        }
        this.print0(n);
    }

    private void print0(int n) throws IOException {
        if (n > 0) {
            this.print0(n / 10);
            this.write(n % 10 + 48);
        }
    }

    public void print(float f) throws IOException {
        this.checkIndentation();
        if (f == (float)((int)f)) {
            this.print((int)f);
        } else {
            this.write(String.valueOf(f));
        }
    }

    public void print(double d) throws IOException {
        this.checkIndentation();
        if (d == (double)((int)d)) {
            this.print((int)d);
        } else {
            this.write(String.valueOf(d));
        }
    }

    public void println() throws IOException {
        this.indented = false;
        this.write(this.lineSeparator);
    }

    public void indent() {
        this.indentation += this.indentAmount;
    }

    public void unindent() {
        this.indentation -= this.indentAmount;
    }

    protected void checkIndentation() throws IOException {
        if (!this.indented) {
            for (int i = 0; i < this.indentation; ++i) {
                this.write(32);
            }
            this.indented = true;
        }
    }
}

