/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.io;

import de.grogra.pf.io.DOMSource;
import de.grogra.pf.io.FileReaderSource;
import de.grogra.pf.io.FileWriterSource;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.InputStreamSource;
import de.grogra.pf.io.OutputStreamSource;
import de.grogra.pf.io.ReaderSource;
import de.grogra.pf.io.SAXFilterBase;
import de.grogra.pf.io.SAXSource;
import de.grogra.pf.io.VirtualFileWriterSource;
import de.grogra.pf.io.WriterSource;
import de.grogra.util.IOWrapException;
import de.grogra.util.Utils;
import de.grogra.util.XByteArrayOutputStream;
import de.grogra.vfs.FileSystem;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class StreamAdapter
extends SAXFilterBase
implements InputStreamSource,
OutputStreamSource,
ReaderSource,
WriterSource,
FileWriterSource,
DOMSource,
VirtualFileWriterSource {
    private XMLReader xmlReader = null;

    public StreamAdapter(FilterSource filterSource, IOFlavor iOFlavor) {
        super(null, filterSource, iOFlavor);
    }

    public InputStream getInputStream() throws IOException {
        IOFlavor iOFlavor = this.source.getFlavor();
        if (iOFlavor.isInputStreamSupported()) {
            return ((InputStreamSource)this.source).getInputStream();
        }
        if (iOFlavor.isOutputStreamSupported() || iOFlavor.isWriterSupported() || iOFlavor.isReaderSupported() || iOFlavor.isSAXSupported() || iOFlavor.isDOMSupported()) {
            XByteArrayOutputStream xByteArrayOutputStream = new XByteArrayOutputStream(100000);
            this.write(xByteArrayOutputStream);
            xByteArrayOutputStream.flush();
            xByteArrayOutputStream.close();
            return xByteArrayOutputStream.createInputStream();
        }
        throw new IOException("Can't adapt " + this.source + " to " + this);
    }

    public long length() {
        return this.source.getFlavor().isInputStreamSupported() ? ((InputStreamSource)this.source).length() : -1L;
    }

    public void write(OutputStream outputStream) throws IOException {
        IOFlavor iOFlavor = this.source.getFlavor();
        if (iOFlavor.isOutputStreamSupported()) {
            ((OutputStreamSource)this.source).write(outputStream);
        } else if (iOFlavor.isInputStreamSupported()) {
            int n;
            byte[] byArray = new byte[65536];
            InputStream inputStream = ((InputStreamSource)this.source).getInputStream();
            while ((n = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
            inputStream.close();
        } else if (iOFlavor.isSAXSupported() && !iOFlavor.isWriterSupported() && !iOFlavor.isReaderSupported()) {
            this.transformSAX(new StreamResult(outputStream));
        } else if (iOFlavor.isDOMSupported() && !iOFlavor.isWriterSupported() && !iOFlavor.isReaderSupported()) {
            this.transformDOM(new StreamResult(outputStream));
        } else {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            this.write(outputStreamWriter);
            outputStreamWriter.flush();
        }
    }

    public Reader getReader() throws IOException {
        IOFlavor iOFlavor = this.source.getFlavor();
        if (iOFlavor.isReaderSupported()) {
            return ((ReaderSource)this.source).getReader();
        }
        if (iOFlavor.isWriterSupported() || (iOFlavor.isSAXSupported() || iOFlavor.isDOMSupported()) && !iOFlavor.isInputStreamSupported() && !iOFlavor.isOutputStreamSupported()) {
            ArrayWriter arrayWriter = new ArrayWriter(100000);
            this.write(arrayWriter);
            arrayWriter.flush();
            arrayWriter.close();
            return new CharArrayReader(arrayWriter.getBuffer(), 0, arrayWriter.size());
        }
        return new InputStreamReader(this.getInputStream());
    }

    public void write(Writer writer) throws IOException {
        IOFlavor iOFlavor = this.source.getFlavor();
        if (iOFlavor.isWriterSupported()) {
            ((WriterSource)this.source).write(writer);
        } else if (iOFlavor.isSAXSupported()) {
            this.transformSAX(new StreamResult(writer));
        } else if (iOFlavor.isDOMSupported()) {
            this.transformDOM(new StreamResult(writer));
        } else {
            int n;
            Reader reader = this.getReader();
            char[] cArray = new char[65536];
            while ((n = reader.read(cArray)) >= 0) {
                writer.write(cArray, 0, n);
            }
            reader.close();
        }
    }

    private XMLReader getXMLReader() throws SAXException {
        if (this.xmlReader == null) {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            try {
                this.xmlReader = sAXParserFactory.newSAXParser().getXMLReader();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw Utils.newSAXException(parserConfigurationException);
            }
        }
        return this.xmlReader;
    }

    private String getXMLSystemId() {
        String string = this.source.getSystemId();
        File file = IO.toLocalFile(string);
        return file != null && file.exists() ? file.getAbsolutePath() : string;
    }

    public void parse(ContentHandler contentHandler, ErrorHandler errorHandler, LexicalHandler lexicalHandler, DTDHandler dTDHandler, EntityResolver entityResolver) throws IOException, SAXException {
        IOFlavor iOFlavor = this.source.getFlavor();
        if (iOFlavor.isSAXSupported()) {
            ((SAXSource)this.source).parse(contentHandler, errorHandler, lexicalHandler, dTDHandler, entityResolver);
        } else if (iOFlavor.isDOMSupported()) {
            SAXResult sAXResult = new SAXResult(contentHandler);
            if (lexicalHandler != null) {
                sAXResult.setLexicalHandler(lexicalHandler);
            }
            this.transformDOM(sAXResult);
        } else {
            InputSource inputSource = iOFlavor.isInputStreamSupported() || iOFlavor.isOutputStreamSupported() ? new InputSource(this.getInputStream()) : new InputSource(this.getReader());
            inputSource.setSystemId(this.getXMLSystemId());
            XMLReader xMLReader = this.getXMLReader();
            xMLReader.setContentHandler(contentHandler);
            if (errorHandler != null) {
                xMLReader.setErrorHandler(errorHandler);
            }
            if (lexicalHandler != null) {
                xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
            }
            if (dTDHandler != null) {
                xMLReader.setDTDHandler(dTDHandler);
            }
            if (entityResolver != null) {
                xMLReader.setEntityResolver(entityResolver);
            }
            xMLReader.parse(inputSource);
        }
    }

    private void transformSAX(Result result) throws IOException {
        this.transform(new javax.xml.transform.sax.SAXSource(this, new InputSource(this.source.getSystemId())), result);
    }

    private void transformDOM(Result result) throws IOException {
        this.transform(new javax.xml.transform.dom.DOMSource(((DOMSource)this.source).getDocument(), this.source.getSystemId()), result);
    }

    private void transform(Source source, Result result) throws IOException {
        source.setSystemId(this.getXMLSystemId());
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            if (result instanceof StreamResult) {
                transformer.setOutputProperty("indent", "yes");
                try {
                    transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "1");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            transformer.transform(source, result);
        }
        catch (TransformerException transformerException) {
            throw new IOWrapException(transformerException);
        }
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.source.getFlavor().isSAXSupported()) {
            return ((SAXSource)this.source).getFeature(string);
        }
        try {
            this.getXMLReader();
        }
        catch (SAXException sAXException) {
            throw new SAXNotRecognizedException(string);
        }
        return this.xmlReader.getFeature(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.source.getFlavor().isSAXSupported()) {
            ((SAXSource)this.source).setFeature(string, bl);
        } else {
            try {
                this.getXMLReader();
            }
            catch (SAXException sAXException) {
                throw new SAXNotRecognizedException(string);
            }
            this.xmlReader.setFeature(string, bl);
        }
    }

    public void write(File file) throws IOException {
        StreamAdapter.write(this, null, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FileSystem fileSystem, Object object) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = fileSystem.getOutputStream(object, false);
            this.write(outputStream);
            outputStream.flush();
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public static void write(OutputStreamSource outputStreamSource, File file) throws IOException {
        StreamAdapter.write(outputStreamSource, null, file);
    }

    public static void write(WriterSource writerSource, File file) throws IOException {
        StreamAdapter.write(null, writerSource, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(OutputStreamSource outputStreamSource, WriterSource writerSource, File file) throws IOException {
        Object object;
        Object object2;
        OutputStream outputStream = null;
        File file2 = file.exists() && file.length() > 0L ? File.createTempFile(file.getName(), null, file.getParentFile()) : file;
        try {
            outputStream = new FileOutputStream(file2);
            object2 = new BufferedOutputStream(outputStream);
            if (outputStreamSource != null) {
                outputStreamSource.write((OutputStream)object2);
            } else {
                object = new OutputStreamWriter((OutputStream)object2);
                writerSource.write((Writer)object);
                ((OutputStreamWriter)object).flush();
            }
            ((OutputStream)object2).flush();
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        if (file == file2) {
            return;
        }
        if (file.exists()) {
            object2 = new File(file.getParentFile(), file.getName() + '~');
            if (((File)object2).exists()) {
                ((File)object2).delete();
            }
            file.renameTo((File)object2);
        }
        if (!file2.renameTo(file)) {
            int n;
            object2 = new BufferedInputStream(new FileInputStream(file2));
            object = new byte[65536];
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            while ((n = ((InputStream)object2).read((byte[])object)) >= 0) {
                outputStream.write((byte[])object, 0, n);
            }
            ((InputStream)object2).close();
            outputStream.flush();
            outputStream.close();
            file2.delete();
        }
    }

    public Document getDocument() throws IOException, DOMException {
        IOFlavor iOFlavor = this.source.getFlavor();
        if (iOFlavor.isDOMSupported()) {
            return ((DOMSource)this.source).getDocument();
        }
        DOMResult dOMResult = new DOMResult();
        if (iOFlavor.isSAXSupported()) {
            this.transformSAX(dOMResult);
        } else {
            StreamSource streamSource = iOFlavor.isFileReaderSupported() ? new StreamSource(((FileReaderSource)this.source).getInputFile()) : (iOFlavor.isInputStreamSupported() || iOFlavor.isOutputStreamSupported() ? new StreamSource(this.getInputStream()) : new StreamSource(this.getReader()));
            streamSource.setSystemId(this.getXMLSystemId());
            this.transform(streamSource, dOMResult);
        }
        return (Document)dOMResult.getNode();
    }

    private static class ArrayWriter
    extends CharArrayWriter {
        ArrayWriter(int n) {
            super(n);
        }

        char[] getBuffer() {
            return this.buf;
        }
    }
}

