/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.registry;

import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.graph.impl.SharedObjectNode;
import de.grogra.icon.IconSource;
import de.grogra.persistence.Manageable;
import de.grogra.persistence.PersistenceInput;
import de.grogra.persistence.PersistenceOutput;
import de.grogra.persistence.ResolvableReference;
import de.grogra.persistence.Shareable;
import de.grogra.persistence.SharedObjectProvider;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.SONodeReference;
import de.grogra.pf.registry.Value;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.util.Described;
import java.io.IOException;

public abstract class ObjectItem
extends Item
implements SharedObjectProvider {
    private static final int OBJ_DESCRIBES_MASK = 2048;
    public static final int USED_BITS = 12;
    String type;
    private Type objectType;
    public static final Node.NType $TYPE = new Node.NType(ObjectItem.class);
    public static final Node.NType.Field objDescribes$FIELD = new Node.NType.BitField($TYPE, "objDescribes", 0x200000, Type.BOOLEAN, 2048);
    public static final Node.NType.Field type$FIELD;

    public static ObjectItem createReference(RegistryContext registryContext, Object object, String string) {
        if (object instanceof Shareable) {
            SharedObjectNode sharedObjectNode = new SharedObjectNode((Shareable)object);
            sharedObjectNode.setExtentIndex(7);
            GraphManager graphManager = registryContext.getRegistry().getProjectGraph();
            graphManager.addMetaNode(sharedObjectNode, registryContext.getRegistry().isActive() ? graphManager.getActiveTransaction() : null);
            return new SONodeReference(string, sharedObjectNode);
        }
        return new Value(string, object);
    }

    public void addToRegistry(Registry registry, String string) {
        this.setObjDescribes(true);
        registry.getItem(string).addUserItemWithUniqueName(this, "obj");
    }

    public ObjectItem(String string) {
        super(string);
    }

    protected void setType(String string) {
        this.type = string;
    }

    public abstract Object getObject();

    public abstract boolean isObjectFetched();

    protected boolean getTypeFromObject() {
        return this.type == null;
    }

    public Type getObjectType() {
        if (this.getTypeFromObject() && (this.objectType == null || !Reflection.isPrimitive(this.objectType))) {
            Object object = this.getObject();
            return object == null ? Type.NULL : (object instanceof Manageable ? ((Manageable)object).getManageableType() : ClassAdapter.wrap(object.getClass()));
        }
        return this.getObjectTypeImpl();
    }

    Type getObjectTypeImpl() {
        if (this.objectType == null) {
            if (this.type.indexOf(46) < 0) {
                if ("null".equals(this.type)) {
                    this.objectType = Type.NULL;
                } else if ("boolean".equals(this.type)) {
                    this.objectType = ClassAdapter.wrap(Boolean.class);
                } else if ("byte".equals(this.type)) {
                    this.objectType = ClassAdapter.wrap(Byte.class);
                } else if ("short".equals(this.type)) {
                    this.objectType = ClassAdapter.wrap(Short.class);
                } else if ("char".equals(this.type)) {
                    this.objectType = ClassAdapter.wrap(Character.class);
                } else if ("int".equals(this.type)) {
                    this.objectType = ClassAdapter.wrap(Integer.class);
                } else if ("long".equals(this.type)) {
                    this.objectType = ClassAdapter.wrap(Long.class);
                } else if ("float".equals(this.type)) {
                    this.objectType = ClassAdapter.wrap(Float.class);
                } else if ("double".equals(this.type)) {
                    this.objectType = ClassAdapter.wrap(Double.class);
                }
            }
            if (this.objectType == null) {
                this.objectType = Reflection.getType(this.type, this.getClassLoader());
            }
        }
        return this.objectType;
    }

    public boolean isInstance(String string) {
        return Reflection.isSupertypeOrSame(string, this.getObjectType());
    }

    public boolean isInstance(Type type) {
        return Reflection.isAssignableFrom(type, this.getObjectType());
    }

    public boolean isInstance(Class clazz) {
        return clazz.isAssignableFrom(this.getObjectType().getImplementationClass());
    }

    protected Object getDerivedDescription(String string) {
        if ((this.bits & 0x800) == 0) {
            return null;
        }
        Object object = this.getObject();
        return object instanceof Described ? ((Described)object).getDescription(string) : ("Icon".equals(string) && object instanceof IconSource ? object : null);
    }

    public String getProviderName() {
        return this.getRegistry().getProviderName();
    }

    public ResolvableReference readReference(PersistenceInput persistenceInput) throws IOException {
        return this.getRegistry().readReference(persistenceInput);
    }

    public void writeObject(Shareable shareable, PersistenceOutput persistenceOutput) throws IOException {
        if (shareable == this.getObject()) {
            persistenceOutput.writeString(this.getAbsoluteName());
        } else {
            this.getRegistry().writeObject(shareable, persistenceOutput);
        }
    }

    public void setObjDescribes(boolean bl) {
        this.bits = bl ? (this.bits |= 0x800) : (this.bits &= 0xFFFFF7FF);
    }

    static {
        $TYPE.addManagedField(objDescribes$FIELD);
        type$FIELD = new _Field("type", 0x200000, ClassAdapter.wrap(String.class), null, 0);
        $TYPE.addManagedField(type$FIELD);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((ObjectItem)object).type = (String)object2;
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((ObjectItem)object).type;
                }
            }
            return super.getObject(object);
        }
    }
}

