/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.registry;

import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.GraphTransaction;
import de.grogra.graph.impl.Node;
import de.grogra.graph.impl.SharedObjectNode;
import de.grogra.persistence.FatalPersistenceException;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceBindings;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.persistence.PersistenceConnection;
import de.grogra.persistence.PersistenceField;
import de.grogra.persistence.PersistenceInput;
import de.grogra.persistence.PersistenceOutput;
import de.grogra.persistence.ResolvableReference;
import de.grogra.persistence.SOReferenceImpl;
import de.grogra.persistence.ServerConnection;
import de.grogra.persistence.Shareable;
import de.grogra.persistence.SharedObjectProvider;
import de.grogra.persistence.Transaction;
import de.grogra.persistence.XAListener;
import de.grogra.pf.boot.Main;
import de.grogra.pf.io.FileTypeItem;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.SAXSource;
import de.grogra.pf.registry.Directory;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ItemComparator;
import de.grogra.pf.registry.ItemCriterion;
import de.grogra.pf.registry.ItemVisitor;
import de.grogra.pf.registry.ObjectItem;
import de.grogra.pf.registry.PluginClassLoader;
import de.grogra.pf.registry.PluginDescriptor;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.Root;
import de.grogra.pf.registry.SONodeReference;
import de.grogra.pf.registry.XMLRegistryReader;
import de.grogra.pf.registry.XMLSerializer;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.reflect.TypeLoader;
import de.grogra.util.Int2ObjectMap;
import de.grogra.util.MimeType;
import de.grogra.util.StringMap;
import de.grogra.util.TreeDiff;
import de.grogra.util.TreeModelEventMulticaster;
import de.grogra.util.Utils;
import de.grogra.vfs.FSFile;
import de.grogra.vfs.FileSystem;
import de.grogra.vfs.JoinedFileSystem;
import de.grogra.xl.util.ObjectList;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.xml.sax.ContentHandler;

public final class Registry
implements Transaction.Consumer,
GraphTransaction.Consumer,
XAListener,
SharedObjectProvider,
SharedObjectProvider.Binding,
TreeModel,
RegistryContext,
TreeDiff.NodeModel,
TypeLoader {
    public static final String NAMESPACE = "http://grogra.de/registry";
    public static final MimeType MIME_TYPE = new MimeType("application/x-grogra-registry+xml");
    public static final String PROJECT_GRAPH = "Project";
    public static final String REGISTRY_GRAPH = "Registry";
    private static int nextPropertyId = 0;
    int stamp = 1;
    private int activationStamp = 0;
    final StringMap importAttributes = new StringMap();
    private final StringMap itemMap = new StringMap();
    private final Registry parentRegistry;
    private final Registry rootRegistry;
    private final TreeModelEventMulticaster treeMulticaster = new TreeModelEventMulticaster();
    private final Int2ObjectMap userProperties = new Int2ObjectMap();
    private final ObjectList afterCommit = new ObjectList(10);
    private GraphManager regGraph;
    private GraphManager project;
    private Transaction.Reader reader;
    private Item root;
    private String projectName = null;
    private final Object lock;
    private final Object writeLock;
    private boolean active = false;
    private final Hashtable pluginTypes;
    private FileSystem fileSystem;
    private String fsName;
    private boolean fsAdded;
    private ObjectList fileSystemListeners = new ObjectList(5, false);
    private final int id;
    private final Logger logger;
    public static final JoinedFileSystem PLUGIN_FILE_SYSTEMS = new JoinedFileSystem("pluginfs", "pluginfs");
    public static final JoinedFileSystem ALL_FILE_SYSTEMS = new JoinedFileSystem("project", "project");
    private static int nextId = -1;
    private final TreeModel oldTree = new TreeModel(){

        public Object getRoot() {
            return Registry.this.getRoot();
        }

        public Object getChild(Object object, int n) {
            return ((Item)object).oldChildren.get(n);
        }

        public int getChildCount(Object object) {
            return ((Item)object).oldChildren.size();
        }

        public boolean isLeaf(Object object) {
            return Registry.this.isLeaf(object);
        }

        public int getIndexOfChild(Object object, Object object2) {
            return ((Item)object).oldChildren.indexOf(object2);
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
            throw new AssertionError();
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            throw new AssertionError();
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            throw new AssertionError();
        }
    };
    private static final ItemVisitor GET_FILES = new ItemVisitor(){

        public void visit(Item item, Object object) {
            item.addRequiredFiles((Collection)object);
        }
    };
    private transient GraphTransaction currentXA = null;
    private transient int xaCount = 0;
    private static final ItemCriterion ACTIVATED = new ItemCriterion(){

        public boolean isFulfilled(Item item, Object object) {
            return item.isActivated() == Boolean.TRUE.equals(object);
        }

        public String getRootDirectory() {
            return null;
        }
    };
    private final ObjectList fieldChanged = new ObjectList(10, false);
    private final ObjectList structureChanged = new ObjectList(10, false);
    private final SOReferenceImpl ref = new SOReferenceImpl();
    private static final ThreadLocal REGISTRIES = new ThreadLocal();

    public static synchronized int allocatePropertyId() {
        return nextPropertyId++;
    }

    private static synchronized int nextId() {
        return nextId++;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.treeMulticaster.addTreeModelListener(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.treeMulticaster.removeTreeModelListener(treeModelListener);
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        throw new UnsupportedOperationException();
    }

    public Object getChild(Object object, int n) {
        return ((Item)object).getBranchNode(n);
    }

    public int getChildCount(Object object) {
        return ((Item)object).getBranchLength();
    }

    public int getIndexOfChild(Object object, Object object2) {
        return ((Item)object2).getIndex();
    }

    public boolean isLeaf(Object object) {
        return !((Item)object).isDirectory();
    }

    public Object getRoot() {
        return this.root;
    }

    public static Registry create(Registry registry) {
        Registry registry2 = new Registry(registry);
        ServerConnection serverConnection = new ServerConnection(new PersistenceBindings(registry2, registry2));
        registry2.createGraphs(serverConnection);
        Root root = new Root();
        registry2.regGraph.makePersistent(root, -1L, null);
        registry2.regGraph.setRoot("MainGraph", root);
        registry2.initialize();
        return registry2;
    }

    public void createGraphs(PersistenceConnection persistenceConnection) {
        this.project = this.parentRegistry != null ? new GraphManager(persistenceConnection, PROJECT_GRAPH, true, true) : null;
        this.regGraph = new GraphManager(persistenceConnection, REGISTRY_GRAPH, true, false);
    }

    public Registry(Registry registry) {
        this.id = Registry.nextId();
        this.parentRegistry = registry;
        if (registry != null) {
            this.rootRegistry = registry.rootRegistry;
            this.lock = registry.lock;
            this.writeLock = registry.writeLock;
            this.pluginTypes = registry.pluginTypes;
            this.logger = Logger.getLogger("de.grogra.pf.registry." + this.id);
        } else {
            this.rootRegistry = this;
            this.lock = new Object();
            this.writeLock = new Object();
            this.pluginTypes = new Hashtable();
            this.logger = Logger.getLogger("de.grogra.pf.registry");
        }
        this.logger.setLevel(null);
    }

    public void initialize() {
        this.root = (Item)this.regGraph.getRoot("MainGraph");
        this.root.initPluginDescriptor(null);
        this.root.setRegistry(this);
        this.reader = new GraphTransaction(this.regGraph, null).createReader();
        this.regGraph.addXAListener(this);
    }

    public Registry getRegistry() {
        return this;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void addFileSystemListener(TreeModelListener treeModelListener) {
        treeModelListener.getClass();
        this.fileSystemListeners.addIfNotContained(treeModelListener);
        if (this.fileSystem != null) {
            this.fileSystem.addTreeModelListener(treeModelListener);
        }
    }

    public void removeFileSystemListener(TreeModelListener treeModelListener) {
        this.fileSystemListeners.remove(treeModelListener);
        if (this.fileSystem != null) {
            this.fileSystem.removeTreeModelListener(treeModelListener);
        }
    }

    public void initFileSystem(FileSystem fileSystem) {
        if (this.fileSystem != null) {
            throw new IllegalStateException();
        }
        this.setFileSystem(fileSystem);
    }

    private void setFileSystem(FileSystem fileSystem) {
        int n;
        this.fsAdded = false;
        if (this.fileSystem != null) {
            ALL_FILE_SYSTEMS.removeFileSystem(this.fileSystem);
            for (n = this.fileSystemListeners.size() - 1; n >= 0; --n) {
                this.fileSystem.removeTreeModelListener((TreeModelListener)this.fileSystemListeners.get(n));
            }
            this.fileSystem.setFileNameMap(null);
        }
        this.fileSystem = fileSystem;
        if (fileSystem != null) {
            for (n = this.fileSystemListeners.size() - 1; n >= 0; --n) {
                fileSystem.addTreeModelListener((TreeModelListener)this.fileSystemListeners.get(n));
            }
            fileSystem.setFileNameMap(new FileTypeItem.Map(this.getRootRegistry()));
            this.addFileSystem();
        }
    }

    private void addFileSystem() {
        if (!(this.fsAdded || this.fileSystem == null || this.fsName == null && this.projectName == null)) {
            this.fsAdded = true;
            ALL_FILE_SYSTEMS.addFileSystem(this.fileSystem, this.getFileSystemName(), this.fileSystem.getRoot());
        }
    }

    public void substituteFileSystem(FileSystem fileSystem) throws IOException {
        this.fileSystem.copyFilesTo(this.getFiles(), fileSystem);
        fileSystem.setManifest(this.fileSystem.getManifest());
        this.setFileSystem(fileSystem);
    }

    public Collection getFiles() {
        HashSet hashSet = new HashSet();
        this.forAll(null, null, GET_FILES, hashSet, false);
        return hashSet;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public final Object getProjectFile(String string) {
        FSFile fSFile = IO.toFile(this, string);
        return fSFile.fileSystem == this.fileSystem ? fSFile.file : null;
    }

    public final synchronized String getFileSystemName() {
        if (this.fsName == null) {
            this.fsName = this.projectName != null ? this.projectName + '[' + this.id + ']' : Integer.toString(this.id);
        }
        return this.fsName;
    }

    public void setProjectName(String string) {
        this.projectName = string;
        Utils.setDisplayLoggerName(this.logger.getName(), string);
        this.addFileSystem();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Object getImportAttribute(String string) {
        return this.importAttributes.get(string);
    }

    public Item findFirst(ItemCriterion itemCriterion, Object object, boolean bl) {
        String string = itemCriterion.getRootDirectory();
        return string == null ? this.root.findFirst(itemCriterion, object, bl) : Item.findFirst(this.getItem(string), itemCriterion, object, bl);
    }

    public void forAll(ItemCriterion itemCriterion, Object object, ItemVisitor itemVisitor, Object object2, boolean bl) {
        String string;
        if (itemCriterion == null || (string = itemCriterion.getRootDirectory()) == null) {
            this.root.forAll(itemCriterion, object, itemVisitor, object2, bl);
        } else {
            Item.forAll(this.getItem(string), itemCriterion, object, itemVisitor, object2, bl);
        }
    }

    public Item[] findAll(ItemCriterion itemCriterion, Object object, boolean bl) {
        String string = itemCriterion.getRootDirectory();
        return string == null ? this.root.findAll(itemCriterion, object, bl) : Item.findAll(this.getItem(string), itemCriterion, object, bl);
    }

    public Item findMax(ItemComparator itemComparator, Object object, boolean bl) {
        return this.root.findMax(itemComparator, object, bl);
    }

    public void setEmptyGraph() {
        Node node = new Node();
        node.setExtentIndex(7);
        this.project.setRoot("MainGraph", node);
        node = new Node();
        node.setExtentIndex(7);
        this.project.setRoot("MetaGraph", node);
    }

    public GraphManager getProjectGraph() {
        return this.project;
    }

    public GraphManager getRegistryGraph() {
        return this.regGraph;
    }

    public Registry getParentRegistry() {
        return this.parentRegistry;
    }

    public Registry getRootRegistry() {
        return this.rootRegistry;
    }

    public final boolean isRootRegistry() {
        return this == this.rootRegistry;
    }

    public Object getLock() {
        return this.lock;
    }

    public Object getWriteLock() {
        return this.writeLock;
    }

    public final void beginXA() {
        GraphTransaction graphTransaction;
        assert (Thread.holdsLock(this.writeLock));
        if (this.xaCount++ > 0) {
            return;
        }
        GraphManager graphManager = this.isActive() ? this.regGraph : null;
        GraphTransaction graphTransaction2 = graphTransaction = graphManager == null ? null : (GraphTransaction)graphManager.getTransaction(true);
        if (graphTransaction != null) {
            graphTransaction.begin(false);
            this.currentXA = graphTransaction;
        }
    }

    public final Transaction getTransaction() {
        return this.currentXA;
    }

    public final void invokeAfterCommit(Runnable runnable) {
        if (this.xaCount <= 0) {
            throw new IllegalStateException();
        }
        this.afterCommit.add(0, runnable);
    }

    public final void commitXA(boolean bl) {
        assert (Thread.holdsLock(this.writeLock));
        if (bl && this.xaCount == 1 && this.currentXA != null) {
            this.activateItems();
        }
        if (--this.xaCount == 0 && this.currentXA != null) {
            this.currentXA.commit();
            this.currentXA = null;
            this.runAfterCommit();
        }
    }

    private void runAfterCommit() {
        while (!this.afterCommit.isEmpty()) {
            ((Runnable)this.afterCommit.pop()).run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item getItem(String string) {
        Object object = this.lock;
        synchronized (object) {
            Item item = (Item)this.itemMap.get(string);
            if (item == null && (item = this.getItem(string, null, false)) != null) {
                this.itemMap.put(string, (Object)item);
            }
            return item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item getDirectory(String string, PluginDescriptor pluginDescriptor) {
        Item item;
        Object object = this.lock;
        synchronized (object) {
            item = this.getItem(string);
        }
        if (item != null) {
            return item;
        }
        object = this.writeLock;
        synchronized (object) {
            item = this.getItem(string);
            if (item != null) {
                return item;
            }
            this.beginXA();
            try {
                Object object2 = this.lock;
                synchronized (object2) {
                    item = this.getItem(string, pluginDescriptor, true);
                }
            }
            finally {
                this.commitXA(false);
            }
            return item;
        }
    }

    public SONodeReference addSharedObject(String string, Shareable shareable, String string2, boolean bl) {
        SharedObjectNode sharedObjectNode = new SharedObjectNode(shareable);
        sharedObjectNode.setExtentIndex(7);
        this.project.addMetaNode(sharedObjectNode, this.isActive() ? this.project.getActiveTransaction() : null);
        SONodeReference sONodeReference = new SONodeReference(sharedObjectNode);
        sONodeReference.setObjDescribes(bl);
        this.getDirectory(string, null).addUserItemWithUniqueName(sONodeReference, string2);
        return sONodeReference;
    }

    public final Item getPluginDirectory() {
        return this.rootRegistry.root.getItem("plugins");
    }

    public PluginDescriptor getPluginDescriptor(String string) {
        return (PluginDescriptor)this.getPluginDirectory().getItem(string);
    }

    private Item getItem(String string, PluginDescriptor pluginDescriptor, boolean bl) {
        if (string.equals("/")) {
            return this.root;
        }
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException(string + " does not start with '/'");
        }
        Item item = this.root;
        int n = 0;
        while (true) {
            char c;
            String string2 = item.getName();
            for (int i = 0; i < string2.length(); ++i) {
                char c2;
                if ((c2 = string.charAt(n++)) == '\\') {
                    c2 = string.charAt(n++);
                }
                if (c2 != string2.charAt(i)) {
                    throw new AssertionError();
                }
            }
            if (n == string.length()) {
                return item;
            }
            if (string.charAt(n++) != '/') {
                throw new AssertionError();
            }
            if (n == string.length()) {
                throw new IllegalArgumentException(string + " ends with '/'");
            }
            Item item2 = item.getItem(string, n, true);
            if (item2 != null) {
                item = item2;
                continue;
            }
            if (!bl) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(string.length() - n);
            int n2 = n;
            while (n2 < string.length() && (c = string.charAt(n2++)) != '/') {
                if (c == '\\') {
                    if (n2 == string.length()) {
                        throw new IllegalArgumentException("Illegal escape in " + string);
                    }
                    c = string.charAt(n2++);
                }
                stringBuffer.append(c);
            }
            item2 = new Directory(stringBuffer.toString(), true);
            if (pluginDescriptor != null) {
                item2.initPluginDescriptor(pluginDescriptor);
            }
            item.add(item2);
            item = item2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean activateItems() {
        boolean bl = false;
        Object object = this.writeLock;
        synchronized (object) {
            this.beginXA();
            try {
                Item[] itemArray;
                do {
                    itemArray = this.findAll(ACTIVATED, Boolean.FALSE, false);
                    ++this.activationStamp;
                    for (int i = 0; i < itemArray.length; ++i) {
                        bl = true;
                        itemArray[i].activate();
                    }
                } while (itemArray.length > 0);
            }
            finally {
                this.commitXA(false);
            }
        }
        return bl;
    }

    public int getActivationStamp() {
        return this.activationStamp;
    }

    public void startup() {
        if (this.active) {
            throw new IllegalStateException(this + " is already active");
        }
        this.activateItems();
        do {
            this.runAfterCommit();
        } while (this.activateItems());
        this.root.updateChildren(true);
        this.active = true;
    }

    public boolean isActive() {
        return this.active;
    }

    public void dispose() {
        if (this.project != null) {
            this.project.close();
        }
        this.setFileSystem(null);
        Handler[] handlerArray = this.logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            this.logger.removeHandler(handlerArray[i]);
        }
    }

    public Object setUserProperty(int n, Object object) {
        return this.userProperties.synchronizedPut(n, object);
    }

    public Object getUserProperty(int n) {
        return this.userProperties.synchronizedGet(n);
    }

    private void updateFields(Item item) {
        if (this.fieldChanged.contains(item)) {
            this.fireTreeNodesChanged(item);
        }
        for (item = (Item)item.getBranch(); item != null; item = (Item)item.getSuccessor()) {
            this.updateFields(item);
        }
    }

    void fireTreeNodesChanged(Item item) {
        this.treeMulticaster.treeNodesChanged(((Item)item.getAxisParent()).createTreeModelEvent(item));
    }

    public void transactionApplied(Transaction.Data data, boolean bl) {
        assert (Thread.holdsLock(this.writeLock));
        this.fieldChanged.clear();
        this.structureChanged.clear();
        this.reader.getQueue().restore(data);
        this.reader.resetCursor();
        try {
            if (bl) {
                this.reader.supplyInverse(this);
            } else {
                this.reader.supply(this);
            }
        }
        catch (IOException iOException) {
            throw new FatalPersistenceException(iOException);
        }
        if (!this.structureChanged.isEmpty()) {
            for (int i = this.itemMap.size() - 1; i >= 0; --i) {
                this.itemMap.setValueAt(i, null);
            }
            ++this.stamp;
            new TreeDiff().compare(this.oldTree, this, this, this, this.treeMulticaster);
            this.root.updateChildren(true);
        }
        if (!this.fieldChanged.isEmpty()) {
            this.updateFields(this.root);
        }
    }

    public void setField(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Transaction.Reader reader) {
        if (persistenceCapable instanceof Item) {
            this.fieldChanged.addIfNotContained(persistenceCapable);
        }
    }

    public void insertComponent(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Transaction.Reader reader) {
        this.setField(persistenceCapable, persistenceField, nArray, reader);
    }

    public void removeComponent(PersistenceCapable persistenceCapable, PersistenceField persistenceField, int[] nArray, Transaction.Reader reader) {
        this.setField(persistenceCapable, persistenceField, nArray, reader);
    }

    public void addEdgeBits(Node node, Node node2, int n) {
        if ((n & 0x100) != 0) {
            if ((node = node.getAxisParent()) == null) {
                node = node2.getAxisParent();
            }
        } else if ((n & 0x200) == 0) {
            node = null;
        }
        if (node != null) {
            this.structureChanged.addIfNotContained(node);
        }
    }

    public void removeEdgeBits(Node node, Node node2, int n) {
        this.addEdgeBits(node, node2, n);
    }

    public void makePersistent(long l, ManageableType manageableType) {
    }

    public void makeTransient(PersistenceCapable persistenceCapable, ManageableType manageableType) {
    }

    public void readData(PersistenceCapable persistenceCapable, Transaction.Reader reader) {
    }

    public void begin() {
    }

    public void end() {
    }

    public SharedObjectProvider lookup(String string) {
        return "/".equals(string) ? this : ("MetaGraph".equals(string) ? this.project : null);
    }

    public String getProviderName() {
        return "/";
    }

    public ResolvableReference readReference(PersistenceInput persistenceInput) throws IOException {
        final String string = persistenceInput.readString();
        Shareable shareable = this.getShareable(string);
        if (shareable != null) {
            this.ref.object = shareable;
            return this.ref;
        }
        return new ResolvableReference(){

            public Shareable resolve() {
                return Registry.this.getShareable(string);
            }

            public boolean isResolvable() {
                return Registry.this.getShareable(string) != null;
            }
        };
    }

    public void writeObject(Shareable shareable, PersistenceOutput persistenceOutput) throws IOException {
        shareable.getProvider().writeObject(shareable, persistenceOutput);
    }

    Shareable getShareable(String string) {
        Object object;
        Item item = Item.resolveItem(this, string);
        if (item instanceof ObjectItem && (object = ((ObjectItem)item).getObject()) instanceof Shareable) {
            return (Shareable)object;
        }
        return null;
    }

    public SAXSource createXMLSource(Collection collection) {
        return new XMLSerializer(this, collection);
    }

    public ContentHandler createXMLReader() {
        return new XMLRegistryReader(this, null, this.regGraph.getBindings(), this.root, true);
    }

    public boolean equals(Object object, Object object2) {
        return object == object2;
    }

    public TreeDiff.DiffInfo getDiffInfo(Object object) {
        return ((Item)object).getDiffInfo();
    }

    public ClassLoader getClassLoader() {
        return Main.getLoaderForAll();
    }

    public Class classForName(String string) throws ClassNotFoundException {
        return (Class)this.typeForName(string, true);
    }

    public Type typeForName(String string) throws ClassNotFoundException {
        return (Type)this.typeForName(string, false);
    }

    private Object typeForName(String string, boolean bl) throws ClassNotFoundException {
        Serializable serializable;
        Object object = this.pluginTypes.get(string);
        if (object != null) {
            return bl ? ((Type)object).getImplementationClass() : object;
        }
        if (this.root != null && (object = this.getItem("/classes/" + string)) instanceof ObjectItem && ((ObjectItem)object).isInstance(Type.TYPE)) {
            Type type = (Type)((ObjectItem)object).getObject();
            return bl ? type.getImplementationClass() : type;
        }
        for (serializable = (Item)this.getRootRegistry().getPluginDirectory().getBranch(); serializable != null; serializable = (Item)serializable.getSuccessor()) {
            PluginClassLoader pluginClassLoader;
            if (!(serializable instanceof PluginDescriptor) || (pluginClassLoader = ((PluginDescriptor)serializable).getPluginClassLoader()) == null) continue;
            try {
                Type type = pluginClassLoader.typeForName(string);
                this.pluginTypes.put(string, type);
                return bl ? type.getImplementationClass() : type;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        serializable = Class.forName(string, false, this.getClassLoader());
        return bl ? serializable : ClassAdapter.wrap(serializable, false);
    }

    public static void setCurrent(RegistryContext registryContext) {
        REGISTRIES.set(registryContext != null ? registryContext.getRegistry() : null);
    }

    public static Registry current() {
        return (Registry)REGISTRIES.get();
    }
}

