/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.util.Disposable;
import de.grogra.util.MutableTreeModel;
import de.grogra.xl.lang.ObjectToBoolean;
import java.util.Comparator;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeMapper
implements TreeModelListener,
Disposable {
    protected final TreeModel source;
    protected final MutableTreeModel target;
    protected Object root;
    private final Comparator comparator;
    private ObjectToBoolean filter = null;
    private boolean disposed = false;

    public AbstractTreeMapper(TreeModel treeModel, Object object, MutableTreeModel mutableTreeModel, Comparator comparator) {
        this.source = treeModel;
        this.target = mutableTreeModel;
        this.root = object;
        this.comparator = comparator;
    }

    public TreeModel getSourceTree() {
        return this.source;
    }

    public void installListener() {
        this.source.addTreeModelListener(this);
    }

    public void setFilter(ObjectToBoolean objectToBoolean) {
        this.filter = objectToBoolean;
    }

    public void map() {
        Object object = this.createNode(this.root, null);
        if (!this.source.isLeaf(this.root)) {
            int n = this.source.getChildCount(this.root);
            for (int i = 0; i < n; ++i) {
                Object object2 = this.source.getChild(this.root, i);
                if (!this.filter(object2)) continue;
                this.createAndInsert(object2, object, Integer.MAX_VALUE);
            }
        }
        this.target.setRoot(object);
        this.targetChanged(object);
    }

    protected boolean filter(Object object) {
        return this.filter == null || this.filter.evaluateBoolean(object);
    }

    public boolean sourceNodesEqual(Object object, Object object2) {
        return object == object2 || (this.comparator == null ? object.equals(object2) : this.comparator.compare(object, object2) == 0);
    }

    protected void createAndInsert(Object object, Object object2, int n) {
        Object object3 = this.createNode(object, object2);
        this.target.insert(object2, Math.min(n, this.target.getChildCount(object2)), object3, null);
        if (!this.source.isLeaf(object)) {
            int n2 = this.source.getChildCount(object);
            for (int i = 0; i < n2; ++i) {
                Object object4 = this.source.getChild(object, i);
                if (!this.filter(object4)) continue;
                this.createAndInsert(object4, object3, Integer.MAX_VALUE);
            }
        }
    }

    protected Object getImage(Object object, Object object2) {
        int n = this.target.getChildCount(object2);
        for (int i = 0; i < n; ++i) {
            Object object3 = this.target.getChild(object2, i);
            if (!this.isImage(object, object3)) continue;
            return object3;
        }
        return null;
    }

    protected abstract Object createNode(Object var1, Object var2);

    protected void update(Object object, TreePath treePath) {
        this.target.valueForPathChanged(treePath, object);
    }

    protected abstract boolean isImage(Object var1, Object var2);

    protected void targetChanged(Object object) {
    }

    private Object filter(TreeModelEvent treeModelEvent, boolean bl) {
        TreePath treePath;
        int n;
        TreePath treePath2 = treeModelEvent.getTreePath();
        Object object = null;
        for (n = 0; n < treePath2.getPathCount(); ++n) {
            object = treePath2.getPathComponent(n);
            if (!this.filter(object)) {
                return null;
            }
            if (this.sourceNodesEqual(object, this.root)) break;
            object = null;
        }
        if (object == null) {
            return null;
        }
        Object object2 = this.target.getRoot();
        TreePath treePath3 = treePath = bl ? new TreePath(object2) : null;
        while (++n < treePath2.getPathCount()) {
            object = treePath2.getPathComponent(n);
            if (!this.filter(object)) {
                return null;
            }
            if ((object2 = this.getImage(object, object2)) == null) {
                return null;
            }
            if (!bl) continue;
            treePath = treePath.pathByAddingChild(object2);
        }
        return bl ? treePath : object2;
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        block5: {
            Object[] objectArray;
            block6: {
                TreePath treePath = (TreePath)this.filter(treeModelEvent, true);
                objectArray = treeModelEvent.getChildren();
                if (treePath == null) break block6;
                if (objectArray == null) {
                    assert (treePath.getPathCount() == 1);
                    this.root = treeModelEvent.getTreePath().getLastPathComponent();
                    this.update(this.root, treePath);
                } else {
                    Object object = treePath.getLastPathComponent();
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object2;
                        Object object3 = objectArray[i];
                        if (!this.filter(object3) || (object2 = this.getImage(object3, object)) == null) continue;
                        this.update(object3, treePath.pathByAddingChild(object2));
                    }
                }
                break block5;
            }
            if (objectArray == null) break block5;
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.sourceNodesEqual(objectArray[i], this.root)) continue;
                this.root = objectArray[i];
                this.update(this.root, new TreePath(this.target.getRoot()));
                this.targetChanged(this.target.getRoot());
                break;
            }
        }
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        Object object = this.filter(treeModelEvent, false);
        if (object != null) {
            Object object2 = treeModelEvent.getTreePath().getLastPathComponent();
            Object[] objectArray = treeModelEvent.getChildren();
            int[] nArray = treeModelEvent.getChildIndices();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object3 = objectArray[i];
                if (!this.filter(object3)) continue;
                Object object4 = null;
                int n = nArray[i];
                while (--n >= 0 && (object4 = this.getImage(this.source.getChild(object2, n), object)) == null) {
                }
                if (object4 != null) {
                    n = this.target.getIndexOfChild(object, object4) + 1;
                } else {
                    n = nArray[i];
                    int n2 = this.source.getChildCount(object2);
                    while (++n < n2 && (object4 = this.getImage(this.source.getChild(object2, n), object)) == null) {
                    }
                    n = object4 != null ? this.target.getIndexOfChild(object, object4) : Integer.MAX_VALUE;
                }
                this.createAndInsert(object3, object, n);
            }
            this.targetChanged(object);
        }
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        Object object = this.filter(treeModelEvent, false);
        if (object != null) {
            Object[] objectArray = treeModelEvent.getChildren();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                if (!this.filter(object2) || (object2 = this.getImage(object2, object)) == null) continue;
                this.target.remove(object, this.target.getIndexOfChild(object, object2));
                this.nodeRemoved(object2);
            }
            this.targetChanged(object);
        }
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        Object object = this.filter(treeModelEvent, false);
        if (object != null) {
            int n;
            Object object2 = treeModelEvent.getTreePath().getLastPathComponent();
            for (n = this.target.getChildCount(object) - 1; n >= 0; --n) {
                Object object3 = this.target.getChild(object, n);
                this.target.remove(object, n);
                this.nodeRemoved(object3);
            }
            if (!this.source.isLeaf(object2)) {
                n = this.source.getChildCount(object2);
                for (int i = 0; i < n; ++i) {
                    Object object4 = this.source.getChild(object2, i);
                    if (!this.filter(object4)) continue;
                    this.createAndInsert(object4, object, Integer.MAX_VALUE);
                }
            }
            this.targetChanged(object);
        }
    }

    protected void nodeRemoved(Object object) {
    }

    public final void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.source.removeTreeModelListener(this);
        this.disposeImpl();
    }

    protected void disposeImpl() {
    }
}

