/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.util.Configurable;
import de.grogra.util.Configuration;
import de.grogra.util.KeyDescription;
import de.grogra.util.ModifiableMap;
import java.util.IdentityHashMap;
import java.util.Iterator;

public final class ConfigurationSet
implements ModifiableMap {
    private final IdentityHashMap configs = new IdentityHashMap();
    private final IdentityHashMap configurables = new IdentityHashMap();
    private final String name;

    public ConfigurationSet(String string) {
        this.name = string;
    }

    public void add(Configuration configuration) {
        this.configs.put(configuration, this);
    }

    public void add(Configurable configurable) {
        if (this.configurables.put(configurable, this) == null) {
            configurable.addConfigurations(this);
        }
    }

    public int size() {
        return this.configs.size();
    }

    public Object put(Object object, Object object2) {
        for (Configuration configuration : this.configs.keySet()) {
            if (!configuration.contains(object)) continue;
            Object object3 = configuration.get(object, null);
            configuration.put(object, object2);
            return object3;
        }
        return null;
    }

    public Object get(Object object, Object object2) {
        for (Configuration configuration : this.configs.keySet()) {
            Object object3;
            if (!configuration.contains(object) || (object3 = configuration.get(object, DEFAULT_VALUE)) == DEFAULT_VALUE) continue;
            return object3;
        }
        return object2;
    }

    public void writeBack() {
        Iterator iterator = this.configs.keySet().iterator();
        while (iterator.hasNext()) {
            ((Configuration)iterator.next()).writeBack();
        }
    }

    public KeyDescription[] getKeyDescriptions() {
        int n = 0;
        KeyDescription[] keyDescriptionArray = this.configs.keySet().iterator();
        while (keyDescriptionArray.hasNext()) {
            n += ((Configuration)keyDescriptionArray.next()).keys.length;
        }
        keyDescriptionArray = new KeyDescription[n];
        n = 0;
        for (Configuration configuration : this.configs.keySet()) {
            System.arraycopy(configuration.keys, 0, keyDescriptionArray, n, configuration.keys.length);
            n += configuration.keys.length;
        }
        return keyDescriptionArray;
    }

    public String getName() {
        return this.name;
    }
}

