/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.util.CompoundEnumeration;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingClassLoader
extends ClassLoader {
    private final ClassLoader[] parents;

    public DelegatingClassLoader(ClassLoader[] classLoaderArray) {
        super(classLoaderArray[0]);
        this.parents = classLoaderArray;
    }

    public int getParentCount() {
        return this.parents.length;
    }

    public ClassLoader getParent(int n) {
        return this.parents[n];
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        for (int i = this.parents.length - 1; i >= 1; --i) {
            try {
                return Class.forName(string, false, this.parents[i]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        return super.findClass(string);
    }

    @Override
    protected URL findResource(String string) {
        for (int i = this.parents.length - 1; i >= 1; --i) {
            URL uRL = this.parents[i].getResource(string);
            if (uRL == null) continue;
            return uRL;
        }
        return super.findResource(string);
    }

    @Override
    protected Enumeration<URL> findResources(String string) throws IOException {
        CompoundEnumeration<URL> compoundEnumeration = new CompoundEnumeration<URL>(true);
        for (int i = this.parents.length - 1; i >= 0; --i) {
            compoundEnumeration.add(this.parents[i].getResources(string));
        }
        return compoundEnumeration;
    }
}

