/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.util.Disposable;
import de.grogra.util.Map;
import de.grogra.util.ModifiableMap;
import de.grogra.util.Utils;
import de.grogra.xl.util.ObjectList;
import de.grogra.xl.util.XHashMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Random;
import java.util.TreeMap;

public class StringMap
implements ModifiableMap,
Serializable {
    private static final long serialVersionUID = 2334469118725787256L;
    public static final Type TYPE = ClassAdapter.wrap(StringMap.class);
    private final boolean reverseSort;
    private String[] keys;
    private Object[] values;
    private int size;
    private Map parent;

    public StringMap(int n, boolean bl) {
        this.reverseSort = bl;
        if (n <= 0) {
            n = 2;
        }
        this.keys = new String[n];
        this.values = new Object[n];
        this.size = 0;
        this.parent = null;
    }

    public StringMap(int n) {
        this(n, false);
    }

    public StringMap() {
        this(16);
    }

    public StringMap(Object[] objectArray) {
        this(objectArray.length);
        for (int i = 0; i < objectArray.length; i += 2) {
            this.put((String)objectArray[i], objectArray[i + 1]);
        }
    }

    public StringMap(Map map) {
        this();
        this.parent = map;
    }

    public StringMap dup() {
        StringMap stringMap = new StringMap(this.size, this.reverseSort);
        stringMap.size = this.size;
        System.arraycopy(this.keys, 0, stringMap.keys, 0, this.size);
        System.arraycopy(this.values, 0, stringMap.values, 0, this.size);
        return stringMap;
    }

    public final String[] getKeys() {
        String[] stringArray = new String[this.size];
        System.arraycopy(this.keys, 0, stringArray, 0, this.size);
        return stringArray;
    }

    public final void getValues(Object[] objectArray) {
        System.arraycopy(this.values, 0, objectArray, 0, this.size);
    }

    public final int findIndex(String string) {
        return this.findIndex(string, 0, string.length());
    }

    public final int findIndex(String string, int n, int n2) {
        int n3 = 0;
        int n4 = this.size;
        while (n3 < n4) {
            int n5;
            block8: {
                block9: {
                    int n6;
                    int n7;
                    n5 = n3 + n4 >> 1;
                    String string2 = this.keys[n5];
                    if (this.reverseSort) {
                        n7 = string2.length();
                        for (n6 = n2 - 1; n6 >= 0; --n6) {
                            if (--n7 < 0) break block8;
                            int n8 = string2.charAt(n7) - string.charAt(n + n6);
                            if (n8 > 0) break block9;
                            if (n8 >= 0) {
                                continue;
                            }
                            break block8;
                        }
                    } else {
                        for (n7 = 0; n7 < n2; ++n7) {
                            if (n7 == string2.length()) break block8;
                            n6 = string2.charAt(n7) - string.charAt(n + n7);
                            if (n6 > 0) break block9;
                            if (n6 >= 0) {
                                continue;
                            }
                            break block8;
                        }
                    }
                    if (n2 == string2.length()) {
                        return n5;
                    }
                }
                n4 = n5;
                continue;
            }
            n3 = n5 + 1;
        }
        return ~n3;
    }

    public final int findIndex(CharSequence charSequence, int n, int n2, int n3, int n4) {
        while (n3 < n4) {
            int n5;
            block8: {
                block9: {
                    int n6;
                    int n7;
                    n5 = n3 + n4 >> 1;
                    String string = this.keys[n5];
                    if (this.reverseSort) {
                        n7 = string.length();
                        for (n6 = n2 - 1; n6 >= 0; --n6) {
                            if (--n7 < 0) break block8;
                            int n8 = string.charAt(n7) - charSequence.charAt(n + n6);
                            if (n8 > 0) break block9;
                            if (n8 >= 0) {
                                continue;
                            }
                            break block8;
                        }
                    } else {
                        for (n7 = 0; n7 < n2; ++n7) {
                            if (n7 == string.length()) break block8;
                            n6 = string.charAt(n7) - charSequence.charAt(n + n7);
                            if (n6 > 0) break block9;
                            if (n6 >= 0) {
                                continue;
                            }
                            break block8;
                        }
                    }
                    if (n2 == string.length()) {
                        return n5;
                    }
                }
                n4 = n5;
                continue;
            }
            n3 = n5 + 1;
        }
        return ~n3;
    }

    public final synchronized Object synchronizedPut(String string, Object object) {
        return this.put(string, object);
    }

    public final Object put(Object object, Object object2) {
        return this.put((String)object, object2);
    }

    public final Object put(String string, Object object) {
        int n = this.findIndex(string, 0, string.length());
        if (n >= 0) {
            Object object2 = this.values[n];
            this.values[n] = object;
            return object2;
        }
        n ^= 0xFFFFFFFF;
        if (this.keys.length == this.size) {
            this.keys = new String[2 * this.size];
            System.arraycopy(this.keys, 0, this.keys, 0, this.size);
            this.values = new Object[2 * this.size];
            System.arraycopy(this.values, 0, this.values, 0, this.size);
        }
        if (n < this.size) {
            System.arraycopy(this.keys, n, this.keys, n + 1, this.size - n);
            System.arraycopy(this.values, n, this.values, n + 1, this.size - n);
        }
        this.keys[n] = string;
        this.values[n] = object;
        ++this.size;
        return null;
    }

    public final synchronized Object synchronizedGet(String string) {
        return this.get(string);
    }

    public final Object get(String string) {
        int n = this.findIndex(string, 0, string.length());
        return n >= 0 ? this.values[n] : (this.parent != null ? this.parent.get(string, null) : null);
    }

    public final Object get(String string, boolean bl) {
        int n = this.findIndex(string, 0, string.length());
        return n >= 0 ? this.values[n] : (bl && this.parent != null ? this.parent.get(string, null) : null);
    }

    public final synchronized Object synchronizedRemove(String string) {
        return this.remove(string);
    }

    public final Object remove(String string) {
        int n = this.findIndex(string, 0, string.length());
        if (n >= 0) {
            return this.removeAt(n);
        }
        return null;
    }

    public final Object removeAt(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n));
        }
        Object object = this.values[n];
        --this.size;
        System.arraycopy(this.keys, n + 1, this.keys, n, this.size - n);
        System.arraycopy(this.values, n + 1, this.values, n, this.size - n);
        this.keys[this.size] = null;
        this.values[this.size] = null;
        return object;
    }

    public final boolean containsKey(String string) {
        return this.findIndex(string, 0, string.length()) >= 0 || this.parent != null && this.parent.get(string, DEFAULT_VALUE) != DEFAULT_VALUE;
    }

    public final boolean containsKey(Object object) {
        String string;
        if (object instanceof String && this.findIndex(string = (String)object, 0, string.length()) >= 0) {
            return true;
        }
        return this.parent != null && this.parent.get(object, DEFAULT_VALUE) != DEFAULT_VALUE;
    }

    public final Object get(Object object, Object object2) {
        int n;
        if (object instanceof String && (n = this.findIndex((String)object, 0, ((String)object).length())) >= 0) {
            return this.values[n];
        }
        return this.parent != null ? this.parent.get(object, object2) : object2;
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final String getKeyAt(int n) {
        return this.keys[n];
    }

    public final Object getValueAt(int n) {
        return this.values[n];
    }

    public final Object setValueAt(int n, Object object) {
        Object object2 = this.values[n];
        this.values[n] = object;
        return object2;
    }

    public final void clear() {
        for (int i = this.size - 1; i >= 0; --i) {
            this.keys[i] = null;
            this.values[i] = null;
        }
        this.size = 0;
    }

    public final void disposeValuesAndClear() {
        while (true) {
            int n = --this.size;
            if (this.size < 0) break;
            this.keys[n] = null;
            if (this.values[n] instanceof Disposable) {
                ((Disposable)this.values[n]).dispose();
            }
            this.values[n] = null;
        }
        this.size = 0;
    }

    public final StringMap putBoolean(String string, boolean bl) {
        this.put(string, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        return this;
    }

    public final boolean getBoolean(String string) {
        Object object = this.get(string);
        return object != null ? (Boolean)object : false;
    }

    public final boolean getBoolean(String string, boolean bl) {
        Object object = this.get(string);
        return object != null ? (Boolean)object : bl;
    }

    public final StringMap putByte(String string, byte by) {
        this.put(string, (Object)by);
        return this;
    }

    public final byte getByte(String string) {
        Object object = this.get(string);
        return object != null ? ((Number)object).byteValue() : (byte)0;
    }

    public final byte getByte(String string, byte by) {
        Object object = this.get(string);
        return object != null ? ((Number)object).byteValue() : by;
    }

    public final StringMap putShort(String string, short s) {
        this.put(string, (Object)s);
        return this;
    }

    public final short getShort(String string) {
        Object object = this.get(string);
        return object != null ? ((Number)object).shortValue() : (short)0;
    }

    public final short getShort(String string, short s) {
        Object object = this.get(string);
        return object != null ? ((Number)object).shortValue() : s;
    }

    public final StringMap putChar(String string, char c) {
        this.put(string, (Object)Character.valueOf(c));
        return this;
    }

    public final char getChar(String string) {
        Object object = this.get(string);
        return object != null ? ((Character)object).charValue() : (char)'\u0000';
    }

    public final char getChar(String string, char c) {
        Object object = this.get(string);
        return object != null ? ((Character)object).charValue() : c;
    }

    public final StringMap putInt(String string, int n) {
        this.put(string, (Object)n);
        return this;
    }

    public final int getInt(String string) {
        Object object = this.get(string);
        return object != null ? ((Number)object).intValue() : 0;
    }

    public final int getInt(String string, int n) {
        Object object = this.get(string);
        return object != null ? ((Number)object).intValue() : n;
    }

    public final StringMap putLong(String string, long l) {
        this.put(string, (Object)l);
        return this;
    }

    public final long getLong(String string) {
        Object object = this.get(string);
        return object != null ? ((Number)object).longValue() : 0L;
    }

    public final long getLong(String string, long l) {
        Object object = this.get(string);
        return object != null ? ((Number)object).longValue() : l;
    }

    public final StringMap putFloat(String string, float f) {
        this.put(string, (Object)Float.valueOf(f));
        return this;
    }

    public final float getFloat(String string) {
        Object object = this.get(string);
        return object != null ? ((Number)object).floatValue() : 0.0f;
    }

    public final float getFloat(String string, float f) {
        Object object = this.get(string);
        return object != null ? ((Number)object).floatValue() : f;
    }

    public final StringMap putDouble(String string, double d) {
        this.put(string, (Object)d);
        return this;
    }

    public final double getDouble(String string) {
        Object object = this.get(string);
        return object != null ? ((Number)object).doubleValue() : 0.0;
    }

    public final double getDouble(String string, double d) {
        Object object = this.get(string);
        return object != null ? ((Number)object).doubleValue() : d;
    }

    public final StringMap putObject(String string, Object object) {
        this.put(string, object);
        return this;
    }

    public final Object getObject(String string) {
        return this.get(string);
    }

    public final Object getObject(String string, Object object) {
        return this.get((Object)string, object);
    }

    public final String getString(String string) {
        return (String)this.get(string);
    }

    public final java.util.Map toMap() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        for (int i = 0; i < this.size; ++i) {
            treeMap.put(this.keys[i], this.values[i]);
        }
        return treeMap;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("StringMap{");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.keys[i]).append("->").append(this.values[i]);
        }
        return stringBuffer.append('}').toString();
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        int n3;
        int n4;
        String[] stringArray2 = new String[]{"get", "set", "is", "to", "value", "string", "map", "int", "put", "remove", "add", "contained", "out", "parent", "size"};
        Random random = new Random();
        StringBuffer stringBuffer = new StringBuffer();
        ObjectList<String> objectList = new ObjectList<String>();
        for (n4 = 0; n4 < 100000; ++n4) {
            stringBuffer.setLength(0);
            n3 = 1 + random.nextInt(4);
            while (--n3 >= 0) {
                stringBuffer.append(stringArray2[random.nextInt(stringArray2.length)]);
            }
            objectList.add(stringBuffer.toString());
        }
        stringArray2 = new String[objectList.size];
        objectList.toArray(stringArray2);
        n4 = stringArray2.length - 1;
        n3 = n4 / 2;
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        HashMap<String, String[]> hashMap2 = new HashMap<String, String[]>();
        XHashMap<String, String[]> xHashMap = new XHashMap<String, String[]>();
        Utils.resetTime();
        for (n2 = n3; n2 >= 0; --n2) {
            hashMap.put(stringArray2[n2], stringArray2);
        }
        Utils.printTime("put H1");
        Utils.resetTime();
        for (n2 = n3; n2 >= 0; --n2) {
            hashMap2.put(stringArray2[n2], stringArray2);
        }
        Utils.printTime("put H2");
        Utils.resetTime();
        for (n2 = n3; n2 >= 0; --n2) {
            xHashMap.put(stringArray2[n2], stringArray2);
        }
        Utils.printTime("put X");
        StringMap stringMap = new StringMap();
        Utils.resetTime();
        for (n = n3; n >= 0; --n) {
            stringMap.put(stringArray2[n], (Object)stringArray2);
        }
        Utils.printTime("put S");
        for (n = n4; n >= 0; --n) {
            stringArray2[n] = new String(stringArray2[n]);
        }
        Utils.resetTime();
        for (n = n4; n >= 0; --n) {
            hashMap.get(stringArray2[n]);
        }
        Utils.printTime("get H1");
        Utils.resetTime();
        for (n = n4; n >= 0; --n) {
            hashMap2.get(stringArray2[n]);
        }
        Utils.printTime("get H2");
        Utils.resetTime();
        for (n = n4; n >= 0; --n) {
            xHashMap.get(stringArray2[n], null);
        }
        Utils.printTime("get X");
        Utils.resetTime();
        for (n = n4; n >= 0; --n) {
            stringMap.get(stringArray2[n]);
        }
        Utils.printTime("get S");
    }
}

