/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.util;

import de.grogra.xl.util.ObjectList;

public final class ThreadContext {
    private static final ThreadLocal CONTEXT = new ThreadLocal();
    public static final short MIN_PRIORITY = 0;
    public static final short NORMAL_PRIORITY = 10000;
    public static final short MAX_PRIORITY = Short.MAX_VALUE;
    private short priority = (short)10000;
    private Thread thread;
    private final int id;
    private static int nextId = 0;
    private static int registeredPropertyCount = 0;
    private ObjectList<Object> properties = new ObjectList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadContext() {
        ThreadLocal threadLocal = CONTEXT;
        synchronized (threadLocal) {
            this.id = nextId++;
        }
    }

    public int getId() {
        return this.id;
    }

    public static ThreadContext current() {
        ThreadContext threadContext = (ThreadContext)CONTEXT.get();
        if (threadContext != null) {
            return threadContext;
        }
        threadContext = new ThreadContext();
        threadContext.join();
        return threadContext;
    }

    public boolean isCurrent() {
        return this == CONTEXT.get();
    }

    public Thread getThread() {
        return this.thread;
    }

    public ThreadContext check() {
        if (this.thread != Thread.currentThread()) {
            throw new AssertionError((Object)(this.thread + " " + Thread.currentThread()));
        }
        return this;
    }

    public static synchronized int registerProperty() {
        return registeredPropertyCount++;
    }

    public Object getProperty(int n) {
        return this.properties.get(n);
    }

    public void setProperty(int n, Object object) {
        this.properties.set(n, object);
    }

    public void checkInterruption() throws InterruptedException {
        if (this.thread.isInterrupted()) {
            if (Thread.currentThread() != this.thread) {
                throw new IllegalStateException(this + " has to be joined with the current thread.");
            }
            Thread.interrupted();
            throw new InterruptedException();
        }
    }

    public void join() {
        Thread thread = Thread.currentThread();
        if (this.thread == thread) {
            return;
        }
        if (this.thread != null) {
            throw new IllegalStateException(this + " is already joined.");
        }
        if (CONTEXT.get() != null) {
            throw new IllegalStateException("Thread " + this.thread + " already has a joined" + " ThreadContext");
        }
        this.thread = thread;
        CONTEXT.set(this);
    }

    public void leave() {
        if (this.thread == null) {
            return;
        }
        if (this.thread != Thread.currentThread()) {
            throw new IllegalStateException("thread differs from current thread.");
        }
        CONTEXT.set(null);
        this.thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinWhileExecuting(Runnable runnable) {
        Thread thread = this.thread;
        ThreadContext threadContext = (ThreadContext)CONTEXT.get();
        this.thread = Thread.currentThread();
        CONTEXT.set(this);
        try {
            runnable.run();
        }
        finally {
            this.thread = thread;
            CONTEXT.set(threadContext);
        }
    }

    public boolean hasHigherPriorityThan(ThreadContext threadContext) {
        return this.priority > threadContext.priority || this.priority == threadContext.priority && this.id > threadContext.id && this.priority != Integer.MIN_VALUE;
    }

    public short getPriority() {
        return this.priority;
    }

    public void setPriority(short s) {
        this.priority = s;
    }
}

