/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vfs;

import de.grogra.vfs.FileSystem;
import de.grogra.vfs.FileSystemBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.jar.Attributes;
import javax.swing.event.TreeModelEvent;

public class JoinedFileSystem
extends FileSystemBase {
    final Entry root;
    final HashMap<FileSystem, Entry> fsToEntry = new HashMap(10);
    final HashMap<String, Entry> nameToEntry = new HashMap(10);

    public JoinedFileSystem(String string, String string2) {
        super(string, string2);
        this.root = new Entry(null, null, null);
    }

    public boolean isPersistent() {
        return false;
    }

    public void delete(Object object) throws IOException {
        TreeModelEvent treeModelEvent = this.getEventFor(object);
        Entry entry = (Entry)object;
        if (entry.file == null) {
            throw new IOException("Cannot delete " + entry);
        }
        entry.fs.delete(entry.file);
        this.fireTreeModelEvent(2, treeModelEvent);
    }

    public String getName(Object object) {
        Entry entry = (Entry)object;
        return entry.file != null ? entry.fs.getName(entry.file) : entry.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getParent(Object object) {
        Entry entry = (Entry)object;
        if (entry.file != null) {
            Entry entry2;
            Object object2 = entry.fs.getParent(entry.file);
            JoinedFileSystem joinedFileSystem = this;
            synchronized (joinedFileSystem) {
                entry2 = this.fsToEntry.get(entry.fs);
            }
            if (entry.fs.equals(object2, entry2.root)) {
                return entry2;
            }
            return new Entry(entry.fs, object2);
        }
        return entry.fs != null ? this.root : null;
    }

    public boolean isLeaf(Object object) {
        Entry entry = (Entry)object;
        return entry.file != null && entry.fs.isLeaf(entry.file);
    }

    public boolean isReadOnly(Object object) {
        Entry entry = (Entry)object;
        return object == this.root || entry.file != null && entry.fs.isReadOnly(entry.file);
    }

    public long getTime(Object object) {
        Entry entry = (Entry)object;
        return entry.file != null ? entry.fs.getTime(entry.file) : entry.time;
    }

    public void setTime(Object object, long l) {
        Entry entry = (Entry)object;
        if (entry.file != null) {
            entry.fs.setTime(entry.file, l);
        } else {
            entry.time = l;
        }
    }

    public long getSize(Object object) {
        Entry entry = (Entry)object;
        return entry.file != null ? entry.fs.getSize(entry.file) : 0L;
    }

    public Object getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] listFiles(Object object) {
        Entry entry = (Entry)object;
        if (entry.fs != null) {
            Object[] objectArray = entry.fs.listFiles(entry.getFile());
            Object[] objectArray2 = new Entry[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = new Entry(entry.fs, objectArray[i]);
            }
            return objectArray2;
        }
        JoinedFileSystem joinedFileSystem = this;
        synchronized (joinedFileSystem) {
            return this.fsToEntry.values().toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFile(Object object, String string) {
        Entry entry = (Entry)object;
        if (entry.fs != null) {
            Object object2 = entry.fs.getFile(entry.getFile(), string);
            return object2 != null ? new Entry(entry.fs, object2) : null;
        }
        JoinedFileSystem joinedFileSystem = this;
        synchronized (joinedFileSystem) {
            return this.nameToEntry.get(string);
        }
    }

    protected Object createImpl(Object object, String string, boolean bl) throws IOException {
        Entry entry = (Entry)object;
        if (entry.fs != null) {
            return new Entry(entry.fs, entry.fs.create(entry.getFile(), string, bl));
        }
        throw new IOException("Cannot create file in root directory");
    }

    public InputStream getInputStream(Object object) throws IOException {
        Entry entry = (Entry)object;
        return entry.fs.getInputStream(entry.file);
    }

    public OutputStream getOutputStream(Object object, boolean bl) throws IOException {
        Entry entry = (Entry)object;
        return new FileSystem.Out(entry.fs.getOutputStream(entry.file, bl), object);
    }

    public Attributes getAttributes(Object object, boolean bl) {
        Entry entry = (Entry)object;
        return entry.fs.getAttributes(entry.file, bl);
    }

    public synchronized void addFileSystem(FileSystem fileSystem, String string, Object object) {
        Entry entry = new Entry(fileSystem, string, object);
        Entry entry2 = this.nameToEntry.put(string, entry);
        if (entry2 != null) {
            this.fsToEntry.remove(entry2.fs);
        }
        this.fsToEntry.put(fileSystem, entry);
    }

    public synchronized void removeFileSystem(FileSystem fileSystem) {
        Entry entry = this.fsToEntry.remove(fileSystem);
        if (entry != null) {
            this.nameToEntry.remove(entry.name);
        }
    }

    public synchronized String getFileSystemName(FileSystem fileSystem) {
        Entry entry = this.fsToEntry.get(fileSystem);
        return entry != null ? entry.name : null;
    }

    private static class Entry {
        final FileSystem fs;
        final Object root;
        final Object file;
        final String name;
        long time;

        Entry(FileSystem fileSystem, Object object) {
            this.fs = fileSystem;
            this.file = object;
            this.root = null;
            this.name = null;
        }

        Entry(FileSystem fileSystem, String string, Object object) {
            this.fs = fileSystem;
            this.file = null;
            this.root = object;
            this.name = string;
            this.time = System.currentTimeMillis();
        }

        Object getFile() {
            return this.file != null ? this.file : this.root;
        }
    }
}

