/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vfs;

import de.grogra.util.Utils;
import de.grogra.vfs.FileSystemBase;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.event.TreeModelEvent;

public class MemoryFileSystem
extends FileSystemBase {
    final Entry root = new Entry(null, "", true);

    public MemoryFileSystem(String string) {
        super(string, "memfs");
    }

    public boolean isPersistent() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Object object) {
        TreeModelEvent treeModelEvent;
        MemoryFileSystem memoryFileSystem = this;
        synchronized (memoryFileSystem) {
            treeModelEvent = this.getEventFor(object);
            ((Entry)object).parent.files.remove(object);
        }
        this.fireTreeModelEvent(2, treeModelEvent);
    }

    public synchronized String getName(Object object) {
        return ((Entry)object).name;
    }

    public synchronized Object getParent(Object object) {
        return ((Entry)object).parent;
    }

    public synchronized boolean isLeaf(Object object) {
        return ((Entry)object).files == null;
    }

    public boolean isReadOnly(Object object) {
        return false;
    }

    public synchronized long getTime(Object object) {
        return ((Entry)object).time;
    }

    public void closeQuiet(Object object) {
        ((Entry)object).closeQuiet();
    }

    public synchronized void setTime(Object object, long l) {
        ((Entry)object).time = l;
    }

    public synchronized long getSize(Object object) {
        return ((Entry)object).bufForInputCount;
    }

    public Object getRoot() {
        return this.root;
    }

    public synchronized Object[] listFiles(Object object) {
        return ((Entry)object).files == null ? null : ((Entry)object).files.toArray();
    }

    public synchronized Object getFile(Object object, String string) {
        return ((Entry)object).getFile(string);
    }

    protected Object createImpl(Object object, String string, boolean bl) throws IOException {
        Entry entry = ((Entry)object).getFile(string);
        if (entry != null) {
            if (bl != (entry.files != null)) {
                throw new IOException("File " + entry + " exists.");
            }
        } else {
            return this.getEventFor(((Entry)object).createFile(string, bl));
        }
        return entry;
    }

    public synchronized InputStream getInputStream(Object object) {
        return new ByteArrayInputStream(((Entry)object).bufForInput, 0, ((Entry)object).bufForInputCount);
    }

    public synchronized OutputStream getOutputStream(Object object, boolean bl) {
        ((Entry)object).reset(bl);
        return (Entry)object;
    }

    public void removeNonlistedFiles(Collection collection) {
        this.removeNonlistedFiles(this.getRoot(), collection);
    }

    private boolean removeNonlistedFiles(Object object, Collection collection) {
        Object object2;
        boolean bl;
        if (!this.isLeaf(object)) {
            if (this.equals(object, this.getRoot())) {
                bl = true;
            } else {
                bl = false;
                object2 = this.listFiles(object);
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    if (!this.removeNonlistedFiles(object2[i], collection)) continue;
                    bl = true;
                    break;
                }
            }
        } else {
            bl = collection.contains(object);
        }
        if (!bl) {
            this.delete(object);
            object2 = this.getManifestName(object);
            if (((String)object2).length() > 0) {
                this.manifest.getEntries().remove(object2);
            }
        }
        return bl;
    }

    private class Entry
    extends ByteArrayOutputStream {
        final Entry parent;
        final String name;
        final ArrayList files;
        long time;
        byte[] bufForInput;
        int bufForInputCount;

        Entry(Entry entry, String string, boolean bl) {
            super(bl ? 0 : 128);
            this.time = System.currentTimeMillis();
            this.bufForInput = Utils.BYTE_0;
            this.bufForInputCount = 0;
            this.parent = entry;
            this.name = string;
            this.files = bl ? new ArrayList() : null;
        }

        Entry getFile(String string) {
            for (int i = this.files.size() - 1; i >= 0; --i) {
                if (!((Entry)this.files.get((int)i)).name.equals(string)) continue;
                return (Entry)this.files.get(i);
            }
            return null;
        }

        Entry createFile(String string, boolean bl) {
            Entry entry = new Entry(this, string, bl);
            this.files.add(entry);
            return entry;
        }

        void reset(boolean bl) {
            this.reset();
            this.buf = new byte[Math.max(256, bl ? this.bufForInputCount : this.bufForInputCount >> 1)];
            if (bl) {
                this.write(this.bufForInput, 0, this.bufForInputCount);
            }
        }

        public void flush() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            MemoryFileSystem memoryFileSystem = MemoryFileSystem.this;
            synchronized (memoryFileSystem) {
                this.time = System.currentTimeMillis();
                this.bufForInput = this.buf;
                this.bufForInputCount = this.count;
            }
            MemoryFileSystem.this.fireTreeModelEvent(0, MemoryFileSystem.this.getEventFor(this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeQuiet() {
            MemoryFileSystem memoryFileSystem = MemoryFileSystem.this;
            synchronized (memoryFileSystem) {
                this.time = System.currentTimeMillis();
                this.bufForInput = this.buf;
                this.bufForInputCount = this.count;
            }
        }
    }
}

