/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.util;

import de.grogra.xl.lang.CharConsumer;
import de.grogra.xl.lang.VoidToCharGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.CharBuffer;

public class CharList
implements Cloneable,
Serializable,
CharConsumer,
VoidToCharGenerator {
    private static final long serialVersionUID = -2541088057069128940L;
    public transient char[] elements;
    public int size = 0;
    private static final char[] EMPTY = new char[0];
    private static final char[] CHAR_NULL = new char[1024];

    public CharList(int n) {
        this.elements = new char[Math.max(n, 8)];
    }

    public CharList() {
        this(16);
    }

    public CharList(char[] cArray) {
        this(cArray.length);
        this.size = cArray.length;
        CharList.arraycopy(cArray, 0, this.elements, 0, this.size);
    }

    public Object clone() {
        try {
            CharList charList = (CharList)super.clone();
            charList.elements = new char[Math.max(this.size, 8)];
            CharList.arraycopy(this.elements, 0, charList.elements, 0, this.size);
            return charList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public void ensureCapacity(int n) {
        if (n > this.elements.length) {
            char[] cArray = new char[Math.max(n, this.elements.length * 2)];
            CharList.arraycopy(this.elements, 0, cArray, 0, this.size);
            this.elements = cArray;
        }
    }

    public void trimToSize() {
        if (this.size < this.elements.length) {
            if (this.size == 0) {
                this.elements = EMPTY;
            } else {
                this.elements = new char[this.size];
                CharList.arraycopy(this.elements, 0, this.elements, 0, this.size);
            }
        }
    }

    public final CharList push(char c) {
        this.add(c);
        return this;
    }

    public final CharList push(char c, char c2) {
        this.add(c);
        this.add(c2);
        return this;
    }

    public final CharList push(char c, char c2, char c3) {
        this.add(c);
        this.add(c2);
        this.add(c3);
        return this;
    }

    public boolean add(char c) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size] = c;
        ++this.size;
        return true;
    }

    public void add(int n, char c) {
        if (n >= this.size) {
            this.ensureCapacity(n + 1);
            CharList.clear(this.elements, this.size, n - this.size);
        } else {
            this.ensureCapacity(this.size + 1);
            CharList.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        }
        this.elements[n] = c;
        ++this.size;
    }

    public void addIfNotContained(char c) {
        if (!this.contains(c)) {
            this.add(c);
        }
    }

    public CharList addAll(CharList charList) {
        return this.addAll(charList.elements, 0, charList.size);
    }

    public CharList addAll(char[] cArray, int n, int n2) {
        if (n2 <= 0) {
            return this;
        }
        this.ensureCapacity(this.size + n2);
        CharList.arraycopy(cArray, n, this.elements, this.size, n2);
        this.size += n2;
        return this;
    }

    public char removeAt(int n) {
        char c = this.elements[n];
        CharList.arraycopy(this.elements, n + 1, this.elements, n, --this.size - n);
        return c;
    }

    public boolean remove(char c) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (c != this.elements[i]) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    public char set(int n, char c) {
        char c2;
        if (n >= this.size) {
            this.ensureCapacity(n + 1);
            CharList.clear(this.elements, this.size, n - this.size);
            c2 = this.elements[n];
            this.elements[n] = c;
            this.size = n + 1;
        } else {
            c2 = this.elements[n];
            this.elements[n] = c;
        }
        return c2;
    }

    public char get(int n) {
        return n < this.size ? this.elements[n] : (char)'\u0000';
    }

    public char peek(int n) {
        return n > 0 ? this.elements[this.size - n] : (char)'\u0000';
    }

    public boolean contains(char c) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (c != this.elements[i]) continue;
            return true;
        }
        return false;
    }

    public int indexOf(char c) {
        for (int i = 0; i < this.size; ++i) {
            if (c != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char c) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (c != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int binarySearch(char c) {
        return CharList.binarySearch(this.elements, c, 0, this.size);
    }

    public static int binarySearch(char[] cArray, char c) {
        return CharList.binarySearch(cArray, c, 0, cArray.length);
    }

    public static int binarySearch(char[] cArray, char c, int n, int n2) {
        while (n < n2) {
            int n3 = n + n2 >> 1;
            char c2 = cArray[n3];
            if (c2 < c) {
                n = n3 + 1;
                continue;
            }
            if (c2 > c) {
                n2 = n3;
                continue;
            }
            return n3;
        }
        return ~n;
    }

    public void writeTo(CharBuffer charBuffer) {
        charBuffer.put(this.elements, 0, this.size);
    }

    public void clear() {
        this.size = 0;
    }

    public static void arraycopy(char[] cArray, int n, char[] cArray2, int n2, int n3) {
        if (n3 < 20) {
            if (cArray2 != cArray || n2 > n) {
                while (--n3 >= 0) {
                    cArray2[n2 + n3] = cArray[n + n3];
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    cArray2[n2 + i] = cArray[n + i];
                }
            }
        } else {
            System.arraycopy(cArray, n, cArray2, n2, n3);
        }
    }

    public static void clear(char[] cArray, int n, int n2) {
        if (n2 < 20) {
            while (--n2 >= 0) {
                cArray[n + n2] = '\u0000';
            }
        } else {
            while (n2 > 0) {
                int n3 = n2 > 1024 ? 1024 : n2;
                CharList.arraycopy(CHAR_NULL, 0, cArray, n, n3);
                n2 -= n3;
                n += n3;
            }
        }
    }

    public char pop() {
        return this.elements[--this.size];
    }

    public void setSize(int n) {
        if (n > this.size) {
            this.ensureCapacity(n);
        }
        this.size = n;
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public char[] toArray() {
        char[] cArray = new char[this.size];
        CharList.arraycopy(this.elements, 0, cArray, 0, this.size);
        return cArray;
    }

    public char[] toArray(char[] cArray) {
        int n = cArray.length;
        if (n > this.size) {
            cArray[this.size] = '\u0000';
        } else if (n < this.size) {
            cArray = new char[this.size];
        }
        CharList.arraycopy(this.elements, 0, cArray, 0, this.size);
        return cArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString()).append('{');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.elements[i]);
        }
        return stringBuffer.append('}').toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CharList)) {
            return false;
        }
        CharList charList = (CharList)object;
        if (this.size != charList.size()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.elements[i] == charList.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = 31 * n + this.elements[i];
        }
        return n;
    }

    public void consume(char c) {
        this.add(c);
    }

    public void evaluateChar(CharConsumer charConsumer) {
        for (int i = 0; i < this.size; ++i) {
            charConsumer.consume(this.elements[i]);
        }
    }

    public void values(CharConsumer charConsumer) {
        this.evaluateChar(charConsumer);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeChar(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.elements = new char[this.size];
        char[] cArray = this.elements;
        for (int i = 0; i < this.size; ++i) {
            cArray[i] = objectInputStream.readChar();
        }
    }
}

