/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.util;

import de.grogra.reflect.TypeLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;

public class ClassLoaderObjectInputStream
extends ObjectInputStream {
    private final ClassLoader cloader;
    private final TypeLoader tloader;

    public ClassLoaderObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException {
        super(inputStream);
        this.cloader = classLoader;
        this.tloader = null;
    }

    public ClassLoaderObjectInputStream(InputStream inputStream, TypeLoader typeLoader) throws IOException {
        super(inputStream);
        this.cloader = typeLoader.getClassLoader();
        this.tloader = typeLoader;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        try {
            return super.resolveClass(objectStreamClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.resolveClass(objectStreamClass.getName());
        }
    }

    protected Class resolveClass(String string) throws ClassNotFoundException {
        int n = 0;
        while (string.charAt(n) == '[') {
            ++n;
        }
        Class<Comparable<Boolean>> clazz = null;
        if (n > 0) {
            switch (string.charAt(n)) {
                case 'Z': {
                    clazz = Boolean.TYPE;
                    break;
                }
                case 'B': {
                    clazz = Byte.TYPE;
                    break;
                }
                case 'S': {
                    clazz = Short.TYPE;
                    break;
                }
                case 'C': {
                    clazz = Character.TYPE;
                    break;
                }
                case 'I': {
                    clazz = Integer.TYPE;
                    break;
                }
                case 'J': {
                    clazz = Long.TYPE;
                    break;
                }
                case 'F': {
                    clazz = Float.TYPE;
                    break;
                }
                case 'D': {
                    clazz = Double.TYPE;
                    break;
                }
                case 'L': {
                    string = string.substring(n + 1, string.length() - 1).replace('/', '.');
                    break;
                }
                default: {
                    throw new ClassNotFoundException(string);
                }
            }
        }
        if (clazz == null) {
            Class<Object> clazz2 = clazz = this.tloader != null ? this.tloader.classForName(string) : Class.forName(string, false, this.cloader);
        }
        while (--n >= 0) {
            clazz = Array.newInstance(clazz, 0).getClass();
        }
        return clazz;
    }

    protected Class resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = null;
        boolean bl = false;
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Class clazz = this.resolveClass(stringArray[i]);
            if ((clazz.getModifiers() & 1) == 0) {
                if (bl) {
                    if (classLoader != clazz.getClassLoader()) {
                        throw new IllegalAccessError("conflicting non-public interface class loaders");
                    }
                } else {
                    classLoader = clazz.getClassLoader();
                    bl = true;
                }
            }
            classArray[i] = clazz;
        }
        try {
            return Proxy.getProxyClass(bl ? classLoader : this.cloader, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException(null, illegalArgumentException);
        }
    }
}

