/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.util;

import de.grogra.xl.lang.FloatConsumer;
import de.grogra.xl.lang.VoidToFloatGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.FloatBuffer;

public class FloatList
implements Cloneable,
Serializable,
FloatConsumer,
VoidToFloatGenerator {
    private static final long serialVersionUID = -6007099710058072430L;
    public transient float[] elements;
    public int size = 0;
    private static final float[] EMPTY = new float[0];
    private static final float[] FLOAT_NULL = new float[1024];

    public FloatList(int n) {
        this.elements = new float[Math.max(n, 8)];
    }

    public FloatList() {
        this(16);
    }

    public FloatList(float[] fArray) {
        this(fArray.length);
        this.size = fArray.length;
        FloatList.arraycopy(fArray, 0, this.elements, 0, this.size);
    }

    public Object clone() {
        try {
            FloatList floatList = (FloatList)super.clone();
            floatList.elements = new float[Math.max(this.size, 8)];
            FloatList.arraycopy(this.elements, 0, floatList.elements, 0, this.size);
            return floatList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public void ensureCapacity(int n) {
        if (n > this.elements.length) {
            float[] fArray = new float[Math.max(n, this.elements.length * 2)];
            FloatList.arraycopy(this.elements, 0, fArray, 0, this.size);
            this.elements = fArray;
        }
    }

    public void trimToSize() {
        if (this.size < this.elements.length) {
            if (this.size == 0) {
                this.elements = EMPTY;
            } else {
                this.elements = new float[this.size];
                FloatList.arraycopy(this.elements, 0, this.elements, 0, this.size);
            }
        }
    }

    public final FloatList push(float f) {
        this.add(f);
        return this;
    }

    public final FloatList push(float f, float f2) {
        this.add(f);
        this.add(f2);
        return this;
    }

    public final FloatList push(float f, float f2, float f3) {
        this.add(f);
        this.add(f2);
        this.add(f3);
        return this;
    }

    public boolean add(float f) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size] = f;
        ++this.size;
        return true;
    }

    public void add(int n, float f) {
        if (n >= this.size) {
            this.ensureCapacity(n + 1);
            FloatList.clear(this.elements, this.size, n - this.size);
        } else {
            this.ensureCapacity(this.size + 1);
            FloatList.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        }
        this.elements[n] = f;
        ++this.size;
    }

    public void addIfNotContained(float f) {
        if (!this.contains(f)) {
            this.add(f);
        }
    }

    public FloatList addAll(FloatList floatList) {
        return this.addAll(floatList.elements, 0, floatList.size);
    }

    public FloatList addAll(float[] fArray, int n, int n2) {
        if (n2 <= 0) {
            return this;
        }
        this.ensureCapacity(this.size + n2);
        FloatList.arraycopy(fArray, n, this.elements, this.size, n2);
        this.size += n2;
        return this;
    }

    public float removeAt(int n) {
        float f = this.elements[n];
        FloatList.arraycopy(this.elements, n + 1, this.elements, n, --this.size - n);
        return f;
    }

    public boolean remove(float f) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (f != this.elements[i]) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    public float set(int n, float f) {
        float f2;
        if (n >= this.size) {
            this.ensureCapacity(n + 1);
            FloatList.clear(this.elements, this.size, n - this.size);
            f2 = this.elements[n];
            this.elements[n] = f;
            this.size = n + 1;
        } else {
            f2 = this.elements[n];
            this.elements[n] = f;
        }
        return f2;
    }

    public float get(int n) {
        return n < this.size ? this.elements[n] : 0.0f;
    }

    public float peek(int n) {
        return n > 0 ? this.elements[this.size - n] : 0.0f;
    }

    public boolean contains(float f) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (f != this.elements[i]) continue;
            return true;
        }
        return false;
    }

    public int indexOf(float f) {
        for (int i = 0; i < this.size; ++i) {
            if (f != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(float f) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (f != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int binarySearch(float f) {
        return FloatList.binarySearch(this.elements, f, 0, this.size);
    }

    public static int binarySearch(float[] fArray, float f) {
        return FloatList.binarySearch(fArray, f, 0, fArray.length);
    }

    public static int binarySearch(float[] fArray, float f, int n, int n2) {
        while (n < n2) {
            float f2;
            int n3 = n + n2 >> 1;
            float f3 = fArray[n3];
            if (f2 < f) {
                n = n3 + 1;
                continue;
            }
            if (f3 > f) {
                n2 = n3;
                continue;
            }
            return n3;
        }
        return ~n;
    }

    public void writeTo(FloatBuffer floatBuffer) {
        floatBuffer.put(this.elements, 0, this.size);
    }

    public void clear() {
        this.size = 0;
    }

    public static void arraycopy(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (n3 < 20) {
            if (fArray2 != fArray || n2 > n) {
                while (--n3 >= 0) {
                    fArray2[n2 + n3] = fArray[n + n3];
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    fArray2[n2 + i] = fArray[n + i];
                }
            }
        } else {
            System.arraycopy(fArray, n, fArray2, n2, n3);
        }
    }

    public static void clear(float[] fArray, int n, int n2) {
        if (n2 < 20) {
            while (--n2 >= 0) {
                fArray[n + n2] = 0.0f;
            }
        } else {
            while (n2 > 0) {
                int n3 = n2 > 1024 ? 1024 : n2;
                FloatList.arraycopy(FLOAT_NULL, 0, fArray, n, n3);
                n2 -= n3;
                n += n3;
            }
        }
    }

    public float pop() {
        return this.elements[--this.size];
    }

    public void setSize(int n) {
        if (n > this.size) {
            this.ensureCapacity(n);
        }
        this.size = n;
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public float[] toArray() {
        float[] fArray = new float[this.size];
        FloatList.arraycopy(this.elements, 0, fArray, 0, this.size);
        return fArray;
    }

    public float[] toArray(float[] fArray) {
        int n = fArray.length;
        if (n > this.size) {
            fArray[this.size] = 0.0f;
        } else if (n < this.size) {
            fArray = new float[this.size];
        }
        FloatList.arraycopy(this.elements, 0, fArray, 0, this.size);
        return fArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString()).append('{');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.elements[i]);
        }
        return stringBuffer.append('}').toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FloatList)) {
            return false;
        }
        FloatList floatList = (FloatList)object;
        if (this.size != floatList.size()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.elements[i] == floatList.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = 31 * n + Float.floatToIntBits(this.elements[i]);
        }
        return n;
    }

    public void consume(float f) {
        this.add(f);
    }

    public void evaluateFloat(FloatConsumer floatConsumer) {
        for (int i = 0; i < this.size; ++i) {
            floatConsumer.consume(this.elements[i]);
        }
    }

    public void values(FloatConsumer floatConsumer) {
        this.evaluateFloat(floatConsumer);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeFloat(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.elements = new float[this.size];
        float[] fArray = this.elements;
        for (int i = 0; i < this.size; ++i) {
            fArray[i] = objectInputStream.readFloat();
        }
    }
}

