/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.util;

import de.grogra.xl.lang.IntConsumer;
import de.grogra.xl.lang.VoidToIntGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.IntBuffer;

public class IntList
implements Cloneable,
Serializable,
IntConsumer,
VoidToIntGenerator {
    private static final long serialVersionUID = -7049221200785962051L;
    public transient int[] elements;
    public int size = 0;
    private static final int[] EMPTY = new int[0];
    private static final int[] INT_NULL = new int[1024];

    public IntList(int n) {
        this.elements = new int[Math.max(n, 8)];
    }

    public IntList() {
        this(16);
    }

    public IntList(int[] nArray) {
        this(nArray.length);
        this.size = nArray.length;
        IntList.arraycopy(nArray, 0, this.elements, 0, this.size);
    }

    public Object clone() {
        try {
            IntList intList = (IntList)super.clone();
            intList.elements = new int[Math.max(this.size, 8)];
            IntList.arraycopy(this.elements, 0, intList.elements, 0, this.size);
            return intList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public void ensureCapacity(int n) {
        if (n > this.elements.length) {
            int[] nArray = new int[Math.max(n, this.elements.length * 2)];
            IntList.arraycopy(this.elements, 0, nArray, 0, this.size);
            this.elements = nArray;
        }
    }

    public void trimToSize() {
        if (this.size < this.elements.length) {
            if (this.size == 0) {
                this.elements = EMPTY;
            } else {
                this.elements = new int[this.size];
                IntList.arraycopy(this.elements, 0, this.elements, 0, this.size);
            }
        }
    }

    public final IntList push(int n) {
        this.add(n);
        return this;
    }

    public final IntList push(int n, int n2) {
        this.add(n);
        this.add(n2);
        return this;
    }

    public final IntList push(int n, int n2, int n3) {
        this.add(n);
        this.add(n2);
        this.add(n3);
        return this;
    }

    public boolean add(int n) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size] = n;
        ++this.size;
        return true;
    }

    public void add(int n, int n2) {
        if (n >= this.size) {
            this.ensureCapacity(n + 1);
            IntList.clear(this.elements, this.size, n - this.size);
        } else {
            this.ensureCapacity(this.size + 1);
            IntList.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        }
        this.elements[n] = n2;
        ++this.size;
    }

    public void addIfNotContained(int n) {
        if (!this.contains(n)) {
            this.add(n);
        }
    }

    public IntList addAll(IntList intList) {
        return this.addAll(intList.elements, 0, intList.size);
    }

    public IntList addAll(int[] nArray, int n, int n2) {
        if (n2 <= 0) {
            return this;
        }
        this.ensureCapacity(this.size + n2);
        IntList.arraycopy(nArray, n, this.elements, this.size, n2);
        this.size += n2;
        return this;
    }

    public int removeAt(int n) {
        int n2 = this.elements[n];
        IntList.arraycopy(this.elements, n + 1, this.elements, n, --this.size - n);
        return n2;
    }

    public boolean remove(int n) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (n != this.elements[i]) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    public int set(int n, int n2) {
        int n3;
        if (n >= this.size) {
            this.ensureCapacity(n + 1);
            IntList.clear(this.elements, this.size, n - this.size);
            n3 = this.elements[n];
            this.elements[n] = n2;
            this.size = n + 1;
        } else {
            n3 = this.elements[n];
            this.elements[n] = n2;
        }
        return n3;
    }

    public int get(int n) {
        return n < this.size ? this.elements[n] : 0;
    }

    public int peek(int n) {
        return n > 0 ? this.elements[this.size - n] : 0;
    }

    public boolean contains(int n) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (n != this.elements[i]) continue;
            return true;
        }
        return false;
    }

    public int indexOf(int n) {
        for (int i = 0; i < this.size; ++i) {
            if (n != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (n != this.elements[i]) continue;
            return i;
        }
        return -1;
    }

    public int binarySearch(int n) {
        return IntList.binarySearch(this.elements, n, 0, this.size);
    }

    public static int binarySearch(int[] nArray, int n) {
        return IntList.binarySearch(nArray, n, 0, nArray.length);
    }

    public static int binarySearch(int[] nArray, int n, int n2, int n3) {
        while (n2 < n3) {
            int n4 = n2 + n3 >> 1;
            int n5 = nArray[n4];
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4;
                continue;
            }
            return n4;
        }
        return ~n2;
    }

    public void writeTo(IntBuffer intBuffer) {
        intBuffer.put(this.elements, 0, this.size);
    }

    public void clear() {
        this.size = 0;
    }

    public static void arraycopy(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        if (n3 < 20) {
            if (nArray2 != nArray || n2 > n) {
                while (--n3 >= 0) {
                    nArray2[n2 + n3] = nArray[n + n3];
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    nArray2[n2 + i] = nArray[n + i];
                }
            }
        } else {
            System.arraycopy(nArray, n, nArray2, n2, n3);
        }
    }

    public static void clear(int[] nArray, int n, int n2) {
        if (n2 < 20) {
            while (--n2 >= 0) {
                nArray[n + n2] = 0;
            }
        } else {
            while (n2 > 0) {
                int n3 = n2 > 1024 ? 1024 : n2;
                IntList.arraycopy(INT_NULL, 0, nArray, n, n3);
                n2 -= n3;
                n += n3;
            }
        }
    }

    public int pop() {
        return this.elements[--this.size];
    }

    public void setSize(int n) {
        if (n > this.size) {
            this.ensureCapacity(n);
        }
        this.size = n;
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public int[] toArray() {
        int[] nArray = new int[this.size];
        IntList.arraycopy(this.elements, 0, nArray, 0, this.size);
        return nArray;
    }

    public int[] toArray(int[] nArray) {
        int n = nArray.length;
        if (n > this.size) {
            nArray[this.size] = 0;
        } else if (n < this.size) {
            nArray = new int[this.size];
        }
        IntList.arraycopy(this.elements, 0, nArray, 0, this.size);
        return nArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString()).append('{');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.elements[i]);
        }
        return stringBuffer.append('}').toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntList)) {
            return false;
        }
        IntList intList = (IntList)object;
        if (this.size != intList.size()) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.elements[i] == intList.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = 31 * n + this.elements[i];
        }
        return n;
    }

    public void consume(int n) {
        this.add(n);
    }

    public void evaluateInt(IntConsumer intConsumer) {
        for (int i = 0; i < this.size; ++i) {
            intConsumer.consume(this.elements[i]);
        }
    }

    public void values(IntConsumer intConsumer) {
        this.evaluateInt(intConsumer);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeInt(this.elements[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.elements = new int[this.size];
        int[] nArray = this.elements;
        for (int i = 0; i < this.size; ++i) {
            nArray[i] = objectInputStream.readInt();
        }
    }
}

