/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.util;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongHashMap<V>
implements Iterable<Entry<V>> {
    private float loadFactor;
    private int size;
    private int resizeThreshold;
    private int lengthM1;
    private Entry<V>[] table;

    public LongHashMap(int n, float f) {
        int n2;
        this.loadFactor = f;
        n = (int)((float)(n + 1) / f) + 2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.resizeThreshold = (int)((float)n2 * f);
        this.table = new Entry[n2];
        this.lengthM1 = n2 - 1;
        this.size = 0;
    }

    public LongHashMap(int n) {
        this(n, 0.75f);
    }

    public LongHashMap() {
        this(16, 0.75f);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Entry<V>[] entryArray = this.table;
        for (int i = this.lengthM1; i >= 0; --i) {
            entryArray[i] = null;
        }
        this.size = 0;
    }

    public void add(long l, V v) {
        this.add(new Entry<V>(l, v));
    }

    public V put(long l, V v) {
        int n = LongHashMap.getHashCode(l);
        Entry<V> entry = this.table[n & this.lengthM1];
        while (entry != null) {
            if (entry.key == l) {
                Object v2 = entry.value;
                entry.value = v;
                return v2;
            }
            entry = entry.next;
        }
        this.add(new Entry<V>(l, v));
        return null;
    }

    private void add(Entry<V> entry) {
        int n = LongHashMap.getHashCode(entry.key) & this.lengthM1;
        entry.next = this.table[n];
        this.table[n] = entry;
        if (++this.size > this.resizeThreshold) {
            Entry[] entryArray = new Entry[this.lengthM1 + 1 << 1];
            Entry<V>[] entryArray2 = this.table;
            int n2 = entryArray.length - 1;
            for (int i = this.lengthM1; i >= 0; --i) {
                Entry entry2;
                entry = entryArray2[i];
                if (entry == null) continue;
                entryArray2[i] = null;
                do {
                    entry2 = entry.next;
                    n = LongHashMap.getHashCode(entry.key) & n2;
                    entry.next = entryArray[n];
                    entryArray[n] = entry;
                } while ((entry = entry2) != null);
            }
            this.table = entryArray;
            this.lengthM1 = n2;
            this.resizeThreshold = (int)((float)entryArray.length * this.loadFactor);
        }
    }

    public void remove(Entry<V> entry) {
        int n = LongHashMap.getHashCode(entry.key) & this.lengthM1;
        Entry<V> entry2 = this.table[n];
        Entry<V> entry3 = null;
        while (entry2 != null) {
            if (entry2 == entry) {
                --this.size;
                if (entry3 != null) {
                    entry3.next = entry2.next;
                } else {
                    this.table[n] = entry2.next;
                }
                return;
            }
            entry3 = entry2;
            entry2 = entry2.next;
        }
    }

    public V remove(long l) {
        int n = LongHashMap.getHashCode(l);
        int n2 = n & this.lengthM1;
        Entry<V> entry = this.table[n2];
        Entry<V> entry2 = null;
        while (entry != null) {
            if (entry.key == l) {
                --this.size;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    this.table[n2] = entry.next;
                }
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public V remove(long l, V v) {
        int n = LongHashMap.getHashCode(l);
        int n2 = n & this.lengthM1;
        Entry<V> entry = this.table[n2];
        Entry<V> entry2 = null;
        while (entry != null) {
            if (v == entry.value && entry.key == l) {
                --this.size;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    this.table[n2] = entry.next;
                }
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public void removeAll(long l) {
        int n = LongHashMap.getHashCode(l);
        int n2 = n & this.lengthM1;
        Entry<V> entry = this.table[n2];
        Entry<V> entry2 = null;
        while (entry != null) {
            if (entry.key == l) {
                --this.size;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    this.table[n2] = entry.next;
                }
            } else {
                entry2 = entry;
            }
            entry = entry.next;
        }
    }

    public Entry getEntry(long l) {
        int n = LongHashMap.getHashCode(l);
        Entry<V> entry = this.table[n & this.lengthM1];
        while (entry != null) {
            if (entry.key == l) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    public V get(long l) {
        Entry entry = this.getEntry(l);
        return entry != null ? (V)entry.value : null;
    }

    public Object get(long l, Object object) {
        Entry entry = this.getEntry(l);
        return entry != null ? entry.value : object;
    }

    public boolean containsKey(long l) {
        return this.getEntry(l) != null;
    }

    static int getHashCode(long l) {
        int n = (int)l ^ (int)(l >> 32);
        n ^= n >> 20 ^ n >> 12;
        return n ^ n >> 7 ^ n >> 4;
    }

    @Override
    public Iterator<Entry<V>> iterator() {
        return new Iterator<Entry<V>>(){
            private int index = -1;
            private Entry<V> next;
            private Entry<V> current;

            @Override
            public boolean hasNext() {
                while (this.next == null) {
                    if (++this.index > LongHashMap.this.lengthM1) {
                        return false;
                    }
                    this.next = LongHashMap.this.table[this.index];
                }
                return this.next != null;
            }

            @Override
            public Entry<V> next() {
                if (!this.hasNext()) {
                    return null;
                }
                this.current = this.next;
                this.next = this.current.next;
                return this.current;
            }

            @Override
            public void remove() {
                LongHashMap.this.remove(this.current);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<V> {
        final long key;
        V value;
        Entry<V> next;

        Entry(long l, V v) {
            this.key = l;
            this.value = v;
        }

        public Entry<V> next() {
            Entry<V> entry = this.next;
            while (entry != null) {
                if (entry.key == this.key) {
                    return entry;
                }
                entry = entry.next;
            }
            return null;
        }

        public long getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

