/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.util;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XHashMap<K, V>
implements Iterable<Entry<K, V>> {
    private float loadFactor;
    private int size;
    private int resizeThreshold;
    private int lengthM1;
    private Entry<K, V>[] table;

    public XHashMap(int n, float f) {
        int n2;
        this.loadFactor = f;
        n = (int)((float)(n + 1) / f) + 2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.resizeThreshold = (int)((float)n2 * f);
        this.table = new Entry[n2];
        this.lengthM1 = n2 - 1;
        this.size = 0;
    }

    public XHashMap(int n) {
        this(n, 0.75f);
    }

    public XHashMap() {
        this(16, 0.75f);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        Entry<K, V>[] entryArray = this.table;
        for (int i = this.lengthM1; i >= 0; --i) {
            entryArray[i] = null;
        }
        this.size = 0;
    }

    public void add(K k, V v) {
        this.add(new Entry<K, V>(this, this.getHashCode(k), k, v));
    }

    public V put(K k, V v) {
        int n = this.getHashCode(k);
        Entry<K, V> entry = this.table[n & this.lengthM1];
        while (entry != null) {
            if (entry.hashCode == n && this.equals(k, entry.key)) {
                Object v2 = entry.value;
                entry.value = v;
                return v2;
            }
            entry = entry.next;
        }
        this.add(new Entry<K, V>(this, n, k, v));
        return null;
    }

    private void add(Entry<K, V> entry) {
        int n = entry.hashCode & this.lengthM1;
        entry.next = this.table[n];
        this.table[n] = entry;
        if (++this.size > this.resizeThreshold) {
            Entry[] entryArray = new Entry[this.lengthM1 + 1 << 1];
            Entry<K, V>[] entryArray2 = this.table;
            int n2 = entryArray.length - 1;
            for (int i = this.lengthM1; i >= 0; --i) {
                Entry entry2;
                entry = entryArray2[i];
                if (entry == null) continue;
                entryArray2[i] = null;
                do {
                    entry2 = entry.next;
                    n = entry.hashCode & n2;
                    entry.next = entryArray[n];
                    entryArray[n] = entry;
                } while ((entry = entry2) != null);
            }
            this.table = entryArray;
            this.lengthM1 = n2;
            this.resizeThreshold = (int)((float)entryArray.length * this.loadFactor);
        }
    }

    public void remove(Entry<K, V> entry) {
        int n = entry.hashCode & this.lengthM1;
        Entry<K, V> entry2 = this.table[n];
        Entry<K, V> entry3 = null;
        while (entry2 != null) {
            if (entry2 == entry) {
                --this.size;
                if (entry3 != null) {
                    entry3.next = entry2.next;
                } else {
                    this.table[n] = entry2.next;
                }
                return;
            }
            entry3 = entry2;
            entry2 = entry2.next;
        }
    }

    public V remove(K k) {
        int n = this.getHashCode(k);
        int n2 = n & this.lengthM1;
        Entry<K, V> entry = this.table[n2];
        Entry<K, V> entry2 = null;
        while (entry != null) {
            if (entry.hashCode == n && this.equals(k, entry.key)) {
                --this.size;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    this.table[n2] = entry.next;
                }
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public V remove(K k, V v) {
        int n = this.getHashCode(k);
        int n2 = n & this.lengthM1;
        Entry<K, V> entry = this.table[n2];
        Entry<K, V> entry2 = null;
        while (entry != null) {
            if (v == entry.value && entry.hashCode == n && this.equals(k, entry.key)) {
                --this.size;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    this.table[n2] = entry.next;
                }
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public void removeAll(K k) {
        int n = this.getHashCode(k);
        int n2 = n & this.lengthM1;
        Entry<K, V> entry = this.table[n2];
        Entry<K, V> entry2 = null;
        while (entry != null) {
            if (entry.hashCode == n && this.equals(k, entry.key)) {
                --this.size;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    this.table[n2] = entry.next;
                }
            } else {
                entry2 = entry;
            }
            entry = entry.next;
        }
    }

    public Entry getEntry(K k) {
        int n = this.getHashCode(k);
        Entry<K, V> entry = this.table[n & this.lengthM1];
        while (entry != null) {
            if (entry.hashCode == n && this.equals(k, entry.key)) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    public V get(K k) {
        Entry entry = this.getEntry(k);
        return entry != null ? (V)entry.value : null;
    }

    public Object get(K k, Object object) {
        Entry entry = this.getEntry(k);
        return entry != null ? entry.value : object;
    }

    public boolean containsKey(K k) {
        return this.getEntry(k) != null;
    }

    protected int getHashCode(K k) {
        if (k == null) {
            return 0;
        }
        int n = k.hashCode();
        n ^= n >> 20 ^ n >> 12;
        return n ^ n >> 7 ^ n >> 4;
    }

    protected boolean equals(K k, K k2) {
        return k == k2 || k != null && k.equals(k2);
    }

    @Override
    public Iterator<Entry<K, V>> iterator() {
        return new Iterator<Entry<K, V>>(){
            private int index = -1;
            private Entry<K, V> next;
            private Entry<K, V> current;

            @Override
            public boolean hasNext() {
                while (this.next == null) {
                    if (++this.index > XHashMap.this.lengthM1) {
                        return false;
                    }
                    this.next = XHashMap.this.table[this.index];
                }
                return this.next != null;
            }

            @Override
            public Entry<K, V> next() {
                if (!this.hasNext()) {
                    return null;
                }
                this.current = this.next;
                this.next = this.current.next;
                return this.current;
            }

            @Override
            public void remove() {
                XHashMap.this.remove(this.current);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<K, V> {
        final XHashMap<K, V> map;
        final int hashCode;
        final K key;
        V value;
        Entry<K, V> next;

        public void remove() {
            this.map.remove(this);
        }

        Entry(XHashMap<K, V> xHashMap, int n, K k, V v) {
            this.map = xHashMap;
            this.hashCode = n;
            this.key = k;
            this.value = v;
        }

        public Entry<K, V> next() {
            Entry<K, V> entry = this.next;
            while (entry != null) {
                if (entry.hashCode == this.hashCode && this.map.equals(this.key, entry.key)) {
                    return entry;
                }
                entry = entry.next;
            }
            return null;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

