/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp;

import de.grogra.graph.ChangeBoundaryListener;
import de.grogra.graph.EdgeChangeListener;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.Node;
import de.grogra.imp.FlatObjectInspector;
import de.grogra.imp.HierarchicalObjectInspector;
import de.grogra.imp.ObjectInspector;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.UIToolkit;
import de.grogra.pf.ui.edit.GraphSelection;
import de.grogra.pf.ui.event.UIPropertyEditEvent;
import de.grogra.pf.ui.swing.PanelSupport;
import de.grogra.pf.ui.swing.SwingPanel;
import de.grogra.pf.ui.swing.WindowSupport;
import de.grogra.util.EventListener;
import de.grogra.util.I18NBundle;
import de.grogra.util.Map;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectInspectorManager {
    static final HashMap<GraphManager, JTree> hierarchicalObjectInspectors = new HashMap();
    static final HashMap<GraphManager, JTree> flatObjectInspectors = new HashMap();
    boolean needUpdate = false;

    private void createObjectInspector(Panel panel, Context context, GraphManager graphManager, Map map, HashMap<GraphManager, JTree> hashMap, final ObjectInspector objectInspector) {
        JTree jTree;
        Container container = ((SwingPanel)panel.getComponent()).getContentPane();
        ((PanelSupport)panel).initialize((WindowSupport)context.getWindow(), map);
        if (hashMap.containsKey(graphManager)) {
            jTree = hashMap.get(graphManager);
        } else {
            jTree = new JTree(objectInspector);
            hashMap.put(graphManager, jTree);
            graphManager.addChangeBoundaryListener(new ChangeBoundaryListener(){

                public void beginChange(GraphState graphState) {
                }

                public void endChange(GraphState graphState) {
                    if (!ObjectInspectorManager.this.needUpdate) {
                        return;
                    }
                    objectInspector.buildTree();
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            jTree.updateUI();
                        }
                    });
                    ObjectInspectorManager.this.needUpdate = false;
                }

                public int getPriority() {
                    return 0;
                }
            });
            graphManager.addEdgeChangeListener(new EdgeChangeListener(){

                public void edgeChanged(Object object, Object object2, Object object3, GraphState graphState) {
                    ObjectInspectorManager.this.needUpdate = true;
                }
            });
            jTree.setDragEnabled(false);
            jTree.setEditable(false);
            jTree.setExpandsSelectedPaths(true);
            jTree.getSelectionModel().setSelectionMode(4);
            jTree.addTreeSelectionListener(objectInspector);
            UIProperty.WORKBENCH_SELECTION.addPropertyListener(context, new EventListener(){

                public void eventOccured(EventObject eventObject) {
                    if (eventObject instanceof UIPropertyEditEvent) {
                        UIPropertyEditEvent uIPropertyEditEvent = (UIPropertyEditEvent)eventObject;
                        if (objectInspector.isActiveTreeSelection()) {
                            objectInspector.setActiveTreeSelection(false);
                            return;
                        }
                        if (uIPropertyEditEvent.getNewValue() instanceof GraphSelection) {
                            GraphSelection graphSelection = (GraphSelection)uIPropertyEditEvent.getNewValue();
                            int n = graphSelection.size();
                            TreePath[] treePathArray = new TreePath[n];
                            for (int i = 0; i < n; ++i) {
                                TreePath treePath;
                                ObjectInspector.TreeNode treeNode;
                                if (!(graphSelection.getObject(i) instanceof Node) || (treeNode = objectInspector.getTreeNodeForNode((Node)graphSelection.getObject(i))) == null) continue;
                                LinkedList<ObjectInspector.TreeNode> linkedList = new LinkedList<ObjectInspector.TreeNode>();
                                objectInspector.getPathToTreeNode(treeNode, linkedList);
                                treePathArray[i] = treePath = new TreePath(linkedList.toArray());
                            }
                            objectInspector.setActiveGISelection(true);
                            jTree.setSelectionPaths(treePathArray);
                            objectInspector.setActiveGISelection(false);
                        } else if (uIPropertyEditEvent.getOldValue() instanceof GraphSelection && uIPropertyEditEvent.getNewValue() == null) {
                            objectInspector.setActiveGISelection(true);
                            jTree.clearSelection();
                            objectInspector.setActiveGISelection(false);
                        }
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                jTree.updateUI();
                            }
                        });
                    }
                }
            });
        }
        I18NBundle i18NBundle = context.getWorkbench().getRegistry().getPluginDescriptor("de.grogra.imp").getI18NBundle();
        JButton jButton = new JButton(i18NBundle.getString("setFilterButton.Name"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                objectInspector.setFilter(jTree.getSelectionPaths(), false);
                objectInspector.buildTree();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        jTree.updateUI();
                    }
                });
            }
        });
        JButton jButton2 = new JButton(i18NBundle.getString("setHierarchicFilterButton.Name"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                objectInspector.setFilter(jTree.getSelectionPaths(), true);
                objectInspector.buildTree();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        jTree.updateUI();
                    }
                });
            }
        });
        JButton jButton3 = new JButton(i18NBundle.getString("removeFilterButton.Name"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                objectInspector.removeFilter();
                objectInspector.buildTree();
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        jTree.updateUI();
                    }
                });
            }
        });
        JButton jButton4 = new JButton(i18NBundle.getString("expandAllButton.Name"));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ObjectInspectorManager.this.expandAll(jTree);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        jTree.updateUI();
                    }
                });
            }
        });
        JButton jButton5 = new JButton(i18NBundle.getString("collapseAllButton.Name"));
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ObjectInspectorManager.this.expandAll(jTree);
                ObjectInspectorManager.this.collapseAll(jTree);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        jTree.updateUI();
                    }
                });
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jPanel.add(jButton4);
        jPanel.add(jButton5);
        JScrollPane jScrollPane = new JScrollPane(jTree);
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "North");
        container.add((Component)jScrollPane, "Center");
    }

    private void expandAll(JTree jTree) {
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            jTree.expandRow(i);
        }
    }

    private void collapseAll(JTree jTree) {
        for (int i = jTree.getRowCount() - 1; i >= 0; --i) {
            jTree.collapseRow(i);
        }
    }

    public static Panel createHierarchicalObjectInspector(Context context, Map map) {
        GraphManager graphManager = context.getWorkbench().getRegistry().getProjectGraph();
        UIToolkit uIToolkit = UIToolkit.get((Context)context);
        Panel panel = uIToolkit.createPanel(context, null, map);
        ObjectInspectorManager objectInspectorManager = new ObjectInspectorManager();
        objectInspectorManager.createObjectInspector(panel, context, graphManager, map, hierarchicalObjectInspectors, new HierarchicalObjectInspector(context, graphManager));
        return panel;
    }

    public static Panel createFlatObjectInspector(Context context, Map map) {
        GraphManager graphManager = context.getWorkbench().getRegistry().getProjectGraph();
        UIToolkit uIToolkit = UIToolkit.get((Context)context);
        Panel panel = uIToolkit.createPanel(context, null, map);
        ObjectInspectorManager objectInspectorManager = new ObjectInspectorManager();
        objectInspectorManager.createObjectInspector(panel, context, graphManager, map, flatObjectInspectors, new FlatObjectInspector(context, graphManager));
        return panel;
    }
}

