/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp.net;

import de.grogra.imp.net.MessageHandler;
import de.grogra.imp.net.ResponseHandler;
import de.grogra.imp.net.SimpleResponseHandler;
import de.grogra.util.IOWrapException;
import de.grogra.xl.util.LongHashMap;
import de.grogra.xl.util.ObjectList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class Connection
implements Runnable {
    static final int MAGIC = -1973305041;
    static final int MESSAGE = 318637842;
    static final int RESPONSE = -1907096994;
    static final int CLOSE = -1056579293;
    static final int AVAILABLE = -1415480642;
    static final byte[] END_MARK = new byte[]{-108, 48, 16, 69, -11, -27, -25, 61, 29, -47, 72, -93, 113, 12, -14, -31};
    static final int END_MARK_LENGTH = 16;
    private final Socket socket;
    private final DataOutputStream out;
    private final DataInputStream in;
    private long currentMessage = -1L;
    private long nextMessage = 0L;
    private LongHashMap<ResponseHandler> responseHandlers = new LongHashMap();
    private ObjectList<MessageHandler> messageHandlers = new ObjectList();
    private volatile boolean close;
    private boolean started;

    public Connection(Socket socket) throws IOException {
        this.socket = socket;
        this.out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        this.out.writeInt(-1973305041);
        this.out.flush();
        this.in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.consumeInt(-1973305041);
    }

    public Socket getSocket() {
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageHandler(MessageHandler messageHandler) {
        ObjectList<MessageHandler> objectList = this.messageHandlers;
        synchronized (objectList) {
            this.messageHandlers.add((Object)messageHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageHandler(MessageHandler messageHandler) {
        ObjectList<MessageHandler> objectList = this.messageHandlers;
        synchronized (objectList) {
            this.messageHandlers.remove((Object)messageHandler);
        }
    }

    public void consumeInt(int n) throws IOException {
        int n2 = this.in.readInt();
        if (n2 != n) {
            throw new IOException("Expected " + n + " instead of " + n2);
        }
    }

    public void consumeByte(int n) throws IOException {
        byte by = this.in.readByte();
        if (by != n) {
            throw new IOException("Expected " + n + " instead of " + by);
        }
    }

    private void begin(int n) throws IOException {
        try {
            while (this.currentMessage >= 0L) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOWrapException((Throwable)interruptedException);
        }
        this.currentMessage = this.nextMessage++;
        this.out.writeInt(n);
        this.out.writeLong(this.currentMessage);
    }

    public synchronized long beginMessage(String string, ResponseHandler responseHandler) throws IOException {
        this.begin(318637842);
        this.out.writeUTF(string);
        if (responseHandler != null) {
            this.responseHandlers.put(this.currentMessage, (Object)responseHandler);
        }
        return this.currentMessage;
    }

    public synchronized SimpleResponseHandler isAvailable(String string) throws IOException {
        SimpleResponseHandler simpleResponseHandler = new SimpleResponseHandler(0);
        this.begin(-1415480642);
        this.out.writeUTF(string);
        this.responseHandlers.put(this.currentMessage, (Object)simpleResponseHandler);
        this.end(this.currentMessage);
        return simpleResponseHandler;
    }

    public synchronized long beginResponse(long l, ResponseHandler responseHandler) throws IOException {
        this.begin(-1907096994);
        this.out.writeLong(l);
        if (responseHandler != null) {
            this.responseHandlers.put(this.currentMessage, (Object)responseHandler);
        }
        return this.currentMessage;
    }

    public synchronized void end(long l) throws IOException {
        if (l != this.currentMessage) {
            throw new IllegalStateException();
        }
        this.currentMessage = -1L;
        for (int i = 15; i >= 0; --i) {
            this.out.writeByte(END_MARK[i]);
        }
        this.out.flush();
        this.notifyAll();
    }

    public DataOutputStream getOut() {
        return this.out;
    }

    public DataInputStream getIn() {
        return this.in;
    }

    public void skipRest() throws IOException {
        int n = 15;
        while (n >= 0) {
            byte by = this.in.readByte();
            if (by == END_MARK[n]) {
                --n;
                continue;
            }
            n = 15;
            if (by != END_MARK[n]) continue;
            --n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!this.close) {
                int n = this.in.readInt();
                switch (n) {
                    case -1056579293: {
                        this.close = true;
                        break;
                    }
                    case -1415480642: 
                    case 318637842: {
                        long l3;
                        long l2 = this.in.readLong();
                        String string = this.in.readUTF();
                        boolean bl = this.handleMessage(l2, string, n == -1415480642);
                        if (n == -1415480642) {
                            l3 = this.beginResponse(l2, null);
                            this.out.writeInt(bl ? 1 : 0);
                            this.end(l3);
                            break;
                        }
                        if (bl) break;
                        throw new IOException("Message " + string + " could not be handled");
                    }
                    case -1907096994: {
                        ResponseHandler responseHandler;
                        long l = this.in.readLong();
                        long l3 = this.in.readLong();
                        Connection connection = this;
                        synchronized (connection) {
                            responseHandler = (ResponseHandler)this.responseHandlers.remove(l3);
                        }
                        if (responseHandler == null) {
                            throw new IOException("No ResponseHandler for request");
                        }
                        responseHandler.handleResponse(this, l3, l);
                        break;
                    }
                    default: {
                        throw new IOException("Illegal code " + n);
                    }
                }
                for (int i = 15; i >= 0; --i) {
                    this.consumeByte(END_MARK[i]);
                }
            }
            this.out.close();
            this.in.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        new Thread((Runnable)this, this.toString()).start();
    }

    public void close() {
        boolean bl = this.close;
        this.close = true;
        if (!bl) {
            try {
                this.begin(-1056579293);
                this.end(this.currentMessage);
                this.out.close();
                this.socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public boolean isClosed() {
        return this.close;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleMessage(long l, String string, boolean bl) throws IOException {
        ObjectList<MessageHandler> objectList = this.messageHandlers;
        synchronized (objectList) {
            int n = this.messageHandlers.size;
            for (int i = 0; i < n; ++i) {
                if (!((MessageHandler)this.messageHandlers.get(i)).handleMessage(this, l, string, bl)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Connection@" + Integer.toHexString(this.hashCode()) + '[' + this.socket + ']';
    }
}

