/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.soton.grophysics;

import com.bulletphysics.dynamics.constraintsolver.Generic6DofConstraint;
import com.bulletphysics.linearmath.Transform;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.objects.Cylinder;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.Type;
import de.grogra.rgg.Library;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class FlexNode
extends Cylinder {
    private static final long serialVersionUID = -7688781891937691880L;
    static float DEFAULT_MASS = 0.001f;
    static float DEFAULT_STIFFNESS = 0.5f;
    public float mass;
    public float stiffnessT;
    public float stiffnessX;
    public float stiffnessY;
    public float stiffnessZ;
    public float rotDamping;
    public float linDamping;
    public float linBounce;
    public float rotBounce;
    Generic6DofConstraint joint;
    Matrix4d jointFrameOffset;
    public static final Node.NType $TYPE = new Node.NType((Node)new FlexNode());
    public static final Node.NType.Field mass$FIELD = new _Field("mass", 0x200001, Type.FLOAT, null, 0);
    public static final Node.NType.Field stiffnessT$FIELD;
    public static final Node.NType.Field stiffnessX$FIELD;
    public static final Node.NType.Field stiffnessY$FIELD;
    public static final Node.NType.Field stiffnessZ$FIELD;
    public static final Node.NType.Field rotDamping$FIELD;
    public static final Node.NType.Field linDamping$FIELD;
    public static final Node.NType.Field linBounce$FIELD;
    public static final Node.NType.Field rotBounce$FIELD;

    public FlexNode() {
        this(1.0f, 0.05f, DEFAULT_MASS);
    }

    public FlexNode(float f, float f2) {
        this(f, f2, DEFAULT_MASS);
    }

    public FlexNode(float f, float f2, float f3) {
        super(f, f2);
        this.mass = f3;
        this.stiffnessT = DEFAULT_STIFFNESS;
        this.stiffnessX = DEFAULT_STIFFNESS;
        this.stiffnessY = DEFAULT_STIFFNESS;
        this.stiffnessZ = DEFAULT_STIFFNESS;
        this.linDamping = 1.0f;
        this.rotDamping = 1.0f;
        this.linBounce = 0.5f;
        this.rotBounce = 0.0f;
        this.jointFrameOffset = new Matrix4d();
        this.jointFrameOffset.setIdentity();
    }

    public float getStiffness(int n) {
        float f = 0.0f;
        switch (n) {
            case 0: {
                f = this.stiffnessX;
                break;
            }
            case 1: {
                f = this.stiffnessY;
                break;
            }
            case 2: {
                f = this.stiffnessZ;
                break;
            }
            case 3: {
                f = this.stiffnessT;
            }
        }
        return f;
    }

    public Generic6DofConstraint getJoint() {
        return this.joint;
    }

    public void setJoint(Generic6DofConstraint generic6DofConstraint) {
        this.joint = generic6DofConstraint;
    }

    public void ageJoint(double d) {
        if (this.joint == null) {
            Library.println((Object)"WARNING: FlexNode.ageJoint(): joint is NULL");
        } else {
            Matrix3d matrix3d = new Matrix3d();
            Matrix3d matrix3d2 = new Matrix3d();
            matrix3d2.setIdentity();
            double d2 = this.joint.getAngle(0);
            double d3 = this.joint.getAngle(1);
            double d4 = this.joint.getAngle(2);
            matrix3d.rotX(d2 *= d);
            matrix3d2.mul(matrix3d);
            matrix3d.rotY(d3 *= d);
            matrix3d2.mul(matrix3d);
            matrix3d.rotZ(d4 *= d);
            matrix3d2.mul(matrix3d);
            Matrix4d matrix4d = new Matrix4d();
            matrix4d.setIdentity();
            matrix4d.set(matrix3d2);
            this.jointFrameOffset.mul(matrix4d);
        }
    }

    public Transform initBottomJointFrame() {
        Transform transform = new Transform();
        transform.setIdentity();
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, -this.length / 2.0f);
        transform.origin.set((Tuple3f)vector3f);
        return transform;
    }

    public Transform getBottomJointFrame() {
        Transform transform = this.initBottomJointFrame();
        Matrix4f matrix4f = new Matrix4f();
        transform.getMatrix(matrix4f);
        Matrix4d matrix4d = new Matrix4d(matrix4f);
        matrix4d.mul(this.jointFrameOffset);
        matrix4f.set(matrix4d);
        transform.set(matrix4f);
        return transform;
    }

    Vector3d getLengthVector() {
        return new Vector3d(0.0, 0.0, (double)this.length);
    }

    public Transform getTopJointFrame() {
        Transform transform = new Transform();
        transform.setIdentity();
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, this.length / 2.0f);
        transform.origin.set((Tuple3f)vector3f);
        return transform;
    }

    public FlexNode getPreviousFlexNode() {
        FlexNode flexNode = null;
        for (Node node = this.getPredecessor(); node != null; node = node.getPredecessor()) {
            if (!(node instanceof FlexNode)) continue;
            flexNode = (FlexNode)node;
            break;
        }
        return flexNode;
    }

    public FlexNode getParentFlexNode() {
        FlexNode flexNode = this.getPreviousFlexNode();
        if (flexNode == null) {
            block0: for (Node node = this.getAxisParent(); node != null; node = node.getAxisParent()) {
                if (node instanceof FlexNode) {
                    flexNode = (FlexNode)node;
                    break;
                }
                for (Node node2 = node.getPredecessor(); node2 != null; node2 = node2.getPredecessor()) {
                    if (!(node2 instanceof FlexNode)) continue;
                    flexNode = (FlexNode)node2;
                    break block0;
                }
            }
        }
        return flexNode;
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new FlexNode();
    }

    public float getMass() {
        return this.mass;
    }

    public void setMass(float f) {
        this.mass = f;
    }

    public float getStiffnessT() {
        return this.stiffnessT;
    }

    public void setStiffnessT(float f) {
        this.stiffnessT = f;
    }

    public float getStiffnessX() {
        return this.stiffnessX;
    }

    public void setStiffnessX(float f) {
        this.stiffnessX = f;
    }

    public float getStiffnessY() {
        return this.stiffnessY;
    }

    public void setStiffnessY(float f) {
        this.stiffnessY = f;
    }

    public float getStiffnessZ() {
        return this.stiffnessZ;
    }

    public void setStiffnessZ(float f) {
        this.stiffnessZ = f;
    }

    public float getRotDamping() {
        return this.rotDamping;
    }

    public void setRotDamping(float f) {
        this.rotDamping = f;
    }

    public float getLinDamping() {
        return this.linDamping;
    }

    public void setLinDamping(float f) {
        this.linDamping = f;
    }

    public float getLinBounce() {
        return this.linBounce;
    }

    public void setLinBounce(float f) {
        this.linBounce = f;
    }

    public float getRotBounce() {
        return this.rotBounce;
    }

    public void setRotBounce(float f) {
        this.rotBounce = f;
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)mass$FIELD);
        stiffnessT$FIELD = new _Field("stiffnessT", 0x200001, Type.FLOAT, null, 1);
        $TYPE.addManagedField((ManageableType.Field)stiffnessT$FIELD);
        stiffnessX$FIELD = new _Field("stiffnessX", 0x200001, Type.FLOAT, null, 2);
        $TYPE.addManagedField((ManageableType.Field)stiffnessX$FIELD);
        stiffnessY$FIELD = new _Field("stiffnessY", 0x200001, Type.FLOAT, null, 3);
        $TYPE.addManagedField((ManageableType.Field)stiffnessY$FIELD);
        stiffnessZ$FIELD = new _Field("stiffnessZ", 0x200001, Type.FLOAT, null, 4);
        $TYPE.addManagedField((ManageableType.Field)stiffnessZ$FIELD);
        rotDamping$FIELD = new _Field("rotDamping", 0x200001, Type.FLOAT, null, 5);
        $TYPE.addManagedField((ManageableType.Field)rotDamping$FIELD);
        linDamping$FIELD = new _Field("linDamping", 0x200001, Type.FLOAT, null, 6);
        $TYPE.addManagedField((ManageableType.Field)linDamping$FIELD);
        linBounce$FIELD = new _Field("linBounce", 0x200001, Type.FLOAT, null, 7);
        $TYPE.addManagedField((ManageableType.Field)linBounce$FIELD);
        rotBounce$FIELD = new _Field("rotBounce", 0x200001, Type.FLOAT, null, 8);
        $TYPE.addManagedField((ManageableType.Field)rotBounce$FIELD);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setFloat(Object object, float f) {
            switch (this.id) {
                case 0: {
                    ((FlexNode)((Object)object)).mass = f;
                    return;
                }
                case 1: {
                    ((FlexNode)((Object)object)).stiffnessT = f;
                    return;
                }
                case 2: {
                    ((FlexNode)((Object)object)).stiffnessX = f;
                    return;
                }
                case 3: {
                    ((FlexNode)((Object)object)).stiffnessY = f;
                    return;
                }
                case 4: {
                    ((FlexNode)((Object)object)).stiffnessZ = f;
                    return;
                }
                case 5: {
                    ((FlexNode)((Object)object)).rotDamping = f;
                    return;
                }
                case 6: {
                    ((FlexNode)((Object)object)).linDamping = f;
                    return;
                }
                case 7: {
                    ((FlexNode)((Object)object)).linBounce = f;
                    return;
                }
                case 8: {
                    ((FlexNode)((Object)object)).rotBounce = f;
                    return;
                }
            }
            super.setFloat(object, f);
        }

        public float getFloat(Object object) {
            switch (this.id) {
                case 0: {
                    return ((FlexNode)((Object)object)).getMass();
                }
                case 1: {
                    return ((FlexNode)((Object)object)).getStiffnessT();
                }
                case 2: {
                    return ((FlexNode)((Object)object)).getStiffnessX();
                }
                case 3: {
                    return ((FlexNode)((Object)object)).getStiffnessY();
                }
                case 4: {
                    return ((FlexNode)((Object)object)).getStiffnessZ();
                }
                case 5: {
                    return ((FlexNode)((Object)object)).getRotDamping();
                }
                case 6: {
                    return ((FlexNode)((Object)object)).getLinDamping();
                }
                case 7: {
                    return ((FlexNode)((Object)object)).getLinBounce();
                }
                case 8: {
                    return ((FlexNode)((Object)object)).getRotBounce();
                }
            }
            return super.getFloat(object);
        }
    }
}

