/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.docking;

import de.grogra.docking.DockComponent;
import de.grogra.docking.DockContainer;
import de.grogra.docking.DockContentPane;
import de.grogra.docking.DockMenuListener;
import de.grogra.docking.DockPosition;
import de.grogra.docking.DockPositionList;
import de.grogra.docking.DockShape;
import de.grogra.docking.DockSplitPane;
import de.grogra.docking.DockTabbedPane;
import de.grogra.docking.Dockable;
import de.grogra.docking.DockableComponent;
import de.grogra.docking.DockableFilter;
import de.grogra.docking.DockableWrapper;
import de.grogra.docking.DockedFrame;
import de.grogra.docking.DragDockableContext;
import de.grogra.docking.DragSourceComponent;
import de.grogra.docking.FloatingWindow;
import de.grogra.docking.LayoutConsumer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.TooManyListenersException;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class DockManager
extends WindowAdapter
implements DragGestureListener {
    public static final ResourceBundle RES_BUNDLE = ResourceBundle.getBundle("de.grogra.docking.Resources");
    final RootInfo mainInfo;
    private Dockable selected = null;
    private DragSource dragSource;
    Hashtable roots = new Hashtable(4);
    private DragSourceAdapter sourceListener = new DragSourceAdapter(){

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
            dragSourceEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            DockManager.this.setDnD(false);
        }
    };
    DropTargetAdapter targetListener = new DropTargetAdapter(){
        private DnDGlassPane current = null;

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            DnDGlassPane dnDGlassPane;
            if (this.current != null) {
                this.current.setDropPosition(null);
                this.current = null;
            }
            if ((dnDGlassPane = DockManager.this.check(dropTargetDragEvent)) != null) {
                this.current = dnDGlassPane;
                dnDGlassPane.drag(dropTargetDragEvent);
                dropTargetDragEvent.acceptDrag(2);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (this.current != null) {
                this.current.setDropPosition(null);
                this.current = null;
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (this.current != null) {
                if (DockManager.this.check(dropTargetDragEvent) == this.current) {
                    this.current.drag(dropTargetDragEvent);
                } else {
                    this.current.setDropPosition(null);
                    this.current = null;
                }
            }
            if (this.current == null) {
                dropTargetDragEvent.rejectDrag();
            } else {
                dropTargetDragEvent.acceptDrag(2);
            }
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            DockPosition dockPosition;
            boolean bl = true;
            if (this.current != null && dropTargetDropEvent.isLocalTransfer() && DockManager.this.check(dropTargetDropEvent) == this.current && (dockPosition = this.current.position) != null) {
                bl = false;
                dropTargetDropEvent.acceptDrop(2);
                DragDockableContext dragDockableContext = null;
                try {
                    dragDockableContext = (DragDockableContext)dropTargetDropEvent.getTransferable().getTransferData(DragDockableContext.getFlavor());
                    if (DockManager.this.getInfo((Component)((Object)dragDockableContext.getDockableComponent())) == null) {
                        dragDockableContext = null;
                    }
                }
                catch (IOException iOException) {
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                if (dragDockableContext != null) {
                    dockPosition.drop(dragDockableContext);
                    dropTargetDropEvent.dropComplete(true);
                } else {
                    dropTargetDropEvent.dropComplete(false);
                }
            }
            this.current.setDropPosition(null);
            this.current = null;
            if (bl) {
                dropTargetDropEvent.rejectDrop();
            }
        }
    };
    private Dockable curKeepInFront;

    DnDGlassPane check(DropTargetDragEvent dropTargetDragEvent) {
        return dropTargetDragEvent.isDataFlavorSupported(DragDockableContext.getFlavor()) ? this.checkImpl(dropTargetDragEvent) : null;
    }

    DnDGlassPane check(DropTargetDropEvent dropTargetDropEvent) {
        return dropTargetDropEvent.isDataFlavorSupported(DragDockableContext.getFlavor()) ? this.checkImpl(dropTargetDropEvent) : null;
    }

    private DnDGlassPane checkImpl(DropTargetEvent dropTargetEvent) {
        Component component = dropTargetEvent.getDropTargetContext().getComponent();
        return component instanceof DnDGlassPane && ((DnDGlassPane)component).dndActive ? (DnDGlassPane)component : null;
    }

    static void replace0(Component component, Component component2) {
        Container container = component.getParent();
        for (int i = container.getComponentCount() - 1; i >= 0; --i) {
            if (container.getComponent(i) != component) continue;
            container.remove(i);
            if (container instanceof JComponent) {
                ((JComponent)container).revalidate();
            }
            container.add(component2, i);
            return;
        }
    }

    static void translate(Point point, Container container, Component component) {
        while (component != container) {
            point.translate(-component.getX(), -component.getY());
            component = component.getParent();
        }
    }

    public LayoutConsumer setLayout() {
        return this.setLayout(null);
    }

    public LayoutConsumer setLayout(final FloatingWindow floatingWindow) {
        return new LayoutConsumer(){
            private final Stack stack = new Stack();
            private final HashSet toClose = new HashSet();
            private RootInfo currentInfo;
            private RootInfo windowInfo;

            public void startLayout() {
                RootInfo[] rootInfoArray = DockManager.this.roots.values().toArray(new RootInfo[DockManager.this.roots.size()]);
                RootInfo rootInfo = null;
                for (int i = 0; i < rootInfoArray.length; ++i) {
                    rootInfo = rootInfoArray[i];
                    if (floatingWindow != null && floatingWindow != rootInfo.getWindow()) continue;
                    this.toClose.addAll(rootInfo.release(false));
                    if (floatingWindow != null) break;
                    if (rootInfo == DockManager.this.mainInfo) continue;
                    ((FloatingWindow)rootInfo.getWindow()).dispose();
                }
                this.windowInfo = floatingWindow == null ? DockManager.this.mainInfo : rootInfo;
                this.currentInfo = this.windowInfo;
                if (rootInfo != null) {
                    this.stack.push(rootInfo.dockRoot);
                }
            }

            public void endLayout() {
                Iterator iterator = this.toClose.iterator();
                while (iterator.hasNext()) {
                    ((Dockable)iterator.next()).dockableClosed();
                }
                this.windowInfo.dockRoot.revalidate();
            }

            public void startMainWindow() {
                this.currentInfo = DockManager.this.mainInfo;
                this.stack.push(this.currentInfo.dockRoot);
            }

            public void endMainWindow() {
                this.stack.pop();
                this.currentInfo = null;
            }

            public void startFloatingWindow(String string, int n, int n2) {
                this.stack.push(n <= 0 || n2 <= 0 ? null : new Dimension(n, n2));
                FloatingWindow floatingWindow2 = DockManager.this.createFloatingWindow(string, true);
                this.stack.push(floatingWindow2.getDockRoot());
                this.currentInfo = (RootInfo)DockManager.this.roots.get(floatingWindow2.getRootPane());
            }

            public void endFloatingWindow() {
                FloatingWindow floatingWindow2 = (FloatingWindow)SwingUtilities.getWindowAncestor((Component)this.stack.pop());
                Object e = this.stack.pop();
                if (e != null) {
                    floatingWindow2.setSize((Dimension)e);
                    floatingWindow2.setLocationRelativeTo(DockManager.this.mainInfo.dockRoot);
                } else {
                    DockManager.this.pack(floatingWindow2);
                }
                floatingWindow2.setVisible(true);
                this.currentInfo = null;
            }

            public void startSplit(int n, float f) {
                this.stack.push(f < 0.0f ? null : new Float(f));
                this.stack.push(new DockSplitPane(DockManager.this, n));
            }

            public void endSplit() {
                DockSplitPane dockSplitPane = (DockSplitPane)this.stack.pop();
                Object e = this.stack.pop();
                switch (dockSplitPane.getDockComponentCount()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        DockComponent dockComponent = dockSplitPane.getDockComponent(0);
                        dockSplitPane.remove(dockComponent);
                        ((DockContainer)this.stack.peek()).add(-1, dockComponent);
                        break;
                    }
                    default: {
                        ((DockContainer)this.stack.peek()).add(-1, dockSplitPane);
                        if (!dockSplitPane.isEnabled()) break;
                        if (e != null) {
                            dockSplitPane.setProportionalDividerLocation(((Float)e).floatValue());
                            break;
                        }
                        dockSplitPane.resetToPreferredSizes();
                    }
                }
            }

            public void startTabbed(int n) {
                this.stack.push(n < 0 ? null : Integer.valueOf(n));
                this.stack.push(new DockTabbedPane(DockManager.this));
            }

            public void endTabbed() {
                DockTabbedPane dockTabbedPane = (DockTabbedPane)this.stack.pop();
                Integer n = (Integer)this.stack.pop();
                switch (dockTabbedPane.getDockComponentCount()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        DockComponent dockComponent = dockTabbedPane.getDockComponent(0);
                        dockTabbedPane.remove(dockComponent);
                        ((DockContainer)this.stack.peek()).add(-1, dockComponent);
                        break;
                    }
                    default: {
                        dockTabbedPane.setSelectedIndex(n == null ? 0 : Math.min(n, dockTabbedPane.getTabCount() - 1));
                        ((DockContainer)this.stack.peek()).add(-1, dockTabbedPane);
                    }
                }
            }

            public void addDockable(Dockable dockable) {
                DockContainer dockContainer = (DockContainer)this.stack.peek();
                dockable.setManager(DockManager.this);
                dockContainer.add(-1, dockable.getComponent());
                this.toClose.remove(dockable);
            }
        };
    }

    public void supply(LayoutConsumer layoutConsumer) {
        layoutConsumer.startLayout();
        layoutConsumer.startMainWindow();
        DockManager.supply(layoutConsumer, this.mainInfo.dockRoot);
        layoutConsumer.endMainWindow();
        Enumeration enumeration = this.roots.elements();
        while (enumeration.hasMoreElements()) {
            RootInfo rootInfo = (RootInfo)enumeration.nextElement();
            if (rootInfo == this.mainInfo) continue;
            FloatingWindow floatingWindow = (FloatingWindow)rootInfo.getWindow();
            layoutConsumer.startFloatingWindow(floatingWindow.getTitle(), floatingWindow.getWidth(), floatingWindow.getHeight());
            DockManager.supply(layoutConsumer, rootInfo.dockRoot);
            layoutConsumer.endFloatingWindow();
        }
        layoutConsumer.endLayout();
    }

    private static void supply(LayoutConsumer layoutConsumer, Component component) {
        if (component instanceof DockableComponent) {
            layoutConsumer.addDockable(((DockableComponent)((Object)component)).getDockable());
        } else if (component instanceof DockContainer) {
            DockContainer dockContainer = (DockContainer)((Object)component);
            if (dockContainer instanceof DockSplitPane) {
                DockSplitPane dockSplitPane = (DockSplitPane)dockContainer;
                layoutConsumer.startSplit(dockSplitPane.getOrientation(), Math.abs(dockSplitPane.getResizeWeight() - 0.5) > 0.4 ? -1.0f : dockSplitPane.getProportionalDividerLocation());
            } else if (dockContainer instanceof DockTabbedPane) {
                layoutConsumer.startTabbed(((DockTabbedPane)dockContainer).getSelectedIndex());
            } else if (!(dockContainer instanceof DockContentPane)) {
                throw new IllegalStateException();
            }
            int n = dockContainer.getDockComponentCount();
            for (int i = 0; i < n; ++i) {
                DockManager.supply(layoutConsumer, (Component)((Object)dockContainer.getDockComponent(i)));
            }
            if (dockContainer instanceof DockSplitPane) {
                layoutConsumer.endSplit();
            } else if (dockContainer instanceof DockTabbedPane) {
                layoutConsumer.endTabbed();
            }
        }
    }

    void addImpl(Dockable dockable, int n, DockComponent dockComponent) {
        JComponent jComponent;
        dockable.setManager(this);
        if (dockComponent instanceof Dockable) {
            dockComponent = ((Dockable)dockComponent).getComponent();
        }
        if (dockComponent instanceof DockContentPane) {
            jComponent = (DockContentPane)dockComponent;
        } else if ((n & 0xF) != 0) {
            DockSplitPane dockSplitPane = new DockSplitPane(this, (n & 3) != 0 ? 1 : 0);
            DockManager.replace0((Component)((Object)dockComponent), dockSplitPane);
            dockSplitPane.add(16, dockComponent);
            dockSplitPane.resetToPreferredSizes();
            jComponent = dockSplitPane;
        } else if ((n & 0x30) != 0) {
            DockTabbedPane dockTabbedPane;
            if (dockComponent instanceof DockTabbedPane) {
                dockTabbedPane = (DockTabbedPane)dockComponent;
                n = -1;
            } else if (dockComponent.getParent() instanceof DockTabbedPane) {
                dockTabbedPane = (DockTabbedPane)dockComponent.getParent();
                n = dockTabbedPane.indexOfComponent((Component)((Object)dockComponent));
            } else {
                dockTabbedPane = new DockTabbedPane(this);
                DockManager.replace0((Component)((Object)dockComponent), dockTabbedPane);
                dockTabbedPane.add(0, dockComponent);
                n = (n & 0x10) != 0 ? 1 : 0;
            }
            jComponent = dockTabbedPane;
        } else {
            throw new AssertionError(n);
        }
        jComponent.add(n, dockable.getComponent());
        this.select(dockable, false, null);
    }

    public DockComponent wrap(DockComponent dockComponent, boolean bl) {
        if (dockComponent instanceof Dockable) {
            Dockable dockable = (Dockable)dockComponent;
            if (bl) {
                if (dockable.needsWrapper() && (dockComponent = dockable.getComponent()) == dockable) {
                    dockComponent = new DockedFrame(this, dockable);
                    dockable.setWrapper((DockableWrapper)dockComponent);
                }
            } else if (dockable.getComponent() != dockable) {
                ((DockableWrapper)dockable.getComponent()).releaseDockable();
                dockable.setWrapper(null);
            }
        } else if (dockComponent instanceof DockableWrapper && !bl) {
            DockableWrapper dockableWrapper = (DockableWrapper)dockComponent;
            dockComponent = dockableWrapper.getDockable();
            dockableWrapper.releaseDockable();
            ((Dockable)dockComponent).setWrapper(null);
        }
        return dockComponent;
    }

    public static DockContainer getDockParent(DockComponent dockComponent) {
        for (Container container = dockComponent.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof DockContainer)) continue;
            return (DockContainer)((Object)container);
        }
        return null;
    }

    public DockManager(JRootPane jRootPane, DockContentPane dockContentPane) {
        this.dragSource = new DragSource();
        this.mainInfo = this.registerRoot(jRootPane, dockContentPane);
    }

    private RootInfo registerRoot(JRootPane jRootPane, DockContentPane dockContentPane) {
        dockContentPane.setDockManager(this);
        RootInfo rootInfo = new RootInfo(this, jRootPane, dockContentPane);
        this.roots.put(jRootPane, rootInfo);
        return rootInfo;
    }

    void unregisterRoot(JRootPane jRootPane) {
        RootInfo rootInfo = (RootInfo)this.roots.remove(jRootPane);
        if (rootInfo != null) {
            rootInfo.dispose(true);
        }
        if (jRootPane.getParent() instanceof FloatingWindow) {
            ((FloatingWindow)jRootPane.getParent()).removeWindowListener(this);
        }
    }

    private FloatingWindow createFloatingWindow(String string, boolean bl) {
        FloatingWindow floatingWindow;
        Window window = SwingUtilities.getWindowAncestor(this.mainInfo.dockRoot);
        FloatingWindow floatingWindow2 = floatingWindow = window instanceof Frame ? new FloatingWindow((Frame)window) : new FloatingWindow((Dialog)window);
        if (bl) {
            this.registerRoot(floatingWindow.getRootPane(), floatingWindow.getDockRoot());
        }
        floatingWindow.addWindowListener(this);
        floatingWindow.setTitle(string);
        return floatingWindow;
    }

    public void windowClosing(final WindowEvent windowEvent) {
        RootInfo rootInfo = (RootInfo)this.roots.get(((RootPaneContainer)((Object)windowEvent.getWindow())).getRootPane());
        final ArrayList arrayList = new ArrayList();
        rootInfo.getDockables(arrayList, null);
        new Runnable(){

            public void run() {
                if (arrayList.isEmpty()) {
                    windowEvent.getWindow().dispose();
                } else {
                    ((Dockable)arrayList.remove(0)).checkClose(this);
                }
            }
        }.run();
    }

    public FloatingWindow createFloatingWindow(Dockable dockable) {
        FloatingWindow floatingWindow = this.createFloatingWindow(dockable.getPanelTitle(), true);
        dockable.setManager(this);
        floatingWindow.getDockRoot().add(-1, dockable.getComponent());
        this.pack(floatingWindow);
        return floatingWindow;
    }

    void pack(FloatingWindow floatingWindow) {
        floatingWindow.pack();
        if (floatingWindow.getWidth() < 500 || floatingWindow.getHeight() < 300) {
            floatingWindow.setSize(Math.max(floatingWindow.getWidth(), 500), Math.max(floatingWindow.getHeight(), 300));
        }
        floatingWindow.setLocationRelativeTo(this.mainInfo.dockRoot);
    }

    public void hideFloatingWindows() {
        Enumeration enumeration = this.roots.elements();
        while (enumeration.hasMoreElements()) {
            FloatingWindow floatingWindow;
            RootInfo rootInfo = (RootInfo)enumeration.nextElement();
            if (rootInfo == this.mainInfo || (floatingWindow = (FloatingWindow)rootInfo.root.getParent()) == null) continue;
            rootInfo.fwBounds = floatingWindow.getBounds();
            rootInfo.fwTitle = floatingWindow.getTitle();
            floatingWindow.setVisible(false);
            floatingWindow.setRootPane0(null);
            floatingWindow.superDispose();
        }
    }

    public void showFloatingWindows() {
        Enumeration enumeration = this.roots.elements();
        while (enumeration.hasMoreElements()) {
            RootInfo rootInfo = (RootInfo)enumeration.nextElement();
            if (rootInfo == this.mainInfo || rootInfo.root.getParent() != null) continue;
            FloatingWindow floatingWindow = this.createFloatingWindow(rootInfo.fwTitle, false);
            floatingWindow.setRootPane0(rootInfo.root);
            rootInfo.dockRoot.windowChanged();
            floatingWindow.pack();
            floatingWindow.setBounds(rootInfo.fwBounds);
            floatingWindow.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(Dockable dockable, boolean bl, Dockable dockable2) {
        Dockable dockable3 = this.curKeepInFront;
        if (dockable2 == null) {
            dockable2 = dockable3;
        }
        if (dockable2 == dockable) {
            dockable2 = null;
        }
        if (dockable2 != null) {
            this.curKeepInFront = dockable2;
        }
        try {
            if (dockable != null) {
                if (dockable != this.selected) {
                    if (dockable2 != null && dockable2.getDockParent() == dockable.getDockParent()) {
                        return;
                    }
                    if (dockable.isSelectable()) {
                        if (this.selected != null) {
                            this.selected.setSelected(false);
                        }
                        dockable.setSelected(true);
                        this.selected = dockable;
                    }
                    dockable.getDockParent().toFront(dockable.getComponent());
                }
                if (dockable2 != null || !bl) {
                    return;
                }
                Window window = SwingUtilities.getWindowAncestor((Component)((Object)dockable));
                if (window != null) {
                    window.toFront();
                }
            } else if (this.selected != null) {
                this.selected.setSelected(false);
                this.selected = null;
            }
        }
        finally {
            this.curKeepInFront = dockable3;
        }
    }

    public void floatDockable(Dockable dockable) {
        Container container;
        DockableComponent dockableComponent = dockable.getComponent();
        for (container = dockableComponent.getParent(); container != null; container = container.getParent()) {
            if (container instanceof DockableWrapper) {
                dockableComponent = (DockableWrapper)((Object)container);
            }
            if (!(container instanceof DockContainer)) continue;
            ((DockContainer)((Object)container)).remove(dockableComponent);
            break;
        }
        container = this.createFloatingWindow(dockable);
        this.pack((FloatingWindow)container);
        ((Window)container).setVisible(true);
    }

    public void closeDockable(Dockable dockable) {
        DockableComponent dockableComponent = dockable.getComponent();
        for (Container container = dockableComponent.getParent(); container != null; container = container.getParent()) {
            if (container instanceof DockableWrapper) {
                dockableComponent = (DockableWrapper)((Object)container);
            }
            if (!(container instanceof DockContainer)) continue;
            ((DockContainer)((Object)container)).remove(dockableComponent);
            break;
        }
        dockable.dockableClosed();
    }

    public Dockable[] dispose() {
        ArrayList arrayList = new ArrayList();
        Enumeration enumeration = this.roots.elements();
        while (enumeration.hasMoreElements()) {
            RootInfo rootInfo = (RootInfo)enumeration.nextElement();
            arrayList.addAll(rootInfo.dispose(false));
            if (!(rootInfo.getWindow() instanceof FloatingWindow)) continue;
            ((FloatingWindow)rootInfo.getWindow()).superDispose();
        }
        this.roots.clear();
        return arrayList.toArray(new Dockable[arrayList.size()]);
    }

    public Dockable[] closeDockables() {
        ArrayList arrayList = new ArrayList();
        Enumeration enumeration = this.roots.elements();
        while (enumeration.hasMoreElements()) {
            RootInfo rootInfo = (RootInfo)enumeration.nextElement();
            if (rootInfo.getWindow() instanceof FloatingWindow) {
                arrayList.addAll(rootInfo.dispose(false));
                ((FloatingWindow)rootInfo.getWindow()).superDispose();
                continue;
            }
            assert (rootInfo == this.mainInfo);
            arrayList.addAll(rootInfo.release(false));
        }
        this.roots.clear();
        this.roots.put(this.mainInfo.root, this.mainInfo);
        return arrayList.toArray(new Dockable[arrayList.size()]);
    }

    public Dockable[] getDockables(DockableFilter dockableFilter) {
        ArrayList arrayList = new ArrayList();
        Enumeration enumeration = this.roots.elements();
        while (enumeration.hasMoreElements()) {
            ((RootInfo)enumeration.nextElement()).getDockables(arrayList, dockableFilter);
        }
        return arrayList.toArray(new Dockable[arrayList.size()]);
    }

    public void beginDraggingFrame(JComponent jComponent) {
    }

    public void dragFrame(JComponent jComponent, int n, int n2) {
    }

    public void endDraggingFrame(JComponent jComponent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDnD(boolean bl) {
        Hashtable hashtable = this.roots;
        synchronized (hashtable) {
            Enumeration enumeration = this.roots.elements();
            while (enumeration.hasMoreElements()) {
                ((RootInfo)enumeration.nextElement()).setDnD(bl);
            }
        }
    }

    static void uninstallListeners(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        if (objectArray[0] instanceof DragGestureRecognizer) {
            ((DragGestureRecognizer)objectArray[0]).setComponent(null);
        }
        objectArray[0] = null;
        if (objectArray[1] instanceof MouseListener) {
            ((Component)objectArray[2]).removeMouseListener((MouseListener)objectArray[1]);
        }
        objectArray[1] = null;
        objectArray[2] = null;
    }

    Object[] installListeners(Component component, DragGestureListener dragGestureListener, Dockable dockable) {
        return this.installListeners(component, dragGestureListener, new DockMenuListener(this, dockable));
    }

    Object[] installListeners(Component component, DragGestureListener dragGestureListener, MouseListener mouseListener) {
        Object[] objectArray = new Object[3];
        try {
            DragGestureRecognizer dragGestureRecognizer = this.dragSource.createDefaultDragGestureRecognizer(component, 2, null);
            dragGestureRecognizer.addDragGestureListener(dragGestureListener);
            objectArray[0] = dragGestureRecognizer;
        }
        catch (TooManyListenersException tooManyListenersException) {
            throw new AssertionError((Object)tooManyListenersException);
        }
        component.addMouseListener(mouseListener);
        objectArray[1] = mouseListener;
        objectArray[2] = component;
        return objectArray;
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        this.dragGestureRecognized(dragGestureEvent, ((DragSourceComponent)((Object)dragGestureEvent.getComponent())).createContext(dragGestureEvent));
    }

    void dragGestureRecognized(DragGestureEvent dragGestureEvent, DragDockableContext dragDockableContext) {
        if (dragDockableContext == null) {
            return;
        }
        this.setDnD(true);
        dragGestureEvent.startDrag(DragSource.DefaultMoveNoDrop, null, new Point(0, 0), dragDockableContext, this.sourceListener);
    }

    RootInfo getInfo(Component component) {
        while (component != null) {
            Object v;
            if (component instanceof JRootPane && (v = this.roots.get(component)) != null) {
                return (RootInfo)v;
            }
            if (component instanceof Window) {
                return null;
            }
            component = component.getParent();
        }
        return null;
    }

    private static final class RootInfo {
        DockManager manager;
        JRootPane root;
        DockContentPane dockRoot;
        DnDGlassPane dndGlassPane;
        DropTarget dropTarget;
        Rectangle fwBounds;
        String fwTitle;

        RootInfo(DockManager dockManager, JRootPane jRootPane, DockContentPane dockContentPane) {
            this.manager = dockManager;
            this.root = jRootPane;
            this.dockRoot = dockContentPane;
            this.dndGlassPane = new DnDGlassPane(this);
            this.dndGlassPane.setVisible(false);
            jRootPane.setGlassPane(this.dndGlassPane);
        }

        Container getWindow() {
            return this.root.getParent();
        }

        ArrayList dispose(boolean bl) {
            if (this.dropTarget != null) {
                this.dropTarget.setComponent(null);
                this.dropTarget = null;
            }
            ArrayList arrayList = this.release(bl);
            this.dockRoot = null;
            return arrayList;
        }

        ArrayList release(boolean bl) {
            ArrayList arrayList = new ArrayList(10);
            this.getDockables(arrayList, null);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Dockable dockable = (Dockable)arrayList.get(i);
                dockable.getComponent().getParent().remove((Component)((Object)dockable.getComponent()));
                if (!bl) continue;
                dockable.dockableClosed();
            }
            this.dockRoot.removeAll();
            return arrayList;
        }

        void setDnD(boolean bl) {
            if (bl != this.dndGlassPane.dndActive) {
                if (bl && this.dropTarget == null) {
                    this.dropTarget = new DropTarget(this.dndGlassPane, 2, this.manager.targetListener);
                }
                this.dndGlassPane.dndActive = bl;
                this.dndGlassPane.setVisible(bl);
                this.dndGlassPane.repaint();
            }
        }

        void getDockables(ArrayList arrayList, DockableFilter dockableFilter) {
            RootInfo.getDockables(this.dockRoot, arrayList, dockableFilter);
        }

        private static void getDockables(DockComponent dockComponent, ArrayList arrayList, DockableFilter dockableFilter) {
            if (dockComponent instanceof DockableComponent) {
                if (dockableFilter == null || dockableFilter.accept(((DockableComponent)dockComponent).getDockable())) {
                    arrayList.add(((DockableComponent)dockComponent).getDockable());
                }
            } else if (dockComponent instanceof DockContainer) {
                DockContainer dockContainer = (DockContainer)dockComponent;
                int n = dockContainer.getDockComponentCount();
                for (int i = 0; i < n; ++i) {
                    RootInfo.getDockables(dockContainer.getDockComponent(i), arrayList, dockableFilter);
                }
            }
        }
    }

    private static final class DnDGlassPane
    extends JComponent
    implements DockPositionList {
        RootInfo info;
        boolean dndActive = false;
        private Point absPoint = new Point();
        private int minXTol;
        private int minYTol;
        private int stepsBack;
        private TreeSet horzPositions = new TreeSet();
        private TreeSet vertPositions = new TreeSet();
        DockPosition position = null;
        DockPosition newPosition;
        DockPosition tabPosition;

        DnDGlassPane(RootInfo rootInfo) {
            this.setOpaque(false);
            this.info = rootInfo;
        }

        public final void paint(Graphics graphics) {
            DockPosition dockPosition = this.position;
            if (this.dndActive && dockPosition != null) {
                dockPosition.paintDockShape(graphics);
            }
        }

        void setDropPosition(DockPosition dockPosition) {
            if (dockPosition == null) {
                if (this.position != null) {
                    this.position = null;
                    this.repaint();
                }
            } else if (this.position == null || !dockPosition.dockShapeEquals(this.position)) {
                this.position = dockPosition;
                this.repaint();
            }
        }

        void drag(DropTargetDragEvent dropTargetDragEvent) {
            TreeSet treeSet;
            Point point = dropTargetDragEvent.getLocation();
            this.absPoint.setLocation(point);
            point.translate(this.getX(), this.getY());
            this.minXTol = Integer.MAX_VALUE;
            this.minYTol = Integer.MAX_VALUE;
            this.stepsBack = 0;
            this.horzPositions.clear();
            this.vertPositions.clear();
            this.tabPosition = null;
            this.newPosition = null;
            this.findDockPositions(this.info.dockRoot, point, this.getParent());
            TreeSet treeSet2 = treeSet = this.minXTol < this.minYTol ? this.vertPositions : this.horzPositions;
            if (!treeSet.isEmpty()) {
                this.choosePosition(treeSet.iterator(), null);
                if (Math.abs(this.newPosition.getDragDelta()) >= 10) {
                    this.newPosition = null;
                }
            }
            if (this.newPosition == null) {
                this.newPosition = this.tabPosition;
            }
            this.setDropPosition(this.newPosition);
        }

        private void choosePosition(Iterator iterator, DockPosition dockPosition) {
            int n;
            DockPosition dockPosition2 = null;
            if (iterator.hasNext()) {
                dockPosition2 = (DockPosition)iterator.next();
                if (this.newPosition == null) {
                    this.newPosition = dockPosition2;
                }
                if (dockPosition == null || dockPosition2.getLength() > dockPosition.getLength()) {
                    this.choosePosition(iterator, dockPosition2);
                    if (--this.stepsBack == 0) {
                        this.newPosition = dockPosition2;
                    }
                    return;
                }
            }
            if ((n = dockPosition.getDragDelta() >> 1) == 0 || n == -1) {
                this.newPosition = dockPosition;
            } else if (n < 0) {
                ++n;
                while (dockPosition2 != null) {
                    this.newPosition = dockPosition2;
                    if (++n != 0 && iterator.hasNext()) {
                        dockPosition2 = (DockPosition)iterator.next();
                        continue;
                    }
                    break;
                }
            } else {
                this.stepsBack = n + 1;
            }
        }

        private void findDockPositions(DockContainer dockContainer, Point point, Container container) {
            int n = point.x;
            int n2 = point.y;
            DockManager.translate(point, container, (Component)((Object)dockContainer));
            dockContainer.findDockPositions(this, point);
            int n3 = dockContainer.getDockComponentCount();
            for (int i = 0; i < n3; ++i) {
                DockComponent dockComponent = dockContainer.getDockComponent(i);
                if (!(dockComponent instanceof DockContainer)) continue;
                this.findDockPositions((DockContainer)dockComponent, point, (Container)((Object)dockContainer));
            }
            point.x = n;
            point.y = n2;
        }

        public void addDockPosition(DockComponent dockComponent, int n, Point point, DockShape dockShape) {
            DockPosition dockPosition = DockPosition.testDockPosition(dockComponent, n, this.absPoint, point, dockShape);
            if (dockPosition != null) {
                if ((n & 3) != 0) {
                    this.minXTol = Math.min(this.minXTol, dockPosition.getDragDelta());
                    this.vertPositions.add(dockPosition);
                } else if ((n & 0xC) != 0) {
                    this.minYTol = Math.min(this.minYTol, dockPosition.getDragDelta());
                    this.horzPositions.add(dockPosition);
                } else if ((n & 0x30) != 0) {
                    this.tabPosition = dockPosition;
                }
            }
        }
    }
}

