/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.docking;

import de.grogra.docking.DockContainer;
import de.grogra.docking.DockManager;
import de.grogra.docking.Dockable;
import de.grogra.docking.DockableWrapper;
import de.grogra.docking.DragDockableContext;
import de.grogra.docking.DragSourceComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.LabelUI;

public class DockedFrame
extends JPanel
implements DockableWrapper,
PropertyChangeListener {
    private DockManager manager;
    private Dockable content;
    private TitleLabel label;

    public DockedFrame(DockManager dockManager, Dockable dockable) {
        super(new BorderLayout());
        this.manager = dockManager;
        this.content = dockable;
        this.label = new TitleLabel(dockable.getPanelTitle(), dockable.getIcon());
        this.add((Component)this.label, "North");
        this.add((Component)((Object)dockable), "Center");
        dockable.addPropertyChangeListener(this);
        this.label.installListeners();
    }

    public DockManager getDockManager() {
        return this.manager;
    }

    public Dockable getDockable() {
        return this.content;
    }

    public void releaseDockable() {
        this.content.removePropertyChangeListener(this);
        this.label.uninstallListeners();
        this.content = null;
    }

    public DockContainer getDockParent() {
        return DockManager.getDockParent(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        if ("panelTitle".equals(string)) {
            this.label.setText(String.valueOf(object));
        } else if ("toolTip".equals(string)) {
            this.label.setToolTipText(String.valueOf(object));
        } else if ("icon".equals(string)) {
            this.label.setIcon((Icon)object);
        }
    }

    public void setSelected(boolean bl) {
        this.label.setSelected(bl);
    }

    private class TitleLabel
    extends JLabel
    implements DragSourceComponent {
        private Color selectedTitleColor;
        private Color selectedTextColor;
        private Color notSelectedTitleColor;
        private Color notSelectedTextColor;
        private Object[] listeners;
        private boolean selected;

        TitleLabel(String string, Icon icon) {
            super(string, icon, 10);
            this.setOpaque(true);
        }

        public void setUI(LabelUI labelUI) {
            super.setUI(labelUI);
            this.setFont(UIManager.getFont("InternalFrame.titleFont"));
            this.selectedTitleColor = UIManager.getColor("InternalFrame.activeTitleBackground");
            this.selectedTextColor = UIManager.getColor("InternalFrame.activeTitleForeground");
            this.notSelectedTitleColor = UIManager.getColor("InternalFrame.inactiveTitleBackground");
            this.notSelectedTextColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
            this.selected = !this.selected;
            this.setSelected(!this.selected);
        }

        public DragDockableContext createContext(DragGestureEvent dragGestureEvent) {
            return new DragDockableContext(DockedFrame.this.getDockManager(), DockedFrame.this);
        }

        protected void installListeners() {
            this.listeners = DockedFrame.this.getDockManager().installListeners((Component)this, (DragGestureListener)DockedFrame.this.getDockManager(), DockedFrame.this.getDockable());
        }

        protected void uninstallListeners() {
            DockManager.uninstallListeners(this.listeners);
        }

        void setSelected(boolean bl) {
            if (bl != this.selected) {
                this.selected = bl;
                this.setForeground(bl ? this.selectedTextColor : this.notSelectedTextColor);
                this.setBackground(bl ? this.selectedTitleColor : this.notSelectedTitleColor);
            }
        }
    }
}

