/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.docking;

import de.grogra.docking.DockContainer;
import de.grogra.docking.DockManager;
import de.grogra.docking.Dockable;
import de.grogra.docking.DockableComponent;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;

public final class DragDockableContext
implements Transferable {
    private static boolean flavorSet = false;
    private static DataFlavor FLAVOR = null;
    private final DockManager manager;
    private final DockContainer dockContainer;
    private final DockableComponent dockableContainer;

    public static DataFlavor getFlavor() {
        if (!flavorSet) {
            try {
                FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref;class=" + DragDockableContext.class.getName(), "Dockable", DragDockableContext.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException);
            }
            flavorSet = true;
        }
        return FLAVOR;
    }

    public DragDockableContext(DockManager dockManager, DockContainer dockContainer, DockableComponent dockableComponent) {
        this.manager = dockManager;
        this.dockContainer = dockContainer;
        this.dockableContainer = dockableComponent;
    }

    public DragDockableContext(DockManager dockManager, DockableComponent dockableComponent) {
        this(dockManager, DockManager.getDockParent(dockableComponent), dockableComponent);
    }

    public DockManager getManager() {
        return this.manager;
    }

    public DockContainer getDockContainer() {
        return this.dockContainer;
    }

    public DockableComponent getDockableComponent() {
        return this.dockableContainer;
    }

    public Dockable getDockable() {
        return this.dockableContainer.getDockable();
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (DragDockableContext.getFlavor().equals(dataFlavor)) {
            return this;
        }
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return this.dockableContainer.getDockable().getPanelTitle();
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return DragDockableContext.getFlavor().equals(dataFlavor) || DataFlavor.stringFlavor.equals(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DragDockableContext.getFlavor(), DataFlavor.stringFlavor};
    }
}

