/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.awt;

import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Workbench;
import de.grogra.util.EventListener;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import java.util.EventObject;

public class EventAdapter
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
Command {
    private final Context ctx;
    private final EventListener target;
    private final int jobFlags;
    private final InputEvent[] pending = new InputEvent[3];

    public EventAdapter(Context context, EventListener eventListener, int n) {
        context.getClass();
        eventListener.getClass();
        this.ctx = context;
        this.target = eventListener;
        this.jobFlags = n;
    }

    public void install(Component component) {
        component.addKeyListener(this);
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        component.addMouseWheelListener(this);
    }

    public void uninstall(Component component) {
        component.removeKeyListener(this);
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        component.removeMouseWheelListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void post(InputEvent inputEvent, int n) {
        Serializable serializable;
        Workbench workbench;
        boolean bl = true;
        if (n >= 0) {
            workbench = this.pending;
            synchronized (workbench) {
                bl = this.pending[n] == null;
                this.pending[n] = inputEvent;
            }
            serializable = Byte.valueOf((byte)n);
        } else {
            serializable = inputEvent;
        }
        if (bl && (workbench = this.ctx.getWorkbench()) != null) {
            workbench.getJobManager().runLater((Command)this, (Object)serializable, this.ctx, this.jobFlags);
        }
    }

    public String getCommandName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run(Object object, Context context) {
        InputEvent inputEvent;
        if (object instanceof InputEvent) {
            inputEvent = (InputEvent)object;
        } else {
            int n = ((Byte)object).intValue();
            InputEvent[] inputEventArray = this.pending;
            // MONITORENTER : this.pending
            inputEvent = this.pending[n];
            this.pending[n] = null;
            // MONITOREXIT : inputEventArray
        }
        this.target.eventOccured((EventObject)inputEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.post(keyEvent, -1);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.post(keyEvent, -1);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.post(keyEvent, -1);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.post(mouseEvent, -1);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.post(mouseEvent, -1);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.post(mouseEvent, -1);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        mouseEvent.getComponent().requestFocus();
        this.post(mouseEvent, -1);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.post(mouseEvent, -1);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.post(mouseEvent, 0);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.post(mouseEvent, 1);
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.post(mouseWheelEvent, 2);
    }
}

