/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.swing;

import de.grogra.docking.FixedSize;
import de.grogra.pf.ui.swing.PanelSupport;
import de.grogra.pf.ui.swing.PlainPanel;
import de.grogra.util.Map;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.border.SoftBevelBorder;

class StatusBar
extends PlainPanel
implements PropertyChangeListener,
FixedSize {
    JProgressBar bar = new JProgressBar(0, 1000){
        private final int[] time;
        private int index;
        private int count;
        private int sum;
        {
            this.time = new int[16];
        }

        protected void paintComponent(Graphics graphics) {
            long l = System.currentTimeMillis();
            super.paintComponent(graphics);
            this.time[this.index] = (int)(System.currentTimeMillis() - l);
            this.sum += -this.time[this.index] + this.time[this.index];
            this.index = this.index + 1 & 0xF;
            if (this.count < 16) {
                ++this.count;
            }
            StatusBar.this.avgTime = this.sum / this.count;
        }
    };
    JLabel label;
    int avgTime;
    private long lastTime;
    private float lastProgressBarValue = 2.0f;
    private long startTime;

    StatusBar() {
        super((LayoutManager)new BorderLayout(4, 0), null);
        this.add((Component)this.bar, "West");
        this.label = new JLabel(" ");
        this.add((Component)this.label, "Center");
        this.label.setBorder(new SoftBevelBorder(1));
        this.bar.setVisible(false);
        this.bar.setString("");
        this.bar.setStringPainted(true);
    }

    public void initialize(PanelSupport panelSupport, Map map) {
        super.initialize(panelSupport, map);
        panelSupport.getWorkbench().addStatusChangeListener((PropertyChangeListener)this);
    }

    public void dispose() {
        this.getSupport().getWorkbench().removeStatusChangeListener((PropertyChangeListener)this);
    }

    public int getFixedSize() {
        return 2;
    }

    public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
        Object object;
        if ("progress".equals(propertyChangeEvent.getPropertyName()) && (object = (Float)propertyChangeEvent.getNewValue()) != null && ((Float)object).floatValue() >= 0.0f) {
            long l = System.currentTimeMillis();
            if (l - this.lastTime < (long)(8 * this.avgTime)) {
                return;
            }
            this.lastTime = l;
        }
        object = new Runnable(){

            public void run() {
                if ("status".equals(propertyChangeEvent.getPropertyName())) {
                    String string = (String)propertyChangeEvent.getNewValue();
                    StatusBar.this.label.setText(string == null || string.equals("") ? " " : string);
                } else if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                    Float f = (Float)propertyChangeEvent.getNewValue();
                    if (f != null) {
                        if (f.floatValue() < 0.0f) {
                            StatusBar.this.bar.setIndeterminate(true);
                        } else {
                            if (StatusBar.this.lastProgressBarValue > f.floatValue()) {
                                StatusBar.this.startTime = StatusBar.this.lastTime;
                                StatusBar.this.lastProgressBarValue = f.floatValue();
                            } else {
                                long l = (long)((float)(StatusBar.this.lastTime - StatusBar.this.startTime) / f.floatValue() - (float)(StatusBar.this.lastTime - StatusBar.this.startTime)) / 1000L;
                                if (l < 60L) {
                                    StatusBar.this.bar.setString("Remaining: " + l + " sec");
                                } else if (l < 3600L) {
                                    StatusBar.this.bar.setString("Remaining: " + l / 60L + " min");
                                } else {
                                    StatusBar.this.bar.setString("Remaining: " + l / 3600L + " h");
                                }
                                StatusBar.this.lastProgressBarValue = f.floatValue();
                            }
                            StatusBar.this.bar.setIndeterminate(false);
                            StatusBar.this.bar.setValue(Math.max(0, Math.min(Math.round(f.floatValue() * 1000.0f), 1000)));
                        }
                        StatusBar.this.bar.setVisible(true);
                    } else {
                        StatusBar.this.bar.setString("");
                        StatusBar.this.bar.setVisible(false);
                    }
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            object.run();
        } else {
            EventQueue.invokeLater((Runnable)object);
        }
    }
}

