/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.swing;

import de.grogra.docking.DockContentPane;
import de.grogra.docking.DockManager;
import de.grogra.docking.Dockable;
import de.grogra.docking.DockableFilter;
import de.grogra.docking.LAFUpdateListener;
import de.grogra.docking.LayoutConsumer;
import de.grogra.graph.impl.Node;
import de.grogra.icon.IconAdapter;
import de.grogra.icon.IconSource;
import de.grogra.pf.io.FileTypeItem;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Link;
import de.grogra.pf.registry.Option;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.ComponentWrapper;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.FileChooserResult;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.UIToolkit;
import de.grogra.pf.ui.Window;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.awt.DisposeWindow;
import de.grogra.pf.ui.awt.HideComponent;
import de.grogra.pf.ui.event.UIPropertyEditEvent;
import de.grogra.pf.ui.registry.FloatingWindow;
import de.grogra.pf.ui.registry.Layout;
import de.grogra.pf.ui.registry.MainWindow;
import de.grogra.pf.ui.registry.PanelFactory;
import de.grogra.pf.ui.registry.Split;
import de.grogra.pf.ui.registry.Tab;
import de.grogra.pf.ui.swing.PanelSupport;
import de.grogra.pf.ui.swing.RootPane;
import de.grogra.pf.ui.swing.SwingDockable;
import de.grogra.pf.ui.swing.SwingToolkit;
import de.grogra.util.Disposable;
import de.grogra.util.EventListener;
import de.grogra.util.I18NBundle;
import de.grogra.util.Map;
import de.grogra.util.ModifiableMap;
import de.grogra.util.StringMap;
import de.grogra.util.Utils;
import de.grogra.xl.lang.ObjectToBoolean;
import de.grogra.xl.util.ObjectList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Robot;
import java.io.File;
import java.io.Serializable;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.ComponentInputMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public final class WindowSupport
extends PanelSupport
implements Window,
EventListener {
    RootPane frame;
    SwingToolkit manager;
    Workbench workbench;
    DockManager dockManager;
    JFileChooser fileChooser;
    private volatile Dockable[] windowsToDispose;
    private Cursor transparentCursor = null;
    private boolean transparentNotCreated = true;
    private Robot robot = null;
    private boolean robotNotCreated = true;
    private Point framePosition = null;
    private final Command close;
    static final Dimension FILE_ICON_SIZE = new Dimension(16, 16);
    private static final int DISPOSE = 4;
    private static final int SET_TITLE = 5;
    private static final int CHOOSE_FILE = 6;
    private static final int SET_LAYOUT = 7;
    private static final int GET_LAYOUT = 8;
    private static final int SHOW_DIALOG = 9;
    private static final int SHOW_DIALOG_IMPL = 10;
    private static final int SHOW_INPUT_DIALOG = 11;
    private static final int GET_DOCKABLES = 12;

    WindowSupport(SwingToolkit swingToolkit, Command command, Map map) {
        super(new RootPane());
        this.close = command;
        this.frame = (RootPane)this.getComponent();
        this.manager = swingToolkit;
        this.initialize(this, map);
        DockContentPane dockContentPane = new DockContentPane();
        this.frame.setContentPane(dockContentPane);
        Integer n = (Integer)map.get((Object)"screen", null);
        if (n != null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
            if (graphicsDeviceArray.length > n) {
                graphicsDevice = graphicsDeviceArray[n];
            }
            this.framePosition = graphicsDevice.getDefaultConfiguration().getBounds().getLocation();
        }
        this.dockManager = new DockManager(this.frame, dockContentPane);
    }

    public Workbench getWorkbench() {
        return this.workbench;
    }

    public void initializeWorkbench(Workbench workbench) {
        assert (this.workbench == null);
        this.workbench = workbench;
        UIProperty.WORKBENCH_TITLE.addPropertyListener((Context)workbench, (EventListener)this);
    }

    public Object run(int n, int n2, Object object, Object object2) {
        switch (n) {
            case 4: {
                this.windowsToDispose = this.dockManager.dispose();
                this.setVisibleSync(false, null, false);
                break;
            }
            case 5: {
                if (this.frame.getParent() == null) break;
                this.frame.frame.setTitle(String.valueOf(object));
                break;
            }
            case 6: {
                this.chooseFileSync(n2, (FileChooserResult)object, (FileFilter[])object2);
                break;
            }
            case 7: {
                ((Command)object).run((Object)this.dockManager.setLayout(), null);
                break;
            }
            case 8: {
                return this.getLayoutSync();
            }
            case 9: {
                return this.showDialogSync((String)object, object2, n2);
            }
            case 10: {
                return this.showDialogSyncImpl((JDialog)object, (JButton)object2) ? this : null;
            }
            case 11: {
                return this.showInputDialogSync((String[])object, object2);
            }
            case 12: {
                return this.getDockablesSync(object);
            }
            default: {
                return super.run(n, n2, object, object2);
            }
        }
        return null;
    }

    public boolean isVisible() {
        return this.frame.getParent() != null;
    }

    void setVisibleSync(boolean bl, Panel panel, boolean bl2) {
        if (bl) {
            if (this.frame.getParent() != null) {
                this.frame.frame.toFront();
                return;
            }
            this.manager.showInFrame(this.frame, String.valueOf(UIProperty.WORKBENCH_TITLE.getValue((Context)this.workbench)), (Context)this, this.framePosition);
            this.dockManager.showFloatingWindows();
        } else {
            if (this.frame.getParent() == null) {
                return;
            }
            this.dockManager.hideFloatingWindows();
            this.manager.releaseFrame(this.frame, (Context)this);
        }
    }

    Cursor getTransparentCursor() {
        if (this.transparentNotCreated) {
            // empty if block
        }
        return this.transparentCursor;
    }

    Robot getRobot() {
        if (this.robotNotCreated) {
            this.robotNotCreated = false;
            try {
                this.robot = new Robot(this.frame.frame.getGraphicsConfiguration().getDevice());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.robot;
    }

    public void setLayout(final Layout layout, final Map map) {
        Panel[] panelArray = this.getPanels(null);
        final HashMap<String, Panel> hashMap = new HashMap<String, Panel>(panelArray.length);
        final HashMap hashMap2 = new HashMap(panelArray.length);
        for (int i = 0; i < panelArray.length; ++i) {
            hashMap.put(panelArray[i].getPanelId(), panelArray[i]);
        }
        Command command = new Command(){

            public void run(Object object, Context context) {
                if (object != null) {
                    LayoutConsumer layoutConsumer = (LayoutConsumer)object;
                    layoutConsumer.startLayout();
                    this.supply((Item)layout, layoutConsumer);
                    layoutConsumer.endLayout();
                } else {
                    this.supply((Item)layout, null);
                }
            }

            public String getCommandName() {
                return null;
            }

            private void supply(Item item, LayoutConsumer layoutConsumer) {
                Item item2 = item.resolveLink((RegistryContext)WindowSupport.this.getWorkbench());
                if (item2 == null) {
                    System.err.println(item + " cannot be resolved");
                    return;
                }
                if (layoutConsumer == null) {
                    if (item2 instanceof PanelFactory) {
                        Panel panel;
                        String string = (String)item.get((Object)"panelId", null);
                        if (string == null) {
                            string = (String)item2.get((Object)"panelId", null);
                        }
                        if ((panel = (Panel)hashMap.remove(string)) != null) {
                            ((PanelSupport)panel.resolve()).configure((Map)item2);
                        } else {
                            panel = ((PanelFactory)item2).createPanel((Context)WindowSupport.this, map);
                        }
                        if (panel != null) {
                            hashMap2.put(item, panel);
                        }
                    } else {
                        this.supplyChildren(item2, layoutConsumer);
                    }
                    return;
                }
                if (item2 instanceof MainWindow) {
                    layoutConsumer.startMainWindow();
                    this.supplyChildren(item2, layoutConsumer);
                    WindowSupport.this.setMenuVisibility(((MainWindow)item2).isMenuVisible());
                    layoutConsumer.endMainWindow();
                } else if (item2 instanceof FloatingWindow) {
                    FloatingWindow floatingWindow = (FloatingWindow)item2;
                    layoutConsumer.startFloatingWindow(String.valueOf(floatingWindow.getDescription("Name")), floatingWindow.getWidth(), floatingWindow.getHeight());
                    this.supplyChildren(item2, layoutConsumer);
                    layoutConsumer.endFloatingWindow();
                } else if (item2 instanceof Split) {
                    Split split = (Split)item2;
                    layoutConsumer.startSplit(split.getOrientation(), split.getLocation());
                    this.supplyChildren(item2, layoutConsumer);
                    layoutConsumer.endSplit();
                } else if (item2 instanceof Tab) {
                    layoutConsumer.startTabbed(((Tab)item2).getSelectedIndex());
                    this.supplyChildren(item2, layoutConsumer);
                    layoutConsumer.endTabbed();
                } else if (item2 instanceof PanelFactory) {
                    Panel panel = (Panel)hashMap2.get(item);
                    if (panel != null) {
                        layoutConsumer.addDockable((Dockable)panel.getComponent());
                    }
                } else {
                    this.supplyChildren(item2, layoutConsumer);
                }
            }

            private void supplyChildren(Item item, LayoutConsumer layoutConsumer) {
                for (item = (Item)item.getBranch(); item != null; item = (Item)item.getSuccessor()) {
                    this.supply(item, layoutConsumer);
                }
            }
        };
        command.run(null, null);
        this.sync.invokeAndWait(7, command);
        UIProperty.WINDOW_LAYOUT.setValue((Context)this, (Object)layout);
    }

    public Layout getLayout() {
        return (Layout)this.sync.invokeAndWait(8);
    }

    private Layout getLayoutSync() {
        final ObjectList objectList = new ObjectList().push((Object)new Layout(null));
        this.dockManager.supply(new LayoutConsumer(){
            private final StringMap map = new StringMap();

            private void start(Item item) {
                ((Item)objectList.peek(1)).appendBranchNode((Node)item);
                objectList.push((Object)item);
            }

            private void end() {
                objectList.pop();
            }

            public void startLayout() {
            }

            public void endLayout() {
            }

            public void startMainWindow() {
                this.start((Item)new MainWindow(null));
            }

            public void endMainWindow() {
                this.end();
            }

            public void startFloatingWindow(String string, int n, int n2) {
                this.start((Item)new FloatingWindow(null, n, n2));
            }

            public void endFloatingWindow() {
                this.end();
            }

            public void startSplit(int n, float f) {
                this.start((Item)new Split(null, n, f));
            }

            public void endSplit() {
                this.end();
            }

            public void startTabbed(int n) {
                this.start((Item)new Tab(null, n));
            }

            public void endTabbed() {
                this.end();
            }

            public void addDockable(Dockable dockable) {
                if (dockable instanceof SwingDockable) {
                    Link link;
                    PanelSupport panelSupport = ((SwingDockable)dockable).getSupport();
                    this.map.clear();
                    panelSupport.addParameters((ModifiableMap)this.map);
                    String string = panelSupport.getPanelId();
                    String string2 = (String)UIProperty.PANEL_TITLE.getValue((Context)panelSupport);
                    int n = string.indexOf(63);
                    if (n >= 0) {
                        string = string.substring(0, n);
                    }
                    if (string != panelSupport.getPanelId() || !this.map.isEmpty()) {
                        this.map.put("panelId", (Object)panelSupport.getPanelId());
                    }
                    if (this.map.isEmpty()) {
                        link = new Link(null, string);
                        PanelFactory panelFactory = (PanelFactory)Item.resolveItem((RegistryContext)WindowSupport.this.getWorkbench(), (String)string);
                        if (panelFactory == null || !Utils.equal((Object)string2, (Object)panelFactory.getDefaultTitle())) {
                            this.map.put(UIProperty.PANEL_TITLE.getName(), (Object)string2);
                        }
                    } else {
                        link = new PanelFactory(null, string);
                        this.map.put(UIProperty.PANEL_TITLE.getName(), (Object)string2);
                        for (n = 0; n < this.map.size(); ++n) {
                            link.appendBranchNode((Node)Option.createNoneditableOption((String)this.map.getKeyAt(n), (Object)this.map.getValueAt(n)));
                        }
                    }
                    ((Item)objectList.peek(1)).appendBranchNode((Node)link);
                }
            }
        });
        return (Layout)objectList.get(0);
    }

    private Panel[] getDockablesSync(final Object object) {
        final String string = object instanceof String ? (String)object : null;
        Dockable[] dockableArray = this.dockManager.getDockables(object == null ? null : new DockableFilter(){

            public boolean accept(Dockable dockable) {
                return dockable instanceof SwingDockable && (string != null ? string.equals(((SwingDockable)dockable).getSupport().getPanelId()) : ((ObjectToBoolean)object).evaluateBoolean((Object)((SwingDockable)dockable).getSupport()));
            }
        });
        Panel[] panelArray = new Panel[dockableArray.length];
        for (int i = 0; i < dockableArray.length; ++i) {
            panelArray[i] = ((SwingDockable)dockableArray[i]).getSupport().unresolve();
        }
        return panelArray;
    }

    public Panel[] getPanels(ObjectToBoolean objectToBoolean) {
        return (Panel[])this.sync.invokeAndWait(12, objectToBoolean);
    }

    public Panel getPanel(String string) {
        Panel[] panelArray = (Panel[])this.sync.invokeAndWait(12, string);
        return panelArray != null && panelArray.length > 0 ? panelArray[0] : null;
    }

    public void setContent(ComponentWrapper componentWrapper) {
        if (componentWrapper != null) {
            throw new UnsupportedOperationException();
        }
    }

    protected void disposeImpl() {
        UIProperty.WORKBENCH_TITLE.removePropertyListener((Context)this.workbench, (EventListener)this);
        this.sync.invokeAndWait(4);
        for (int i = this.windowsToDispose.length - 1; i >= 0; --i) {
            ((SwingDockable)this.windowsToDispose[i]).dockableClosed();
        }
        this.windowsToDispose = null;
        this.fileChooser = null;
        this.workbench = null;
    }

    public void eventOccured(EventObject eventObject) {
        if (eventObject instanceof UIPropertyEditEvent) {
            this.sync.invokeAndWait(5, ((UIPropertyEditEvent)eventObject).getNewValue());
        }
    }

    public FileChooserResult chooseFile(String string, File file, FileFilter[] fileFilterArray, int n, boolean bl, FileFilter fileFilter) {
        JFileChooser jFileChooser;
        if (file != null && !file.isDirectory()) {
            file = null;
        }
        if ((jFileChooser = this.fileChooser) == null) {
            this.fileChooser = jFileChooser = new JFileChooser(){

                public Icon getIcon(File file) {
                    IconSource iconSource = null;
                    if (file.isDirectory()) {
                        iconSource = (IconSource)UI.I18N.getObject("registry.directory.Icon");
                    } else {
                        FileTypeItem fileTypeItem = FileTypeItem.get((RegistryContext)WindowSupport.this.getWorkbench(), (String)file.getName());
                        if (fileTypeItem != null) {
                            iconSource = (IconSource)fileTypeItem.getDescription("Icon");
                        }
                        if (iconSource == null) {
                            iconSource = (IconSource)UI.I18N.getObject("registry.file.Icon");
                        }
                    }
                    return iconSource == null ? super.getIcon(file) : IconAdapter.create((IconSource)iconSource, (Dimension)FILE_ICON_SIZE);
                }
            };
            if (fileFilter != null) {
                this.fileChooser.setFileFilter(fileFilter);
            }
            new LAFUpdateListener(jFileChooser);
        }
        jFileChooser.setDialogTitle(string);
        FileChooserResult fileChooserResult = new FileChooserResult();
        fileChooserResult.file = file;
        this.sync.invokeAndWait(6, n, fileChooserResult, fileFilterArray);
        return fileChooserResult.validate(bl, n);
    }

    private void chooseFileSync(int n, FileChooserResult fileChooserResult, FileFilter[] fileFilterArray) {
        int n2;
        JFileChooser jFileChooser = this.fileChooser;
        FileFilter fileFilter = jFileChooser.getFileFilter();
        jFileChooser.resetChoosableFileFilters();
        if (fileFilterArray != null && fileFilterArray.length > 0) {
            FileFilter fileFilter2 = fileFilterArray[0];
            for (int i = 0; i < fileFilterArray.length; ++i) {
                jFileChooser.addChoosableFileFilter(fileFilterArray[i]);
                if (fileFilterArray[i] != fileFilter) continue;
                fileFilter2 = fileFilter;
            }
            jFileChooser.setFileFilter(fileFilter2);
        } else {
            jFileChooser.setFileFilter(jFileChooser.getAcceptAllFileFilter());
        }
        jFileChooser.setCurrentDirectory(fileChooserResult.file);
        fileChooserResult.file = null;
        jFileChooser.rescanCurrentDirectory();
        switch (n) {
            case 0: {
                n2 = jFileChooser.showOpenDialog(this.frame.frame);
                break;
            }
            case 1: {
                n2 = jFileChooser.showDialog(this.frame.frame, UI.I18N.getString("filedialog.addbutton"));
                break;
            }
            case 2: {
                n2 = jFileChooser.showSaveDialog(this.frame.frame);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type = " + n);
            }
        }
        if (n2 == 0) {
            fileChooserResult.file = jFileChooser.getSelectedFile();
            fileChooserResult.filter = jFileChooser.getFileFilter();
        }
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setFileSelectionMode(0);
    }

    public int showDialog(final String string, final Object object, final int n) {
        final int[] nArray = new int[1];
        this.workbench.getJobManager().runBlocking(new Runnable(){

            public void run() {
                nArray[0] = (Integer)WindowSupport.this.sync.invokeAndWait(9, n, string, object);
            }
        });
        return nArray[0];
    }

    private int showDialogSync(String string, Object object, int n) {
        switch (n) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                JOptionPane.showMessageDialog(this.frame.frame, object, string, n);
                return 0;
            }
            case 3: {
                return JOptionPane.showConfirmDialog(this.frame.frame, object, string, 0) == 0 ? 0 : 1;
            }
            case 100: {
                switch (JOptionPane.showConfirmDialog(this.frame.frame, object, string, 1)) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                }
                return 2;
            }
            case 101: 
            case 102: {
                JButton jButton;
                JDialog jDialog = new JDialog(this.frame.frame, string, true);
                Container container = jDialog.getContentPane();
                container.setLayout(new BorderLayout(10, 10));
                container.add((Component)object, "Center");
                Container container2 = container;
                container = new Container();
                container2.add((Component)container, "South");
                if (n == 102) {
                    container.setLayout(new GridBagLayout());
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.weightx = 1.0;
                    jButton = new JButton(UI.I18N.getString("dialog.okbutton"));
                    container.add((Component)jButton, gridBagConstraints);
                    JButton jButton2 = new JButton(UI.I18N.getString("dialog.cancelbutton"));
                    jButton2.addActionListener(new HideComponent(jDialog));
                    container.add((Component)jButton2, gridBagConstraints);
                } else {
                    container.setLayout(new BorderLayout());
                    jButton = new JButton(UI.I18N.getString("dialog.closebutton"));
                    container.add((Component)jButton, "East");
                }
                return this.showDialogSyncImpl(jDialog, jButton) || n != 102 ? 0 : 2;
            }
        }
        throw new IllegalArgumentException("Dialog type " + n);
    }

    public String showInputDialog(String string, Object object, String string2) {
        return (String)this.sync.invokeAndWait(11, 0, new String[]{string, string2}, object);
    }

    private String showInputDialogSync(String[] stringArray, Object object) {
        return (String)JOptionPane.showInputDialog(this.frame.frame, object, stringArray[0], 3, null, null, stringArray[1]);
    }

    public int showChoiceDialog(String string, I18NBundle i18NBundle, String string2, String[] stringArray) {
        Object object;
        AbstractButton abstractButton;
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.fill = 2;
        String string3 = i18NBundle.getString(string2 + '.' + "ShortDescription", null);
        if (string3 != null) {
            gridBagConstraints.gridwidth = 0;
            container.add((Component)new JLabel(string3), gridBagConstraints);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        AbstractButton[] abstractButtonArray = new AbstractButton[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            IconSource iconSource;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 17;
            abstractButton = new JRadioButton();
            buttonGroup.add(abstractButton);
            abstractButtonArray[i] = abstractButton;
            if (i == 0) {
                buttonGroup.setSelected(abstractButton.getModel(), true);
            }
            container.add((Component)abstractButton, gridBagConstraints);
            object = string2 + '.' + stringArray[i] + '.';
            String string4 = i18NBundle.getString((String)object + "Name", null);
            string3 = i18NBundle.getString((String)object + "ShortDescription", null);
            if (string4 == null) {
                string4 = string3 == null ? stringArray[i] : string3;
                string3 = null;
            }
            JLabel jLabel = (iconSource = (IconSource)i18NBundle.getObject((String)object + "Icon", null)) != null ? new JLabel(string4, (Icon)IconAdapter.create((IconSource)iconSource, (Dimension)UIToolkit.MENU_ICON_SIZE), 10) : new JLabel(string4);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            container.add((Component)jLabel, gridBagConstraints);
            if (string3 == null) continue;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets.top = 0;
            container.add((Component)new JLabel(string3), gridBagConstraints);
            gridBagConstraints.insets.top = 10;
            gridBagConstraints.gridx = -1;
        }
        JDialog jDialog = new JDialog(this.frame.frame, string != null ? string : i18NBundle.getString(string2 + '.' + "Title", string2), true);
        jDialog.getContentPane().setLayout(new BorderLayout(10, 10));
        jDialog.getContentPane().add((Component)container, "Center");
        container = new Container();
        container.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        object = new JButton(UI.I18N.getString("dialog.okbutton"));
        container.add((Component)object, gridBagConstraints);
        abstractButton = new JButton(UI.I18N.getString("dialog.cancelbutton"));
        abstractButton.addActionListener(new HideComponent(jDialog));
        container.add((Component)abstractButton, gridBagConstraints);
        jDialog.getContentPane().add((Component)container, "South");
        if (this.sync.invokeAndWait(10, 0, jDialog, object) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!buttonGroup.isSelected(abstractButtonArray[i].getModel())) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean showDialogSyncImpl(JDialog jDialog, JButton jButton) {
        HideComponent hideComponent;
        Serializable serializable;
        jDialog.setDefaultCloseOperation(1);
        if (jDialog.isModal()) {
            if (jDialog.getContentPane() instanceof JComponent) {
                serializable = (JComponent)jDialog.getContentPane();
                ((JComponent)serializable).setBorder(new EmptyBorder(10, 10, 10, 10));
                ComponentInputMap componentInputMap = new ComponentInputMap((JComponent)serializable);
                componentInputMap.put(KeyStroke.getKeyStroke(27, 0), this);
                ((JComponent)serializable).setInputMap(2, componentInputMap);
                ActionMap actionMap = new ActionMap();
                actionMap.put(this, new HideComponent(jDialog));
                ((JComponent)serializable).setActionMap(actionMap);
            }
            jButton.setDefaultCapable(true);
            hideComponent = new HideComponent(jDialog);
            jButton.addActionListener(hideComponent);
            jDialog.getRootPane().setDefaultButton(jButton);
        } else {
            hideComponent = null;
        }
        jDialog.pack();
        serializable = jDialog.getSize();
        int n = Math.min(Math.max(((Dimension)serializable).width, 300), 700);
        int n2 = Math.min(Math.max(((Dimension)serializable).height, 200), 500);
        if (n != ((Dimension)serializable).width || n2 != ((Dimension)serializable).height) {
            jDialog.setSize(n, n2);
            jDialog.validate();
        }
        jDialog.setLocationRelativeTo(this.frame.frame);
        jDialog.setVisible(true);
        if (jDialog.isModal()) {
            jDialog.dispose();
        }
        return hideComponent != null && hideComponent.lastEvent != null;
    }

    public Disposable showWaitMessage(String string) {
        final JDialog jDialog = new JDialog(this.frame.frame, UI.I18N.msg("waitingmessage.title"), false);
        jDialog.getContentPane().add(new JLabel(string != null ? UI.I18N.msg("waitingmessage.text", (Object)string) : UI.I18N.msg("waitingmessage.text0")));
        JProgressBar jProgressBar = new JProgressBar();
        jDialog.getContentPane().add((Component)jProgressBar, "South");
        jProgressBar.setIndeterminate(true);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                WindowSupport.this.showDialogSyncImpl(jDialog, null);
            }
        });
        return new DisposeWindow(jDialog);
    }

    void closeRequested() {
        this.getWorkbench().getJobManager().runLater(this.close, null, (Context)this, 10000);
    }

    public void setMenuVisibility(boolean bl) {
        ((JMenuBar)this.menu.getRoot()).setVisible(bl);
    }
}

