/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.annotations.TextAnnotation;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class CategoryTextAnnotation
extends TextAnnotation
implements CategoryAnnotation,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3333360090781320147L;
    private Comparable category;
    private CategoryAnchor categoryAnchor;
    private double value;

    public CategoryTextAnnotation(String string, Comparable comparable, double d) {
        super(string);
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        this.category = comparable;
        this.value = d;
        this.categoryAnchor = CategoryAnchor.MIDDLE;
    }

    public Comparable getCategory() {
        return this.category;
    }

    public void setCategory(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        this.category = comparable;
    }

    public CategoryAnchor getCategoryAnchor() {
        return this.categoryAnchor;
    }

    public void setCategoryAnchor(CategoryAnchor categoryAnchor) {
        if (categoryAnchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.categoryAnchor = categoryAnchor;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public void draw(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, CategoryAxis categoryAxis, ValueAxis valueAxis) {
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        int n = categoryDataset.getColumnIndex(this.category);
        int n2 = categoryDataset.getColumnCount();
        float f = 0.0f;
        float f2 = 0.0f;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(categoryPlot.getDomainAxisLocation(), plotOrientation);
        RectangleEdge rectangleEdge2 = Plot.resolveRangeAxisLocation(categoryPlot.getRangeAxisLocation(), plotOrientation);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            f2 = (float)categoryAxis.getCategoryJava2DCoordinate(this.categoryAnchor, n, n2, rectangle2D, rectangleEdge);
            f = (float)valueAxis.valueToJava2D(this.value, rectangle2D, rectangleEdge2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            f = (float)categoryAxis.getCategoryJava2DCoordinate(this.categoryAnchor, n, n2, rectangle2D, rectangleEdge);
            f2 = (float)valueAxis.valueToJava2D(this.value, rectangle2D, rectangleEdge2);
        }
        graphics2D.setFont(this.getFont());
        graphics2D.setPaint(this.getPaint());
        TextUtilities.drawRotatedString((String)this.getText(), (Graphics2D)graphics2D, (float)f, (float)f2, (TextAnchor)this.getTextAnchor(), (double)this.getRotationAngle(), (TextAnchor)this.getRotationAnchor());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CategoryTextAnnotation)) {
            return false;
        }
        CategoryTextAnnotation categoryTextAnnotation = (CategoryTextAnnotation)object;
        if (!super.equals(object)) {
            return false;
        }
        if (!this.category.equals(categoryTextAnnotation.getCategory())) {
            return false;
        }
        if (!this.categoryAnchor.equals(categoryTextAnnotation.getCategoryAnchor())) {
            return false;
        }
        return this.value == categoryTextAnnotation.getValue();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

