/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.geom.Point2D;
import org.jfree.chart.plot.PlotOrientation;

public class CrosshairState {
    private boolean calculateDistanceInDataSpace = false;
    private double anchorX;
    private double anchorY;
    private Point2D anchor;
    private double crosshairX;
    private double crosshairY;
    private double distance;

    public CrosshairState() {
        this(false);
    }

    public CrosshairState(boolean bl) {
        this.calculateDistanceInDataSpace = bl;
    }

    public void setCrosshairDistance(double d) {
        this.distance = d;
    }

    public void updateCrosshairPoint(double d, double d2, double d3, double d4, PlotOrientation plotOrientation) {
        if (this.anchor != null) {
            double d5 = 0.0;
            if (this.calculateDistanceInDataSpace) {
                d5 = (d - this.anchorX) * (d - this.anchorX) + (d2 - this.anchorY) * (d2 - this.anchorY);
            } else {
                double d6 = this.anchor.getX();
                double d7 = this.anchor.getY();
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    double d8 = d7;
                    d7 = d6;
                    d6 = d8;
                }
                d5 = (d3 - d6) * (d3 - d6) + (d4 - d7) * (d4 - d7);
            }
            if (d5 < this.distance) {
                this.crosshairX = d;
                this.crosshairY = d2;
                this.distance = d5;
            }
        }
    }

    public void updateCrosshairX(double d) {
        double d2 = Math.abs(d - this.anchorX);
        if (d2 < this.distance) {
            this.crosshairX = d;
            this.distance = d2;
        }
    }

    public void updateCrosshairY(double d) {
        double d2 = Math.abs(d - this.anchorY);
        if (d2 < this.distance) {
            this.crosshairY = d;
            this.distance = d2;
        }
    }

    public void setAnchor(Point2D point2D) {
        this.anchor = point2D;
    }

    public double getCrosshairX() {
        return this.crosshairX;
    }

    public void setCrosshairX(double d) {
        this.crosshairX = d;
    }

    public double getCrosshairY() {
        return this.crosshairY;
    }

    public void setCrosshairY(double d) {
        this.crosshairY = d;
    }
}

