/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlotState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleInsets;

public class PiePlot3D
extends PiePlot
implements Serializable {
    private static final long serialVersionUID = 3408984188945161432L;
    private double depthFactor = 0.2;

    public PiePlot3D() {
        this(null);
    }

    public PiePlot3D(PieDataset pieDataset) {
        super(pieDataset);
        this.setCircular(false, false);
    }

    public void setDepthFactor(double d) {
        this.depthFactor = d;
    }

    public double getDepthFactor() {
        return this.depthFactor;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Stroke stroke;
        Paint paint;
        int n;
        Serializable serializable;
        Object object22;
        List list;
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
            plotRenderingInfo.setDataArea(rectangle2D);
        }
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        double d = this.getInteriorGap();
        double d2 = 0.0;
        if (this.getLabelGenerator() != null) {
            d2 = this.getLabelGap() + this.getMaximumLabelWidth() + this.getLabelLinkMargin();
        }
        double d3 = rectangle2D.getWidth() * (d + d2);
        double d4 = rectangle2D.getHeight() * d;
        double d5 = rectangle2D.getX() + d3 / 2.0;
        double d6 = rectangle2D.getY() + d4 / 2.0;
        double d7 = rectangle2D.getWidth() - d3;
        double d8 = rectangle2D.getHeight() - d4;
        if (this.isCircular()) {
            double d9 = Math.min(d7, d8) / 2.0;
            d5 = (d5 + d5 + d7) / 2.0 - d9;
            d6 = (d6 + d6 + d8) / 2.0 - d9;
            d7 = 2.0 * d9;
            d8 = 2.0 * d9;
        }
        PiePlotState piePlotState = this.initialise(graphics2D, rectangle2D, this, null, plotRenderingInfo);
        double d10 = d7 * this.getLabelLinkMargin();
        double d11 = d8 * this.getLabelLinkMargin();
        Rectangle2D.Double double_ = new Rectangle2D.Double(d5 + d10 / 2.0, d6 + d11 / 2.0, d7 - d10, d8 - d11);
        piePlotState.setExplodedPieArea(double_);
        double d12 = this.getMaximumExplodePercent();
        double d13 = d12 / (1.0 + d12);
        double d14 = ((RectangularShape)double_).getWidth() * d13;
        double d15 = ((RectangularShape)double_).getHeight() * d13;
        Rectangle2D.Double double_2 = new Rectangle2D.Double(((RectangularShape)double_).getX() + d14 / 2.0, ((RectangularShape)double_).getY() + d15 / 2.0, ((RectangularShape)double_).getWidth() - d14, ((RectangularShape)double_).getHeight() - d15);
        int n2 = (int)(((RectangularShape)double_2).getHeight() * this.depthFactor);
        Rectangle2D.Double double_3 = new Rectangle2D.Double(d5, d6, d7, d8 - (double)n2);
        piePlotState.setLinkArea(double_3);
        piePlotState.setPieArea(double_2);
        piePlotState.setPieCenterX(double_2.getCenterX());
        piePlotState.setPieCenterY(double_2.getCenterY() - (double)n2 / 2.0);
        piePlotState.setPieWRadius(((RectangularShape)double_2).getWidth() / 2.0);
        piePlotState.setPieHRadius((((RectangularShape)double_2).getHeight() - (double)n2) / 2.0);
        this.drawBackground(graphics2D, rectangle2D);
        PieDataset pieDataset = this.getDataset();
        if (DatasetUtilities.isEmptyOrNull((PieDataset)this.getDataset())) {
            this.drawNoDataMessage(graphics2D, rectangle2D);
            graphics2D.setClip(shape);
            this.drawOutline(graphics2D, rectangle2D);
            return;
        }
        if ((double)pieDataset.getKeys().size() > rectangle2D.getWidth()) {
            String string = "Too many elements";
            Font font = new Font("dialog", 1, 10);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            int n3 = fontMetrics.stringWidth(string);
            graphics2D.drawString(string, (int)(rectangle2D.getX() + (rectangle2D.getWidth() - (double)n3) / 2.0), (int)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0));
            return;
        }
        if (this.isCircular()) {
            double d16 = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight()) / 2.0;
            rectangle2D = new Rectangle2D.Double(rectangle2D.getCenterX() - d16, rectangle2D.getCenterY() - d16, 2.0 * d16, 2.0 * d16);
        }
        if ((list = pieDataset.getKeys()).size() == 0) {
            return;
        }
        double d17 = ((RectangularShape)double_2).getX();
        double d18 = ((RectangularShape)double_2).getY();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        double d19 = DatasetUtilities.calculatePieDatasetTotal((PieDataset)pieDataset);
        double d20 = 0.0;
        if (n2 < 0) {
            return;
        }
        ArrayList<Arc2D.Double> arrayList = new ArrayList<Arc2D.Double>();
        for (Object object22 : list) {
            double d21;
            double d22;
            serializable = pieDataset.getValue((Comparable)object22);
            if (serializable == null) {
                arrayList.add(null);
                continue;
            }
            double d23 = ((Number)serializable).doubleValue();
            if (d23 <= 0.0) {
                arrayList.add(null);
                continue;
            }
            double d24 = this.getStartAngle();
            double d25 = d24 + (d22 = this.getDirection().getFactor()) * (d20 + d23) * 360.0 / d19;
            if (Math.abs(d25 - (d21 = d24 + d22 * (d20 * 360.0) / d19)) > this.getMinimumArcAngleToDraw()) {
                arrayList.add(new Arc2D.Double(d17, d18 + (double)n2, ((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight() - (double)n2, d21, d25 - d21, 2));
            } else {
                arrayList.add(null);
            }
            d20 += d23;
        }
        object22 = graphics2D.getClip();
        serializable = new Ellipse2D.Double(((RectangularShape)double_2).getX(), ((RectangularShape)double_2).getY(), ((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight() - (double)n2);
        Ellipse2D.Double double_4 = new Ellipse2D.Double(((RectangularShape)double_2).getX(), ((RectangularShape)double_2).getY() + (double)n2, ((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight() - (double)n2);
        Rectangle2D.Double double_5 = new Rectangle2D.Double(((RectangularShape)((Object)serializable)).getX(), ((RectangularShape)((Object)serializable)).getCenterY(), ((RectangularShape)double_2).getWidth(), double_4.getMaxY() - ((RectangularShape)((Object)serializable)).getCenterY());
        Rectangle2D.Double double_6 = new Rectangle2D.Double(((RectangularShape)double_2).getX(), ((RectangularShape)((Object)serializable)).getY(), ((RectangularShape)double_2).getWidth(), double_4.getCenterY() - ((RectangularShape)((Object)serializable)).getY());
        Area area = new Area((Shape)((Object)serializable));
        area.add(new Area(double_5));
        Area area2 = new Area(double_4);
        area2.add(new Area(double_6));
        Area area3 = new Area(area);
        area3.intersect(area2);
        Area area4 = new Area(area3);
        area4.subtract(new Area((Shape)((Object)serializable)));
        Area area5 = new Area(area3);
        area5.subtract(new Area(double_4));
        Paint paint2 = this.getSectionOutlinePaint(0);
        Arc2D.Double double_7 = new Arc2D.Double(d17, d18 + (double)n2, ((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight() - (double)n2, 0.0, 360.0, 2);
        int n4 = arrayList.size();
        for (n = 0; n < n4; ++n) {
            double_7 = (Arc2D.Double)arrayList.get(n);
            if (double_7 == null) continue;
            paint = this.getSectionPaint(n);
            paint2 = this.getSectionOutlinePaint(n);
            stroke = this.getSectionOutlineStroke(n);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_7);
            graphics2D.setPaint(paint2);
            graphics2D.setStroke(stroke);
            graphics2D.draw(double_7);
            graphics2D.setPaint(paint);
            Point2D cloneable2 = double_7.getStartPoint();
            int[] nArray = new int[]{(int)double_7.getCenterX(), (int)double_7.getCenterX(), (int)cloneable2.getX(), (int)cloneable2.getX()};
            int[] nArray2 = new int[]{(int)double_7.getCenterY(), (int)double_7.getCenterY() - n2, (int)cloneable2.getY() - n2, (int)cloneable2.getY()};
            Polygon polygon = new Polygon(nArray, nArray2, 4);
            graphics2D.setPaint(Color.lightGray);
            graphics2D.fill(polygon);
            graphics2D.setPaint(paint2);
            graphics2D.setStroke(stroke);
            graphics2D.draw(polygon);
            graphics2D.setPaint(paint);
        }
        graphics2D.setPaint(Color.gray);
        graphics2D.fill(area5);
        graphics2D.fill(area4);
        n = 0;
        for (Arc2D arc2D : arrayList) {
            if (arc2D != null) {
                paint = this.getSectionPaint(n);
                paint2 = this.getSectionOutlinePaint(n);
                stroke = this.getSectionOutlineStroke(n);
                this.drawSide(graphics2D, double_2, arc2D, area4, area5, paint, paint2, stroke, false, true);
            }
            ++n;
        }
        n = 0;
        for (Arc2D arc2D : arrayList) {
            if (arc2D != null) {
                paint = this.getSectionPaint(n);
                paint2 = this.getSectionOutlinePaint(n);
                stroke = this.getSectionOutlineStroke(n);
                this.drawSide(graphics2D, double_2, arc2D, area4, area5, paint, paint2, stroke, true, false);
            }
            ++n;
        }
        graphics2D.setClip((Shape)object22);
        for (int i = 0; i < n4; ++i) {
            Object object;
            Object object3;
            double_7 = (Arc2D.Double)arrayList.get(i);
            if (double_7 == null) continue;
            Arc2D.Double double_8 = new Arc2D.Double(d17, d18, ((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight() - (double)n2, double_7.getAngleStart(), double_7.getAngleExtent(), 2);
            paint = this.getSectionPaint(i);
            paint2 = this.getSectionOutlinePaint(i);
            stroke = this.getSectionOutlineStroke(i);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_8);
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint2);
            graphics2D.draw(double_8);
            Comparable comparable = (Comparable)list.get(i);
            if (plotRenderingInfo != null && (object3 = plotRenderingInfo.getOwner().getEntityCollection()) != null) {
                object = null;
                PieToolTipGenerator pieToolTipGenerator = this.getToolTipGenerator();
                if (pieToolTipGenerator != null) {
                    object = pieToolTipGenerator.generateToolTip(pieDataset, comparable);
                }
                String string = null;
                if (this.getURLGenerator() != null) {
                    string = this.getURLGenerator().generateURL(pieDataset, comparable, this.getPieIndex());
                }
                PieSectionEntity pieSectionEntity = new PieSectionEntity(double_8, pieDataset, this.getPieIndex(), i, comparable, (String)object, string);
                object3.add(pieSectionEntity);
            }
            object3 = pieDataset.getKeys();
            object = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight() - (double)n2);
            this.drawLabels(graphics2D, (List)object3, d19, (Rectangle2D)object, double_3, piePlotState);
        }
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
        this.drawOutline(graphics2D, rectangle2D2);
    }

    protected void drawSide(Graphics2D graphics2D, Rectangle2D rectangle2D, Arc2D arc2D, Area area, Area area2, Paint paint, Paint paint2, Stroke stroke, boolean bl, boolean bl2) {
        double d = arc2D.getAngleStart();
        double d2 = arc2D.getAngleExtent();
        double d3 = d + d2;
        graphics2D.setStroke(stroke);
        if (d2 < 0.0) {
            if (this.isAngleAtFront(d)) {
                if (!this.isAngleAtBack(d3)) {
                    if (d2 > -180.0) {
                        if (bl) {
                            Area area3 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                            area3.intersect(area);
                            graphics2D.setPaint(paint);
                            graphics2D.fill(area3);
                            graphics2D.setPaint(paint2);
                            graphics2D.draw(area3);
                        }
                    } else {
                        Area area4 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                        area4.intersect(area);
                        Area area5 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                        area5.intersect(area);
                        graphics2D.setPaint(paint);
                        if (bl) {
                            graphics2D.fill(area4);
                            graphics2D.fill(area5);
                        }
                        if (bl2) {
                            graphics2D.fill(area2);
                        }
                        graphics2D.setPaint(paint2);
                        if (bl) {
                            graphics2D.draw(area4);
                            graphics2D.draw(area5);
                        }
                        if (bl2) {
                            graphics2D.draw(area2);
                        }
                    }
                } else {
                    Area area6;
                    if (bl2) {
                        area6 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                        area6.intersect(area2);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area6);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area6);
                    }
                    if (bl) {
                        area6 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                        area6.intersect(area);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area6);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area6);
                    }
                }
            } else if (!this.isAngleAtFront(d3)) {
                if (d2 > -180.0) {
                    if (bl2) {
                        Area area7 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                        area7.intersect(area2);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area7);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area7);
                    }
                } else {
                    Area area8 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                    area8.intersect(area2);
                    Area area9 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                    area9.intersect(area2);
                    graphics2D.setPaint(paint);
                    if (bl2) {
                        graphics2D.fill(area8);
                        graphics2D.fill(area9);
                    }
                    if (bl) {
                        graphics2D.fill(area);
                    }
                    graphics2D.setPaint(paint2);
                    if (bl2) {
                        graphics2D.draw(area8);
                        graphics2D.draw(area9);
                    }
                    if (bl) {
                        graphics2D.draw(area);
                    }
                }
            } else {
                Area area10;
                if (bl2) {
                    area10 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                    area10.intersect(area2);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area10);
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(area10);
                }
                if (bl) {
                    area10 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                    area10.intersect(area);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area10);
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(area10);
                }
            }
        } else if (d2 > 0.0) {
            if (this.isAngleAtFront(d)) {
                if (!this.isAngleAtBack(d3)) {
                    if (d2 < 180.0) {
                        if (bl) {
                            Area area11 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                            area11.intersect(area);
                            graphics2D.setPaint(paint);
                            graphics2D.fill(area11);
                            graphics2D.setPaint(paint2);
                            graphics2D.draw(area11);
                        }
                    } else {
                        Area area12 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                        area12.intersect(area);
                        Area area13 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                        area13.intersect(area);
                        graphics2D.setPaint(paint);
                        if (bl) {
                            graphics2D.fill(area12);
                            graphics2D.fill(area13);
                        }
                        if (bl2) {
                            graphics2D.fill(area2);
                        }
                        graphics2D.setPaint(paint2);
                        if (bl) {
                            graphics2D.draw(area12);
                            graphics2D.draw(area13);
                        }
                        if (bl2) {
                            graphics2D.draw(area2);
                        }
                    }
                } else {
                    Area area14;
                    if (bl2) {
                        area14 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                        area14.intersect(area2);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area14);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area14);
                    }
                    if (bl) {
                        area14 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                        area14.intersect(area);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area14);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area14);
                    }
                }
            } else if (!this.isAngleAtFront(d3)) {
                if (d2 < 180.0) {
                    if (bl2) {
                        Area area15 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                        area15.intersect(area2);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area15);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area15);
                    }
                } else {
                    Area area16 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                    area16.intersect(area2);
                    Area area17 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                    area17.intersect(area2);
                    graphics2D.setPaint(paint);
                    if (bl2) {
                        graphics2D.fill(area16);
                        graphics2D.fill(area17);
                    }
                    if (bl) {
                        graphics2D.fill(area);
                    }
                    graphics2D.setPaint(paint2);
                    if (bl2) {
                        graphics2D.draw(area16);
                        graphics2D.draw(area17);
                    }
                    if (bl) {
                        graphics2D.draw(area);
                    }
                }
            } else {
                Area area18;
                if (bl2) {
                    area18 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                    area18.intersect(area2);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area18);
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(area18);
                }
                if (bl) {
                    area18 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                    area18.intersect(area);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area18);
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(area18);
                }
            }
        }
    }

    public String getPlotType() {
        return localizationResources.getString("Pie_3D_Plot");
    }

    private boolean isAngleAtFront(double d) {
        return Math.sin(Math.toRadians(d)) < 0.0;
    }

    private boolean isAngleAtBack(double d) {
        return Math.sin(Math.toRadians(d)) > 0.0;
    }
}

