/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.PolarItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.text.TextUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.BooleanList;
import org.jfree.util.BooleanUtilities;

public class DefaultPolarItemRenderer
extends AbstractRenderer
implements PolarItemRenderer {
    private PolarPlot plot;
    private BooleanList seriesFilled = new BooleanList();

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        PolarPlot polarPlot = this.getPlot();
        if (polarPlot != null) {
            drawingSupplier = polarPlot.getDrawingSupplier();
        }
        return drawingSupplier;
    }

    public void setPlot(PolarPlot polarPlot) {
        this.plot = polarPlot;
    }

    public PolarPlot getPlot() {
        return this.plot;
    }

    public void drawSeries(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, PolarPlot polarPlot, XYDataset xYDataset, int n) {
        Polygon polygon = new Polygon();
        int n2 = xYDataset.getItemCount(n);
        for (int i = 0; i < n2; ++i) {
            double d = xYDataset.getXValue(n, i);
            double d2 = xYDataset.getYValue(n, i);
            Point point = polarPlot.translateValueThetaRadiusToJava2D(d, d2, rectangle2D);
            polygon.addPoint(point.x, point.y);
        }
        graphics2D.setPaint(this.getSeriesPaint(n));
        graphics2D.setStroke(this.getSeriesStroke(n));
        if (this.isSeriesFilled(n)) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
            graphics2D.fill(polygon);
            graphics2D.setComposite(composite);
        } else {
            graphics2D.draw(polygon);
        }
    }

    public boolean isSeriesFilled(int n) {
        boolean bl = false;
        Boolean bl2 = this.seriesFilled.getBoolean(n);
        if (bl2 != null) {
            bl = bl2;
        }
        return bl;
    }

    public void setSeriesFilled(int n, boolean bl) {
        this.seriesFilled.setBoolean(n, BooleanUtilities.valueOf((boolean)bl));
    }

    public void drawAngularGridLines(Graphics2D graphics2D, PolarPlot polarPlot, List list, Rectangle2D rectangle2D) {
        graphics2D.setFont(polarPlot.getAngleLabelFont());
        graphics2D.setStroke(polarPlot.getAngleGridlineStroke());
        graphics2D.setPaint(polarPlot.getAngleGridlinePaint());
        double d = polarPlot.getAxis().getLowerBound();
        double d2 = polarPlot.getMaxRadius();
        Point point = polarPlot.translateValueThetaRadiusToJava2D(d, d, rectangle2D);
        for (NumberTick numberTick : list) {
            Point point2 = polarPlot.translateValueThetaRadiusToJava2D(numberTick.getNumber().doubleValue(), d2, rectangle2D);
            graphics2D.setPaint(polarPlot.getAngleGridlinePaint());
            graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
            if (!polarPlot.isAngleLabelsVisible()) continue;
            int n = point2.x;
            int n2 = point2.y;
            graphics2D.setPaint(polarPlot.getAngleLabelPaint());
            TextUtilities.drawAlignedString((String)numberTick.getText(), (Graphics2D)graphics2D, (float)n, (float)n2, (TextAnchor)TextAnchor.CENTER);
        }
    }

    public void drawRadialGridLines(Graphics2D graphics2D, PolarPlot polarPlot, ValueAxis valueAxis, List list, Rectangle2D rectangle2D) {
        graphics2D.setFont(valueAxis.getTickLabelFont());
        graphics2D.setPaint(polarPlot.getRadiusGridlinePaint());
        graphics2D.setStroke(polarPlot.getRadiusGridlineStroke());
        double d = valueAxis.getLowerBound();
        Point point = polarPlot.translateValueThetaRadiusToJava2D(d, d, rectangle2D);
        for (NumberTick numberTick : list) {
            Point point2 = polarPlot.translateValueThetaRadiusToJava2D(90.0, numberTick.getNumber().doubleValue(), rectangle2D);
            int n = point2.x - point.x;
            int n2 = point.x - n;
            int n3 = point.y - n;
            int n4 = 2 * n;
            Ellipse2D.Double double_ = new Ellipse2D.Double(n2, n3, n4, n4);
            graphics2D.setPaint(polarPlot.getRadiusGridlinePaint());
            graphics2D.draw(double_);
        }
    }

    public LegendItem getLegendItem(int n) {
        XYDataset xYDataset;
        LegendItem legendItem = null;
        PolarPlot polarPlot = this.getPlot();
        if (polarPlot != null && (xYDataset = polarPlot.getDataset()) != null) {
            String string;
            String string2 = string = xYDataset.getSeriesKey(n).toString();
            Shape shape = this.getSeriesShape(n);
            Paint paint = this.getSeriesPaint(n);
            Paint paint2 = this.getSeriesOutlinePaint(n);
            Stroke stroke = this.getSeriesOutlineStroke(n);
            legendItem = new LegendItem(string, string2, null, null, shape, paint, stroke, paint2);
        }
        return legendItem;
    }
}

