/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardXYSeriesLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.text.TextUtilities;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.Layer;
import org.jfree.ui.LengthAdjustmentType;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public abstract class AbstractXYItemRenderer
extends AbstractRenderer
implements XYItemRenderer,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8019124836026607990L;
    private XYPlot plot;
    private XYItemLabelGenerator itemLabelGenerator = null;
    private ObjectList itemLabelGeneratorList = new ObjectList();
    private XYItemLabelGenerator baseItemLabelGenerator;
    private XYToolTipGenerator toolTipGenerator = null;
    private ObjectList toolTipGeneratorList = new ObjectList();
    private XYToolTipGenerator baseToolTipGenerator;
    private XYURLGenerator urlGenerator = null;
    private List backgroundAnnotations = new ArrayList();
    private List foregroundAnnotations = new ArrayList();
    private int defaultEntityRadius = 3;
    private XYSeriesLabelGenerator legendItemLabelGenerator = new StandardXYSeriesLabelGenerator("{0}");
    private XYSeriesLabelGenerator legendItemToolTipGenerator;
    private XYSeriesLabelGenerator legendItemURLGenerator;

    protected AbstractXYItemRenderer() {
    }

    public int getPassCount() {
        return 1;
    }

    public XYPlot getPlot() {
        return this.plot;
    }

    public void setPlot(XYPlot xYPlot) {
        this.plot = xYPlot;
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYItemRendererState xYItemRendererState = new XYItemRendererState(plotRenderingInfo);
        return xYItemRendererState;
    }

    public XYItemLabelGenerator getItemLabelGenerator(int n, int n2) {
        return this.getSeriesItemLabelGenerator(n);
    }

    public XYItemLabelGenerator getSeriesItemLabelGenerator(int n) {
        if (this.itemLabelGenerator != null) {
            return this.itemLabelGenerator;
        }
        XYItemLabelGenerator xYItemLabelGenerator = (XYItemLabelGenerator)this.itemLabelGeneratorList.get(n);
        if (xYItemLabelGenerator == null) {
            xYItemLabelGenerator = this.baseItemLabelGenerator;
        }
        return xYItemLabelGenerator;
    }

    public void setItemLabelGenerator(XYItemLabelGenerator xYItemLabelGenerator) {
        this.itemLabelGenerator = xYItemLabelGenerator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setSeriesItemLabelGenerator(int n, XYItemLabelGenerator xYItemLabelGenerator) {
        this.itemLabelGeneratorList.set(n, (Object)xYItemLabelGenerator);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYItemLabelGenerator getBaseItemLabelGenerator() {
        return this.baseItemLabelGenerator;
    }

    public void setBaseItemLabelGenerator(XYItemLabelGenerator xYItemLabelGenerator) {
        this.baseItemLabelGenerator = xYItemLabelGenerator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYToolTipGenerator getToolTipGenerator(int n, int n2) {
        return this.getSeriesToolTipGenerator(n);
    }

    public XYToolTipGenerator getSeriesToolTipGenerator(int n) {
        if (this.toolTipGenerator != null) {
            return this.toolTipGenerator;
        }
        XYToolTipGenerator xYToolTipGenerator = (XYToolTipGenerator)this.toolTipGeneratorList.get(n);
        if (xYToolTipGenerator == null) {
            xYToolTipGenerator = this.baseToolTipGenerator;
        }
        return xYToolTipGenerator;
    }

    public void setToolTipGenerator(XYToolTipGenerator xYToolTipGenerator) {
        this.toolTipGenerator = xYToolTipGenerator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setSeriesToolTipGenerator(int n, XYToolTipGenerator xYToolTipGenerator) {
        this.toolTipGeneratorList.set(n, (Object)xYToolTipGenerator);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYToolTipGenerator getBaseToolTipGenerator() {
        return this.baseToolTipGenerator;
    }

    public void setBaseToolTipGenerator(XYToolTipGenerator xYToolTipGenerator) {
        this.baseToolTipGenerator = xYToolTipGenerator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(XYURLGenerator xYURLGenerator) {
        this.urlGenerator = xYURLGenerator;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void addAnnotation(XYAnnotation xYAnnotation) {
        this.addAnnotation(xYAnnotation, Layer.FOREGROUND);
    }

    public void addAnnotation(XYAnnotation xYAnnotation, Layer layer) {
        if (xYAnnotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        if (layer.equals((Object)Layer.FOREGROUND)) {
            this.foregroundAnnotations.add(xYAnnotation);
            this.notifyListeners(new RendererChangeEvent(this));
        } else if (layer.equals((Object)Layer.BACKGROUND)) {
            this.backgroundAnnotations.add(xYAnnotation);
            this.notifyListeners(new RendererChangeEvent(this));
        } else {
            throw new RuntimeException("Unknown layer.");
        }
    }

    public boolean removeAnnotation(XYAnnotation xYAnnotation) {
        boolean bl = this.foregroundAnnotations.remove(xYAnnotation);
        this.notifyListeners(new RendererChangeEvent(this));
        return bl &= this.backgroundAnnotations.remove(xYAnnotation);
    }

    public void removeAnnotations() {
        this.foregroundAnnotations.clear();
        this.backgroundAnnotations.clear();
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public int getDefaultEntityRadius() {
        return this.defaultEntityRadius;
    }

    public void setDefaultEntityRadius(int n) {
        this.defaultEntityRadius = n;
    }

    public XYSeriesLabelGenerator getLegendItemLabelGenerator() {
        return this.legendItemLabelGenerator;
    }

    public void setLegendItemLabelGenerator(XYSeriesLabelGenerator xYSeriesLabelGenerator) {
        if (xYSeriesLabelGenerator == null) {
            throw new IllegalArgumentException("Null 'generator' argument.");
        }
        this.legendItemLabelGenerator = xYSeriesLabelGenerator;
    }

    public XYSeriesLabelGenerator getLegendItemToolTipGenerator() {
        return this.legendItemToolTipGenerator;
    }

    public void setLegendItemToolTipGenerator(XYSeriesLabelGenerator xYSeriesLabelGenerator) {
        this.legendItemToolTipGenerator = xYSeriesLabelGenerator;
    }

    public XYSeriesLabelGenerator getLegendItemURLGenerator() {
        return this.legendItemURLGenerator;
    }

    public void setLegendItemURLGenerator(XYSeriesLabelGenerator xYSeriesLabelGenerator) {
        this.legendItemURLGenerator = xYSeriesLabelGenerator;
    }

    public Range findDomainBounds(XYDataset xYDataset) {
        if (xYDataset != null) {
            return DatasetUtilities.findDomainBounds((XYDataset)xYDataset, (boolean)false);
        }
        return null;
    }

    public Range findRangeBounds(XYDataset xYDataset) {
        if (xYDataset != null) {
            return DatasetUtilities.findRangeBounds((XYDataset)xYDataset, (boolean)false);
        }
        return null;
    }

    public LegendItemCollection getLegendItems() {
        if (this.plot == null) {
            return new LegendItemCollection();
        }
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        int n = this.plot.getIndexOf(this);
        XYDataset xYDataset = this.plot.getDataset(n);
        if (xYDataset != null) {
            int n2 = xYDataset.getSeriesCount();
            for (int i = 0; i < n2; ++i) {
                LegendItem legendItem;
                if (!this.isSeriesVisibleInLegend(i) || (legendItem = this.getLegendItem(n, i)) == null) continue;
                legendItemCollection.add(legendItem);
            }
        }
        return legendItemCollection;
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYDataset xYDataset;
        LegendItem legendItem = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null && (xYDataset = xYPlot.getDataset(n)) != null) {
            String string;
            String string2 = string = this.legendItemLabelGenerator.generateLabel(xYDataset, n2);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n2);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n2);
            }
            Shape shape = this.getSeriesShape(n2);
            Paint paint = this.getSeriesPaint(n2);
            Paint paint2 = this.getSeriesOutlinePaint(n2);
            Stroke stroke = this.getSeriesOutlineStroke(n2);
            legendItem = new LegendItem(string, string2, string3, string4, shape, paint, stroke, paint2);
        }
        return legendItem;
    }

    public void fillDomainGridBand(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d, double d2) {
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, xYPlot.getDomainAxisEdge());
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, rectangle2D.getMinY(), d4 - d3, rectangle2D.getMaxY() - rectangle2D.getMinY());
        Paint paint = xYPlot.getDomainTickBandPaint();
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
        }
    }

    public void fillRangeGridBand(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d, double d2) {
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getMinX(), d4, rectangle2D.getWidth(), d3 - d4);
        Paint paint = xYPlot.getRangeTickBandPaint();
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
        }
    }

    public void drawDomainGridLine(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d) {
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        double d2 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
        Line2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        }
        Paint paint = xYPlot.getDomainGridlinePaint();
        Stroke stroke = xYPlot.getDomainGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public void drawRangeLine(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d, Paint paint, Stroke stroke) {
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Line2D.Double double_ = null;
        double d2 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        graphics2D.draw(double_);
    }

    public void drawDomainMarker(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        if (marker instanceof ValueMarker) {
            ValueMarker valueMarker = (ValueMarker)marker;
            double d = valueMarker.getValue();
            Range range = valueAxis.getRange();
            if (!range.contains(d)) {
                return;
            }
            double d2 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
            }
            graphics2D.setPaint(marker.getPaint());
            graphics2D.setStroke(marker.getStroke());
            graphics2D.draw(double_);
            String string = marker.getLabel();
            RectangleAnchor rectangleAnchor = marker.getLabelAnchor();
            if (string != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                Point2D point2D = this.calculateDomainMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_.getBounds2D(), marker.getLabelOffset(), LengthAdjustmentType.EXPAND, rectangleAnchor);
                TextUtilities.drawAlignedString((String)string, (Graphics2D)graphics2D, (float)((float)point2D.getX()), (float)((float)point2D.getY()), (TextAnchor)marker.getLabelTextAnchor());
            }
        } else if (marker instanceof IntervalMarker) {
            GradientPaintTransformer gradientPaintTransformer;
            Object object;
            IntervalMarker intervalMarker = (IntervalMarker)marker;
            double d = intervalMarker.getStartValue();
            double d3 = intervalMarker.getEndValue();
            Range range = valueAxis.getRange();
            if (!range.intersects(d, d3)) {
                return;
            }
            d = range.constrain(d);
            d3 = range.constrain(d3);
            double d4 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
            double d5 = valueAxis.valueToJava2D(d3, rectangle2D, xYPlot.getDomainAxisEdge());
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            Rectangle2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Rectangle2D.Double(rectangle2D.getMinX(), Math.min(d4, d5), rectangle2D.getWidth(), Math.abs(d5 - d4));
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Rectangle2D.Double(Math.min(d4, d5), rectangle2D.getMinY(), Math.abs(d5 - d4), rectangle2D.getHeight());
            }
            Paint paint = marker.getPaint();
            if (paint instanceof GradientPaint) {
                object = (GradientPaint)paint;
                gradientPaintTransformer = intervalMarker.getGradientPaintTransformer();
                if (gradientPaintTransformer != null) {
                    object = gradientPaintTransformer.transform((GradientPaint)object, (Shape)double_);
                }
                graphics2D.setPaint((Paint)object);
            } else {
                graphics2D.setPaint(paint);
            }
            graphics2D.fill(double_);
            object = marker.getLabel();
            gradientPaintTransformer = marker.getLabelAnchor();
            if (object != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                Point2D point2D = this.calculateDomainMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_, marker.getLabelOffset(), marker.getLabelOffsetType(), (RectangleAnchor)gradientPaintTransformer);
                TextUtilities.drawAlignedString((String)object, (Graphics2D)graphics2D, (float)((float)point2D.getX()), (float)((float)point2D.getY()), (TextAnchor)marker.getLabelTextAnchor());
            }
        }
    }

    protected Point2D calculateDomainMarkerTextAnchorPoint(Graphics2D graphics2D, PlotOrientation plotOrientation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleInsets rectangleInsets, LengthAdjustmentType lengthAdjustmentType, RectangleAnchor rectangleAnchor) {
        Rectangle2D rectangle2D3 = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, LengthAdjustmentType.CONTRACT, lengthAdjustmentType);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, lengthAdjustmentType, LengthAdjustmentType.CONTRACT);
        }
        return RectangleAnchor.coordinates((Rectangle2D)rectangle2D3, (RectangleAnchor)rectangleAnchor);
    }

    public void drawRangeMarker(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        if (marker instanceof ValueMarker) {
            ValueMarker valueMarker = (ValueMarker)marker;
            double d = valueMarker.getValue();
            Range range = valueAxis.getRange();
            if (!range.contains(d)) {
                return;
            }
            double d2 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            Line2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
            }
            graphics2D.setPaint(marker.getPaint());
            graphics2D.setStroke(marker.getStroke());
            graphics2D.draw(double_);
            String string = marker.getLabel();
            RectangleAnchor rectangleAnchor = marker.getLabelAnchor();
            if (string != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                Point2D point2D = this.calculateRangeMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_.getBounds2D(), marker.getLabelOffset(), LengthAdjustmentType.EXPAND, rectangleAnchor);
                TextUtilities.drawAlignedString((String)string, (Graphics2D)graphics2D, (float)((float)point2D.getX()), (float)((float)point2D.getY()), (TextAnchor)marker.getLabelTextAnchor());
            }
        } else if (marker instanceof IntervalMarker) {
            GradientPaintTransformer gradientPaintTransformer;
            Object object;
            IntervalMarker intervalMarker = (IntervalMarker)marker;
            double d = intervalMarker.getStartValue();
            double d3 = intervalMarker.getEndValue();
            Range range = valueAxis.getRange();
            if (!range.intersects(d, d3)) {
                return;
            }
            d = range.constrain(d);
            d3 = range.constrain(d3);
            double d4 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
            double d5 = valueAxis.valueToJava2D(d3, rectangle2D, xYPlot.getRangeAxisEdge());
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            Rectangle2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Rectangle2D.Double(Math.min(d4, d5), rectangle2D.getMinY(), Math.abs(d5 - d4), rectangle2D.getHeight());
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Rectangle2D.Double(rectangle2D.getMinX(), Math.min(d4, d5), rectangle2D.getWidth(), Math.abs(d4 - d5));
            }
            Paint paint = marker.getPaint();
            if (paint instanceof GradientPaint) {
                object = (GradientPaint)paint;
                gradientPaintTransformer = intervalMarker.getGradientPaintTransformer();
                if (gradientPaintTransformer != null) {
                    object = gradientPaintTransformer.transform((GradientPaint)object, (Shape)double_);
                }
                graphics2D.setPaint((Paint)object);
            } else {
                graphics2D.setPaint(paint);
            }
            graphics2D.fill(double_);
            object = marker.getLabel();
            gradientPaintTransformer = marker.getLabelAnchor();
            if (object != null) {
                Font font = marker.getLabelFont();
                graphics2D.setFont(font);
                graphics2D.setPaint(marker.getLabelPaint());
                Point2D point2D = this.calculateRangeMarkerTextAnchorPoint(graphics2D, plotOrientation, rectangle2D, double_, marker.getLabelOffset(), marker.getLabelOffsetType(), (RectangleAnchor)gradientPaintTransformer);
                TextUtilities.drawAlignedString((String)object, (Graphics2D)graphics2D, (float)((float)point2D.getX()), (float)((float)point2D.getY()), (TextAnchor)marker.getLabelTextAnchor());
            }
        }
    }

    private Point2D calculateRangeMarkerTextAnchorPoint(Graphics2D graphics2D, PlotOrientation plotOrientation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleInsets rectangleInsets, LengthAdjustmentType lengthAdjustmentType, RectangleAnchor rectangleAnchor) {
        Rectangle2D rectangle2D3 = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, lengthAdjustmentType, LengthAdjustmentType.CONTRACT);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            rectangle2D3 = rectangleInsets.createAdjustedRectangle(rectangle2D2, LengthAdjustmentType.CONTRACT, lengthAdjustmentType);
        }
        return RectangleAnchor.coordinates((Rectangle2D)rectangle2D3, (RectangleAnchor)rectangleAnchor);
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractXYItemRenderer abstractXYItemRenderer = (AbstractXYItemRenderer)super.clone();
        if (this.itemLabelGenerator != null && this.itemLabelGenerator instanceof PublicCloneable) {
            PublicCloneable publicCloneable = (PublicCloneable)this.itemLabelGenerator;
            abstractXYItemRenderer.itemLabelGenerator = (XYItemLabelGenerator)publicCloneable.clone();
        }
        return abstractXYItemRenderer;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractXYItemRenderer)) {
            return false;
        }
        AbstractXYItemRenderer abstractXYItemRenderer = (AbstractXYItemRenderer)object;
        if (!super.equals(object)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)this.itemLabelGenerator, (Object)abstractXYItemRenderer.itemLabelGenerator)) {
            return false;
        }
        return ObjectUtilities.equal((Object)this.urlGenerator, (Object)abstractXYItemRenderer.urlGenerator);
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null) {
            drawingSupplier = xYPlot.getDrawingSupplier();
        }
        return drawingSupplier;
    }

    protected void updateCrosshairValues(CrosshairState crosshairState, double d, double d2, double d3, double d4, PlotOrientation plotOrientation) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        if (crosshairState != null) {
            if (this.plot.isDomainCrosshairLockedOnData()) {
                if (this.plot.isRangeCrosshairLockedOnData()) {
                    crosshairState.updateCrosshairPoint(d, d2, d3, d4, plotOrientation);
                } else {
                    crosshairState.updateCrosshairX(d);
                }
            } else if (this.plot.isRangeCrosshairLockedOnData()) {
                crosshairState.updateCrosshairY(d2);
            }
        }
    }

    protected void drawItemLabel(Graphics2D graphics2D, PlotOrientation plotOrientation, XYDataset xYDataset, int n, int n2, double d, double d2, boolean bl) {
        XYItemLabelGenerator xYItemLabelGenerator = this.getItemLabelGenerator(n, n2);
        if (xYItemLabelGenerator != null) {
            Font font = this.getItemLabelFont(n, n2);
            Paint paint = this.getItemLabelPaint(n, n2);
            graphics2D.setFont(font);
            graphics2D.setPaint(paint);
            String string = xYItemLabelGenerator.generateLabel(xYDataset, n, n2);
            ItemLabelPosition itemLabelPosition = null;
            itemLabelPosition = !bl ? this.getPositiveItemLabelPosition(n, n2) : this.getNegativeItemLabelPosition(n, n2);
            Point2D point2D = this.calculateLabelAnchorPoint(itemLabelPosition.getItemLabelAnchor(), d, d2, plotOrientation);
            TextUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)((float)point2D.getX()), (float)((float)point2D.getY()), (TextAnchor)itemLabelPosition.getTextAnchor(), (double)itemLabelPosition.getAngle(), (TextAnchor)itemLabelPosition.getRotationAnchor());
        }
    }

    public void drawAnnotations(Graphics2D graphics2D, Rectangle2D rectangle2D, ValueAxis valueAxis, ValueAxis valueAxis2, Layer layer, PlotRenderingInfo plotRenderingInfo) {
        Iterator iterator = null;
        if (layer.equals((Object)Layer.FOREGROUND)) {
            iterator = this.foregroundAnnotations.iterator();
        } else if (layer.equals((Object)Layer.BACKGROUND)) {
            iterator = this.backgroundAnnotations.iterator();
        } else {
            throw new RuntimeException("Unknown layer.");
        }
        while (iterator.hasNext()) {
            XYAnnotation xYAnnotation = (XYAnnotation)iterator.next();
            xYAnnotation.draw(graphics2D, this.plot, rectangle2D, valueAxis, valueAxis2, 0, plotRenderingInfo);
        }
    }

    protected void addEntity(EntityCollection entityCollection, Shape shape, XYDataset xYDataset, int n, int n2, double d, double d2) {
        if (!this.getItemCreateEntity(n, n2)) {
            return;
        }
        if (shape == null) {
            shape = new Ellipse2D.Double(d - (double)this.defaultEntityRadius, d2 - (double)this.defaultEntityRadius, this.defaultEntityRadius * 2, this.defaultEntityRadius * 2);
        }
        String string = null;
        XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
        if (xYToolTipGenerator != null) {
            string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
        }
        String string2 = null;
        if (this.getURLGenerator() != null) {
            string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
        }
        XYItemEntity xYItemEntity = new XYItemEntity(shape, xYDataset, n, n2, string, string2);
        entityCollection.add(xYItemEntity);
    }
}

