/*
 * Decompiled with CFR 0.152.
 */
package pi6.geom;

import java.util.Vector;
import pi6.geom.Circle2;
import pi6.geom.Line2;
import pi6.geom.Point2;
import pi6.geom.Polygon2;
import pi6.geom.Ray2;
import pi6.geom.Segment2;

public final class Triangle2 {
    protected Point2 a;
    protected Point2 b;
    protected Point2 c;
    protected Triangle2 abnext;
    protected Triangle2 bcnext;
    protected Triangle2 canext;
    private Circle2 circum;
    protected boolean halfplane = false;
    private boolean visitflag;
    private static boolean visitTrValue = false;
    private static boolean visitPtValue = false;

    public Triangle2(Point2 A, Point2 B, Point2 C) {
        this.a = A;
        int res = C.pointLineTest(A, B);
        if (res <= 1 || res == 3 || res == 4) {
            this.b = B;
            this.c = C;
        } else {
            System.out.println("Warning, Triangle2(A,B,C) expects points in counterclockwise order.");
            System.out.println(new StringBuilder().append(A).append(B).append(C).toString());
            this.b = C;
            this.c = B;
        }
        this.circumcircle();
        this.visitflag = visitTrValue;
        this.a.visitflag = visitPtValue;
        this.b.visitflag = visitPtValue;
        this.c.visitflag = visitPtValue;
    }

    public Triangle2(Point2 A, Point2 B) {
        this.a = A;
        this.b = B;
        this.halfplane = true;
        this.visitflag = visitTrValue;
        this.a.visitflag = visitPtValue;
        this.b.visitflag = visitPtValue;
    }

    public final Triangle2 find(Point2 p) {
        if (p.pointLineTest(this.a, this.b) >= 2) {
            return this.abnext.findnext(p, this);
        }
        if (this.halfplane) {
            return this;
        }
        if (p.pointLineTest(this.b, this.c) >= 2) {
            return this.bcnext.findnext(p, this);
        }
        if (p.pointLineTest(this.c, this.a) >= 2) {
            return this.canext.findnext(p, this);
        }
        return this;
    }

    private Triangle2 findnext(Point2 p, Triangle2 v) {
        Triangle2 t2;
        Triangle2 t1;
        Point2 p3;
        Point2 p2;
        Point2 p1;
        if (this.halfplane) {
            switch (p.pointLineTest(this.a, this.b)) {
                case 0: 
                case 1: {
                    return this;
                }
                case 3: {
                    return this.canext.findnext(p, this);
                }
                case 4: {
                    return this.bcnext.findnext(p, this);
                }
                case 2: {
                    System.out.println("Should not happen: point not in halfplane.");
                    return this.abnext.findnext(p, this);
                }
            }
        }
        if (this.abnext == v) {
            p1 = this.b;
            p2 = this.c;
            p3 = this.a;
            t1 = this.bcnext;
            t2 = this.canext;
        } else if (this.bcnext == v) {
            p1 = this.c;
            p2 = this.a;
            p3 = this.b;
            t1 = this.canext;
            t2 = this.abnext;
        } else {
            p1 = this.a;
            p2 = this.b;
            p3 = this.c;
            t1 = this.abnext;
            t2 = this.bcnext;
        }
        if (p.pointLineTest(p1, p2) >= 2) {
            return t1.findnext(p, this);
        }
        if (p.pointLineTest(p2, p3) >= 2) {
            return t2.findnext(p, this);
        }
        return this;
    }

    public final void switchNeighbors(Triangle2 Old, Triangle2 New) {
        if (this.abnext == Old) {
            this.abnext = New;
        } else if (this.bcnext == Old) {
            this.bcnext = New;
        } else if (this.canext == Old) {
            this.canext = New;
        } else {
            System.out.println(new StringBuilder("Error, switchNeighbors can't find Old.").append(Old).toString());
        }
    }

    public final Triangle2 neighborCCW(Point2 p) {
        if (this.a == p) {
            return this.canext;
        }
        if (this.b == p) {
            return this.abnext;
        }
        if (this.c == p) {
            return this.bcnext;
        }
        System.out.println(new StringBuilder("Error, neighbor can't find p: ").append(p).toString());
        return null;
    }

    public final Triangle2 neighborCW(Point2 p) {
        if (this.a == p) {
            return this.abnext;
        }
        if (this.b == p) {
            return this.bcnext;
        }
        if (this.c == p) {
            return this.canext;
        }
        System.out.println(new StringBuilder("Error, neighbor can't find p: ").append(p).toString());
        return null;
    }

    public final Circle2 circumcircle() {
        double u = ((this.a.x - this.b.x) * (this.a.x + this.b.x) + (this.a.y - this.b.y) * (this.a.y + this.b.y)) / 2.0;
        double v = ((this.b.x - this.c.x) * (this.b.x + this.c.x) + (this.b.y - this.c.y) * (this.b.y + this.c.y)) / 2.0;
        double den = (this.a.x - this.b.x) * (this.b.y - this.c.y) - (this.b.x - this.c.x) * (this.a.y - this.b.y);
        if (den == 0.0) {
            this.circum = new Circle2(this.a, Double.POSITIVE_INFINITY);
        } else {
            Point2 cen = new Point2((u * (this.b.y - this.c.y) - v * (this.a.y - this.b.y)) / den, (v * (this.a.x - this.b.x) - u * (this.b.x - this.c.x)) / den);
            this.circum = new Circle2(cen, cen.distance2(this.a));
        }
        return this.circum;
    }

    public final boolean circumcircle_contains(Point2 p) {
        return this.circum.r > this.circum.c.distance2(p);
    }

    protected final Vector reportRegions() {
        visitTrValue = !visitTrValue;
        visitPtValue = !visitPtValue;
        Vector v = new Vector();
        this.reportMoreRegions(v);
        return v;
    }

    private void reportMoreRegions(Vector v) {
        this.visitflag = visitTrValue;
        if (this.a.visitflag != visitPtValue) {
            this.a.visitflag = visitPtValue;
            v.add(this.a);
            v.add(this.reportRegion(this.a));
        }
        if (this.b.visitflag != visitPtValue) {
            this.b.visitflag = visitPtValue;
            v.add(this.b);
            v.add(this.reportRegion(this.b));
        }
        if (!this.halfplane && this.c.visitflag != visitPtValue) {
            this.c.visitflag = visitPtValue;
            v.add(this.c);
            v.add(this.reportRegion(this.c));
        }
        if (this.abnext.visitflag != visitTrValue) {
            this.abnext.reportMoreRegions(v);
        }
        if (this.bcnext.visitflag != visitTrValue) {
            this.bcnext.reportMoreRegions(v);
        }
        if (this.canext.visitflag != visitTrValue) {
            this.canext.reportMoreRegions(v);
        }
    }

    protected final Polygon2 reportRegion(Point2 p) {
        Polygon2 poly = new Polygon2();
        poly.setClosed();
        Polygon2 poly2 = null;
        Triangle2 t = this;
        if (this.halfplane && this.abnext.halfplane) {
            poly.setNonClosed();
            if (p == this.a && this.b == this.canext.a) {
                Line2 l = this.a.Bisector(this.b);
                poly.appendPoint(l.getPointA());
                poly.appendPoint(l.getPointB());
                return poly;
            }
            if (p == this.b && this.a == this.bcnext.b) {
                Line2 l = this.b.Bisector(this.a);
                poly.appendPoint(l.getPointA());
                poly.appendPoint(l.getPointB());
                return poly;
            }
            return poly;
        }
        do {
            if (!t.halfplane) {
                poly.appendPoint(t.circum.c);
                continue;
            }
            poly.setNonClosed();
            if (t.neighborCW((Point2)p).halfplane) {
                poly.appendPoint(t.dualEdge((Triangle2)t.neighborCCW((Point2)p)).b);
                continue;
            }
            poly2 = poly;
            poly = new Polygon2();
            poly.appendPoint(t.dualEdge((Triangle2)t.neighborCW((Point2)p)).b);
        } while ((t = t.neighborCW(p)) != this);
        if (poly2 != null) {
            poly.appendAllPoints(poly2);
        }
        return poly;
    }

    private Line2 dualEdge(Triangle2 t) {
        if (t.halfplane) {
            if (this.halfplane) {
                System.out.println("Warning, no dual edge between two halfplanes.");
                System.out.println(new StringBuilder().append(this).append(t).toString());
                return null;
            }
            return new Ray2(this.circum.c, new Point2(this.circum.c.x - (t.b.y - t.a.y), this.circum.c.y + (t.b.x - t.a.x)));
        }
        if (this.halfplane) {
            return new Ray2(t.circum.c, new Point2(t.circum.c.x - (this.b.y - this.a.y), t.circum.c.y + (this.b.x - this.a.x)));
        }
        return new Segment2(this.circum.c, t.circum.c);
    }

    public final String toString() {
        String res = new StringBuilder(" Tr[").append(this.a.toString()).append("|").append(this.b.toString()).toString();
        if (!this.halfplane) {
            res = new StringBuilder(String.valueOf(res)).append("|").append(this.c.toString()).toString();
        }
        res = new StringBuilder(String.valueOf(res)).append("]").toString();
        return res;
    }
}

