/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.query;

import de.grogra.reflect.Type;
import de.grogra.xl.query.BuiltInPattern;
import de.grogra.xl.query.BytecodeSerialization;
import de.grogra.xl.query.EdgeDirection;
import de.grogra.xl.query.Graph;
import de.grogra.xl.query.MatchConsumer;
import de.grogra.xl.query.Pattern;
import de.grogra.xl.query.Producer;
import de.grogra.xl.query.QueryState;
import de.grogra.xl.query.Utils;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.XBitSet;
import java.io.IOException;
import java.io.Serializable;

public final class EdgePattern
extends BuiltInPattern {
    public static final int ANY_EDGE = 0;
    public static final int SUCCESSOR_EDGE = 1;
    public static final int BRANCH_EDGE = 2;
    public static final int REFINEMENT_EDGE = 3;
    final Serializable edge;
    final int direction;
    final boolean constEdge;

    public EdgePattern(Type type, Type type2, Serializable serializable, int n) {
        Type[] typeArray;
        if (n == 3) {
            Type[] typeArray2 = new Type[4];
            typeArray2[0] = type;
            typeArray2[1] = type;
            typeArray2[2] = type2;
            typeArray = typeArray2;
            typeArray2[3] = type2;
        } else {
            Type[] typeArray3 = new Type[3];
            typeArray3[0] = type;
            typeArray3[1] = type;
            typeArray = typeArray3;
            typeArray3[2] = type2;
        }
        super(typeArray, n == 3 ? 4 : 3);
        if (n == 1) {
            throw new IllegalArgumentException();
        }
        this.edge = serializable;
        this.direction = n;
        this.constEdge = true;
    }

    public EdgePattern(Type type, Type type2, int n) {
        Type[] typeArray;
        if (n == 3) {
            Type[] typeArray2 = new Type[5];
            typeArray2[0] = type;
            typeArray2[1] = type;
            typeArray2[2] = type2;
            typeArray2[3] = type2;
            typeArray = typeArray2;
            typeArray2[4] = type2;
        } else {
            Type[] typeArray3 = new Type[4];
            typeArray3[0] = type;
            typeArray3[1] = type;
            typeArray3[2] = type2;
            typeArray = typeArray3;
            typeArray3[3] = type2;
        }
        super(typeArray, n == 3 ? 5 : 4);
        if (n == 1) {
            throw new IllegalArgumentException();
        }
        this.edge = null;
        this.direction = n;
        this.constEdge = false;
    }

    public void write(BytecodeSerialization bytecodeSerialization) throws IOException {
        bytecodeSerialization.beginMethod(Utils.getConstructor((Object)this, this.constEdge ? 4 : 3));
        bytecodeSerialization.visitType(this.getParameterType(0));
        bytecodeSerialization.visitType(this.getParameterType(2));
        if (this.constEdge) {
            bytecodeSerialization.visitObject(this.edge);
        }
        bytecodeSerialization.visitInt(this.direction);
        bytecodeSerialization.endMethod();
    }

    public Pattern.Matcher createMatcher(Graph graph, XBitSet xBitSet, IntList intList) {
        int n;
        int n2;
        boolean bl;
        if (xBitSet.get(0)) {
            bl = true;
        } else if (xBitSet.get(1)) {
            bl = false;
        } else {
            bl = true;
            intList.add(0);
        }
        if (!this.constEdge && !xBitSet.get(2)) {
            intList.add(2);
        }
        final int n3 = bl ? 0 : 1;
        int n4 = n2 = bl ? 1 : 0;
        final EdgeDirection.Undirected undirected = this.direction == 2 ? EdgeDirection.UNDIRECTED : (this.direction == 3 ? EdgeDirection.BOTH : (bl ? EdgeDirection.FORWARD : EdgeDirection.BACKWARD));
        final Type type = this.getParameterType(2);
        final int n5 = this.constEdge ? -1 : 2;
        int n6 = n = this.constEdge ? 2 : 3;
        if (!graph.canEnumerateEdges(undirected, this.constEdge, this.edge)) {
            return null;
        }
        return new Pattern.Matcher(2.0f){

            public void findMatches(QueryState queryState, MatchConsumer matchConsumer, int n4) {
                Object object = queryState.abound(n3);
                if (!queryState.model.isNode(object)) {
                    return;
                }
                queryState.graph.enumerateEdges(object, undirected, type, queryState, n2, n5, EdgePattern.this.edge, n, matchConsumer, n4);
            }

            public void visitMatch(QueryState queryState, Producer producer) {
                if (queryState.isNull(n)) {
                    return;
                }
                producer.producer$visitEdge(EdgePattern.this);
            }
        };
    }

    public int getPatternIndex() {
        return this.constEdge ? -1 : 2;
    }

    public int getMatchIndex() {
        return this.constEdge ? 2 : 3;
    }

    public Serializable getPattern() {
        return this.edge;
    }

    public boolean needsBothDirections() {
        return this.direction == 3;
    }

    public int getParameterKind(int n) {
        return 0;
    }

    public boolean isDeleting() {
        return true;
    }

    public String paramString() {
        return this.edge + "," + this.direction;
    }
}

