/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.debug3d;

import de.grogra.ray.RTCamera;
import de.grogra.ray.RTScene;
import de.grogra.ray.debug3d.Debug3dImpl;
import de.grogra.ray.debug3d.Debug3dVRMLImpl;
import de.grogra.ray.util.Ray;
import javax.vecmath.Tuple3f;

public class Debug3d {
    private static boolean m_isDebug3DEnabled = false;
    private static Debug3dImpl m_debugImpl = new Debug3dVRMLImpl();

    private static Debug3dImpl getImplementation() {
        return m_debugImpl;
    }

    public static void enableDebug3D(boolean bl) {
        m_isDebug3DEnabled = bl;
    }

    public static void logCamera(RTCamera rTCamera) {
        if (m_isDebug3DEnabled) {
            Debug3d.getImplementation().logCamera(rTCamera);
        }
    }

    public static void logScene(RTScene rTScene) {
        if (m_isDebug3DEnabled) {
            Debug3d.getImplementation().logScene(rTScene);
        }
    }

    public static void logInfiniteRay(Ray ray, float f) {
        if (m_isDebug3DEnabled) {
            Debug3d.getImplementation().logInfiniteRay(ray, f);
        }
    }

    public static void logFiniteRay(Ray ray, float f, float f2) {
        if (m_isDebug3DEnabled) {
            Debug3d.getImplementation().logFiniteRay(ray, f, f2);
        }
    }

    public static void logNormal(Tuple3f tuple3f, Tuple3f tuple3f2) {
        if (m_isDebug3DEnabled) {
            Debug3d.getImplementation().logNormal(tuple3f, tuple3f2);
        }
    }

    public static void logDirectLightRay(Ray ray) {
        if (m_isDebug3DEnabled) {
            Debug3d.getImplementation().logDirectLightRay(ray);
        }
    }

    public static void clear() {
        if (m_isDebug3DEnabled) {
            Debug3d.getImplementation().clear();
        }
    }

    public static void flush() {
        if (m_isDebug3DEnabled) {
            Debug3d.getImplementation().flush();
        }
    }
}

