/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.intersection;

import de.grogra.ray.intersection.Intersections;
import de.grogra.ray.util.Ray;
import java.util.ArrayList;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class OctreeCell {
    private final Vector3f m_minValues = new Vector3f();
    private final Vector3f m_maxValues = new Vector3f();
    private int m_depth = 0;
    private OctreeCell[] m_children = null;
    private OctreeCell[] m_neighbours;
    private final ArrayList m_linkedObjects = new ArrayList();
    private final Intersections.BoxIntersectionInput m_boxInput = new Intersections.BoxIntersectionInput();
    private final Intersections.BoxIntersectionLocalVariables m_boxLocalVariables = new Intersections.BoxIntersectionLocalVariables();
    public int testInt = 0;

    public OctreeCell(int n) {
        this.m_depth = n;
        this.m_neighbours = new OctreeCell[6];
        for (int i = 0; i < 6; ++i) {
            this.m_neighbours[i] = null;
        }
    }

    public OctreeCell(int n, Vector3f vector3f, Vector3f vector3f2) {
        this(n);
        this.setExtension(vector3f, vector3f2);
    }

    public int getDepth() {
        return this.m_depth;
    }

    public ArrayList getLinkedObjects() {
        return this.m_linkedObjects;
    }

    public boolean hasChildren() {
        return this.m_children != null;
    }

    public Vector3f getMinValues() {
        return this.m_minValues;
    }

    public Vector3f getMaxValues() {
        return this.m_maxValues;
    }

    public OctreeCell getNeighbourFront() {
        return this.m_neighbours[0];
    }

    public OctreeCell getNeighbourBack() {
        return this.m_neighbours[1];
    }

    public OctreeCell getNeighbourTop() {
        return this.m_neighbours[2];
    }

    public OctreeCell getNeighbourBottom() {
        return this.m_neighbours[3];
    }

    public OctreeCell getNeighbourLeft() {
        return this.m_neighbours[4];
    }

    public OctreeCell getNeighbourRight() {
        return this.m_neighbours[5];
    }

    public void setNeighbours(OctreeCell octreeCell, OctreeCell octreeCell2, OctreeCell octreeCell3, OctreeCell octreeCell4, OctreeCell octreeCell5, OctreeCell octreeCell6) {
        this.m_neighbours[0] = octreeCell;
        this.m_neighbours[1] = octreeCell2;
        this.m_neighbours[2] = octreeCell3;
        this.m_neighbours[3] = octreeCell4;
        this.m_neighbours[4] = octreeCell5;
        this.m_neighbours[5] = octreeCell6;
    }

    public OctreeCell getChild(int n) {
        if (!this.hasChildren() || n < 0 || n > 7) {
            return null;
        }
        return this.m_children[n];
    }

    public void setExtension(Vector3f vector3f, Vector3f vector3f2) {
        this.m_minValues.set((Tuple3f)vector3f);
        this.m_maxValues.set((Tuple3f)vector3f2);
        this.m_boxInput.minValues.set((Tuple3f)vector3f);
        this.m_boxInput.maxValues.set((Tuple3f)vector3f2);
    }

    public boolean hasIntersection(Ray ray) {
        this.m_boxInput.ray.setRay(ray);
        return Intersections.getBox_hasIntersection(this.m_boxInput, this.m_boxLocalVariables);
    }

    public void divideNode() {
        this.m_children = new OctreeCell[8];
        float f = this.m_maxValues.x - this.m_minValues.x;
        float f2 = this.m_maxValues.y - this.m_minValues.y;
        float f3 = this.m_maxValues.z - this.m_minValues.z;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        vector3f.x = this.m_minValues.x;
        vector3f.y = this.m_minValues.y;
        vector3f.z = this.m_minValues.z;
        vector3f2.x = this.m_minValues.x + f / 2.0f;
        vector3f2.y = this.m_minValues.y + f2 / 2.0f;
        vector3f2.z = this.m_minValues.z + f3 / 2.0f;
        this.m_children[0] = new OctreeCell(this.getDepth() + 1, vector3f, vector3f2);
        vector3f.x = this.m_minValues.x;
        vector3f.y = this.m_minValues.y;
        vector3f.z = this.m_minValues.z + f3 / 2.0f;
        vector3f2.x = this.m_minValues.x + f / 2.0f;
        vector3f2.y = this.m_minValues.y + f2 / 2.0f;
        vector3f2.z = this.m_minValues.z + f3;
        this.m_children[1] = new OctreeCell(this.getDepth() + 1, vector3f, vector3f2);
        vector3f.x = this.m_minValues.x;
        vector3f.y = this.m_minValues.y + f2 / 2.0f;
        vector3f.z = this.m_minValues.z;
        vector3f2.x = this.m_minValues.x + f / 2.0f;
        vector3f2.y = this.m_minValues.y + f2;
        vector3f2.z = this.m_minValues.z + f3 / 2.0f;
        this.m_children[2] = new OctreeCell(this.getDepth() + 1, vector3f, vector3f2);
        vector3f.x = this.m_minValues.x;
        vector3f.y = this.m_minValues.y + f2 / 2.0f;
        vector3f.z = this.m_minValues.z + f3 / 2.0f;
        vector3f2.x = this.m_minValues.x + f / 2.0f;
        vector3f2.y = this.m_minValues.y + f2;
        vector3f2.z = this.m_minValues.z + f3;
        this.m_children[3] = new OctreeCell(this.getDepth() + 1, vector3f, vector3f2);
        vector3f.x = this.m_minValues.x + f / 2.0f;
        vector3f.y = this.m_minValues.y;
        vector3f.z = this.m_minValues.z;
        vector3f2.x = this.m_minValues.x + f;
        vector3f2.y = this.m_minValues.y + f2 / 2.0f;
        vector3f2.z = this.m_minValues.z + f3 / 2.0f;
        this.m_children[4] = new OctreeCell(this.getDepth() + 1, vector3f, vector3f2);
        vector3f.x = this.m_minValues.x + f / 2.0f;
        vector3f.y = this.m_minValues.y;
        vector3f.z = this.m_minValues.z + f3 / 2.0f;
        vector3f2.x = this.m_minValues.x + f;
        vector3f2.y = this.m_minValues.y + f2 / 2.0f;
        vector3f2.z = this.m_minValues.z + f3;
        this.m_children[5] = new OctreeCell(this.getDepth() + 1, vector3f, vector3f2);
        vector3f.x = this.m_minValues.x + f / 2.0f;
        vector3f.y = this.m_minValues.y + f2 / 2.0f;
        vector3f.z = this.m_minValues.z;
        vector3f2.x = this.m_minValues.x + f;
        vector3f2.y = this.m_minValues.y + f2;
        vector3f2.z = this.m_minValues.z + f3 / 2.0f;
        this.m_children[6] = new OctreeCell(this.getDepth() + 1, vector3f, vector3f2);
        vector3f.x = this.m_minValues.x + f / 2.0f;
        vector3f.y = this.m_minValues.y + f2 / 2.0f;
        vector3f.z = this.m_minValues.z + f3 / 2.0f;
        vector3f2.x = this.m_minValues.x + f;
        vector3f2.y = this.m_minValues.y + f2;
        vector3f2.z = this.m_minValues.z + f3;
        this.m_children[7] = new OctreeCell(this.getDepth() + 1, vector3f, vector3f2);
    }
}

