/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.intersection;

import de.grogra.ray.RTObject;
import de.grogra.ray.RTScene;
import de.grogra.ray.Raytracer;
import de.grogra.ray.intersection.BoundingVolume;
import de.grogra.ray.intersection.CellGenerator;
import de.grogra.ray.intersection.EndlCellGenerator;
import de.grogra.ray.intersection.IntersectionDescription;
import de.grogra.ray.intersection.IntersectionProcessor;
import de.grogra.ray.intersection.OctreeCell;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayContext;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import javax.vecmath.Color4f;
import javax.vecmath.Vector3f;

public class OctreeIntersectionProcessor
implements IntersectionProcessor {
    private static final boolean TEST_GET_FIRST_INTERSECTION_DESCRIPTION = false;
    private static final boolean TEST_GET_FIRST_INTERSECTION_T = false;
    private static final int MAX_DIVISION_DEPTH = 5;
    private static final int MAX_LINKED_OBJECTS = 1;
    private RTScene m_sceneGraph = null;
    private RTObject[] m_objects = null;
    private OctreeCell m_root = new OctreeCell(0);
    private final ArrayList m_finiteObjects = new ArrayList();
    private final ArrayList m_infiniteObjects = new ArrayList();
    private float m_finiteCurT;
    private float m_finiteMinT;
    private int m_finiteMinIndex;
    private float m_infiniteCurT;
    private float m_infiniteMinT;
    private int m_infiniteMinIndex;
    private CellGenerator m_cellGenerator = new EndlCellGenerator();
    private final CellGenerator.NextCellOutput m_nextCellOutput = new CellGenerator.NextCellOutput();
    private boolean m_weiter;

    public void prepareProcessing(RTScene rTScene) {
        this.m_sceneGraph = rTScene;
        this.m_objects = Raytracer.getShadeables(rTScene);
        Vector3f vector3f = new Vector3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        Vector3f vector3f2 = new Vector3f(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        for (int i = 0; i < this.m_objects.length; ++i) {
            BoundingVolume boundingVolume = this.m_objects[i].getBoundingVolume();
            if (boundingVolume != null) {
                this.m_finiteObjects.add(this.m_objects[i]);
                if (boundingVolume.getMinX() < vector3f.x) {
                    vector3f.x = boundingVolume.getMinX();
                }
                if (boundingVolume.getMinY() < vector3f.y) {
                    vector3f.y = boundingVolume.getMinY();
                }
                if (boundingVolume.getMinZ() < vector3f.z) {
                    vector3f.z = boundingVolume.getMinZ();
                }
                if (boundingVolume.getMaxX() > vector3f2.x) {
                    vector3f2.x = boundingVolume.getMaxX();
                }
                if (boundingVolume.getMaxY() > vector3f2.y) {
                    vector3f2.y = boundingVolume.getMaxY();
                }
                if (!(boundingVolume.getMaxZ() > vector3f2.z)) continue;
                vector3f2.z = boundingVolume.getMaxZ();
                continue;
            }
            this.m_infiniteObjects.add(this.m_objects[i]);
        }
        float f = vector3f2.x - vector3f.x;
        if (vector3f2.y - vector3f.y > f) {
            f = vector3f2.y - vector3f.y;
        }
        if (vector3f2.z - vector3f.z > f) {
            f = vector3f2.z - vector3f.z;
        }
        Vector3f vector3f3 = new Vector3f();
        vector3f3.x = (vector3f2.x + vector3f.x) / 2.0f;
        vector3f3.y = (vector3f2.y + vector3f.y) / 2.0f;
        vector3f3.z = (vector3f2.z + vector3f.z) / 2.0f;
        vector3f.x = vector3f3.x - f / 2.0f;
        vector3f2.x = vector3f3.x + f / 2.0f;
        vector3f.y = vector3f3.y - f / 2.0f;
        vector3f2.y = vector3f3.y + f / 2.0f;
        vector3f.z = vector3f3.z - f / 2.0f;
        vector3f2.z = vector3f3.z + f / 2.0f;
        this.generateOctree(vector3f, vector3f2);
        this.m_cellGenerator.initialize(this.m_root, 5);
    }

    private void exportOctreeToVRML(File file) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("#VRML V2.0 utf8");
            bufferedWriter.newLine();
            bufferedWriter.write("");
            bufferedWriter.newLine();
            this.recursivelyExportOctree(this.m_root, bufferedWriter);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    private void recursivelyExportOctree(OctreeCell octreeCell, BufferedWriter bufferedWriter) {
        block4: {
            block3: {
                if (!octreeCell.hasChildren()) break block3;
                for (int i = 0; i < 8; ++i) {
                    this.recursivelyExportOctree(octreeCell.getChild(i), bufferedWriter);
                }
                break block4;
            }
            if (octreeCell.getLinkedObjects().size() <= 0) break block4;
            float f = (octreeCell.getMaxValues().x - octreeCell.getMinValues().x) / 2.0f;
            float f2 = (octreeCell.getMaxValues().y - octreeCell.getMinValues().y) / 2.0f;
            float f3 = (octreeCell.getMaxValues().z - octreeCell.getMinValues().z) / 2.0f;
            float f4 = octreeCell.getMinValues().x + f / 1.0f;
            float f5 = octreeCell.getMinValues().y + f2 / 1.0f;
            float f6 = octreeCell.getMinValues().z + f3 / 1.0f;
            try {
                bufferedWriter.write("Transform {");
                bufferedWriter.newLine();
                bufferedWriter.write("  children [");
                bufferedWriter.newLine();
                bufferedWriter.write("    Shape {");
                bufferedWriter.newLine();
                bufferedWriter.write("      appearance Appearance {");
                bufferedWriter.newLine();
                bufferedWriter.write("        material Material {");
                bufferedWriter.newLine();
                bufferedWriter.write("        }");
                bufferedWriter.newLine();
                bufferedWriter.write("      }");
                bufferedWriter.newLine();
                bufferedWriter.write("      geometry Box {}");
                bufferedWriter.newLine();
                bufferedWriter.write("    }");
                bufferedWriter.newLine();
                bufferedWriter.write("  ]");
                bufferedWriter.newLine();
                bufferedWriter.write("  scale " + f + " " + f2 + " " + f3);
                bufferedWriter.newLine();
                bufferedWriter.write("  translation " + f4 + " " + f5 + " " + f6);
                bufferedWriter.newLine();
                bufferedWriter.write("}");
                bufferedWriter.newLine();
                bufferedWriter.write("");
                bufferedWriter.newLine();
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    private void generateOctree(Vector3f vector3f, Vector3f vector3f2) {
        int n;
        this.m_root.setExtension(vector3f, vector3f2);
        this.m_root.getLinkedObjects().clear();
        for (n = 0; n < this.m_finiteObjects.size(); ++n) {
            this.m_root.getLinkedObjects().add(this.m_finiteObjects.get(n));
        }
        this.recursivelyDivideNode(this.m_root, 1);
        this.m_root.setNeighbours(null, null, null, null, null, null);
        if (this.m_root.hasChildren()) {
            for (n = 0; n < 8; ++n) {
                this.recursivelySetNeighbourhood(this.m_root, null, null, null, null, null, null, n);
            }
        }
    }

    private void recursivelyDivideNode(OctreeCell octreeCell, int n) {
        if (n <= 5 && octreeCell.getLinkedObjects().size() > 1) {
            octreeCell.divideNode();
            for (int i = 0; i < 8; ++i) {
                OctreeCell octreeCell2 = octreeCell.getChild(i);
                octreeCell2.getLinkedObjects().clear();
                for (int j = 0; j < octreeCell.getLinkedObjects().size(); ++j) {
                    RTObject rTObject = (RTObject)octreeCell.getLinkedObjects().get(j);
                    if (!rTObject.getBoundingVolume().isInsideBox(octreeCell2.getMinValues(), octreeCell2.getMaxValues())) continue;
                    octreeCell2.getLinkedObjects().add(rTObject);
                    if (!rTObject.getClass().getName().equals("de.grogra.imp3d.ray.RTPlane")) continue;
                    octreeCell2.testInt = 1;
                }
                this.recursivelyDivideNode(octreeCell2, n + 1);
            }
            octreeCell.getLinkedObjects().clear();
        }
    }

    private void recursivelySetNeighbourhood(OctreeCell octreeCell, OctreeCell octreeCell2, OctreeCell octreeCell3, OctreeCell octreeCell4, OctreeCell octreeCell5, OctreeCell octreeCell6, OctreeCell octreeCell7, int n) {
        OctreeCell octreeCell8 = octreeCell.getChild(n);
        switch (n) {
            case 0: {
                if (octreeCell2 != null && octreeCell2.hasChildren()) {
                    octreeCell2 = octreeCell2.getChild(2);
                }
                if (octreeCell5 != null && octreeCell5.hasChildren()) {
                    octreeCell5 = octreeCell5.getChild(1);
                }
                if (octreeCell6 != null && octreeCell6.hasChildren()) {
                    octreeCell6 = octreeCell6.getChild(4);
                }
                octreeCell8.setNeighbours(octreeCell2, octreeCell.getChild(2), octreeCell.getChild(1), octreeCell5, octreeCell6, octreeCell.getChild(4));
                break;
            }
            case 1: {
                if (octreeCell2 != null && octreeCell2.hasChildren()) {
                    octreeCell2 = octreeCell2.getChild(3);
                }
                if (octreeCell4 != null && octreeCell4.hasChildren()) {
                    octreeCell4 = octreeCell4.getChild(0);
                }
                if (octreeCell6 != null && octreeCell6.hasChildren()) {
                    octreeCell6 = octreeCell6.getChild(5);
                }
                octreeCell8.setNeighbours(octreeCell2, octreeCell.getChild(3), octreeCell4, octreeCell.getChild(0), octreeCell6, octreeCell.getChild(5));
                break;
            }
            case 2: {
                if (octreeCell3 != null && octreeCell3.hasChildren()) {
                    octreeCell3 = octreeCell3.getChild(0);
                }
                if (octreeCell5 != null && octreeCell5.hasChildren()) {
                    octreeCell5 = octreeCell5.getChild(3);
                }
                if (octreeCell6 != null && octreeCell6.hasChildren()) {
                    octreeCell6 = octreeCell6.getChild(6);
                }
                octreeCell8.setNeighbours(octreeCell.getChild(0), octreeCell3, octreeCell.getChild(3), octreeCell5, octreeCell6, octreeCell.getChild(6));
                break;
            }
            case 3: {
                if (octreeCell4 != null && octreeCell4.hasChildren()) {
                    octreeCell4 = octreeCell4.getChild(2);
                }
                if (octreeCell3 != null && octreeCell3.hasChildren()) {
                    octreeCell3 = octreeCell3.getChild(1);
                }
                if (octreeCell6 != null && octreeCell6.hasChildren()) {
                    octreeCell6 = octreeCell6.getChild(7);
                }
                octreeCell8.setNeighbours(octreeCell.getChild(1), octreeCell3, octreeCell4, octreeCell.getChild(2), octreeCell6, octreeCell.getChild(7));
                break;
            }
            case 4: {
                if (octreeCell2 != null && octreeCell2.hasChildren()) {
                    octreeCell2 = octreeCell2.getChild(6);
                }
                if (octreeCell5 != null && octreeCell5.hasChildren()) {
                    octreeCell5 = octreeCell5.getChild(5);
                }
                if (octreeCell7 != null && octreeCell7.hasChildren()) {
                    octreeCell7 = octreeCell7.getChild(0);
                }
                octreeCell8.setNeighbours(octreeCell2, octreeCell.getChild(6), octreeCell.getChild(5), octreeCell5, octreeCell.getChild(0), octreeCell7);
                break;
            }
            case 5: {
                if (octreeCell2 != null && octreeCell2.hasChildren()) {
                    octreeCell2 = octreeCell2.getChild(7);
                }
                if (octreeCell4 != null && octreeCell4.hasChildren()) {
                    octreeCell4 = octreeCell4.getChild(4);
                }
                if (octreeCell7 != null && octreeCell7.hasChildren()) {
                    octreeCell7 = octreeCell7.getChild(1);
                }
                octreeCell8.setNeighbours(octreeCell2, octreeCell.getChild(7), octreeCell4, octreeCell.getChild(4), octreeCell.getChild(1), octreeCell7);
                break;
            }
            case 6: {
                if (octreeCell3 != null && octreeCell3.hasChildren()) {
                    octreeCell3 = octreeCell3.getChild(4);
                }
                if (octreeCell5 != null && octreeCell5.hasChildren()) {
                    octreeCell5 = octreeCell5.getChild(7);
                }
                if (octreeCell7 != null && octreeCell7.hasChildren()) {
                    octreeCell7 = octreeCell7.getChild(2);
                }
                octreeCell8.setNeighbours(octreeCell.getChild(4), octreeCell3, octreeCell.getChild(7), octreeCell5, octreeCell.getChild(2), octreeCell7);
                break;
            }
            case 7: {
                if (octreeCell3 != null && octreeCell3.hasChildren()) {
                    octreeCell3 = octreeCell3.getChild(5);
                }
                if (octreeCell4 != null && octreeCell4.hasChildren()) {
                    octreeCell4 = octreeCell4.getChild(6);
                }
                if (octreeCell7 != null && octreeCell7.hasChildren()) {
                    octreeCell7 = octreeCell7.getChild(3);
                }
                octreeCell8.setNeighbours(octreeCell.getChild(5), octreeCell3, octreeCell4, octreeCell.getChild(6), octreeCell.getChild(3), octreeCell7);
                break;
            }
            default: {
                System.err.println("OctreeIntersectionProcessor: wrong child index");
                return;
            }
        }
        if (octreeCell8.hasChildren()) {
            for (int i = 0; i < 8; ++i) {
                this.recursivelySetNeighbourhood(octreeCell8, octreeCell8.getNeighbourFront(), octreeCell8.getNeighbourBack(), octreeCell8.getNeighbourTop(), octreeCell8.getNeighbourBottom(), octreeCell8.getNeighbourLeft(), octreeCell8.getNeighbourRight(), i);
            }
        }
    }

    public boolean getFirstIntersectionDescription(Ray ray, RayContext rayContext, IntersectionDescription intersectionDescription) {
        boolean bl = false;
        if (this.m_infiniteObjects.size() == 0 && this.m_finiteObjects.size() == 0) {
            return false;
        }
        bl = this.m_infiniteObjects.size() == 0 ? this.getFirstIntersectionDescription_noInfiniteObjects(ray, rayContext, intersectionDescription) : this.getFirstIntersectionDescription_infiniteObjects(ray, rayContext, intersectionDescription);
        return bl;
    }

    public boolean getFirstIntersectionDescription_noInfiniteObjects(Ray ray, RayContext rayContext, IntersectionDescription intersectionDescription) {
        int n;
        this.m_cellGenerator.setRay(ray);
        this.m_cellGenerator.nextCell(this.m_nextCellOutput);
        while (this.m_nextCellOutput.nextCell != null) {
            this.m_finiteMinT = Float.MAX_VALUE;
            this.m_finiteMinIndex = -1;
            for (n = 0; n < this.m_nextCellOutput.nextCell.getLinkedObjects().size(); ++n) {
                if (this.m_nextCellOutput.nextCell.getLinkedObjects().get(n) == rayContext.excludeObject) continue;
                this.m_finiteCurT = ((RTObject)this.m_nextCellOutput.nextCell.getLinkedObjects().get(n)).getDistance(ray, rayContext);
                if (this.m_finiteCurT != this.m_finiteCurT || (double)this.m_finiteCurT > this.m_nextCellOutput.leavingT || !(this.m_finiteCurT <= this.m_finiteMinT)) continue;
                this.m_finiteMinIndex = n;
                this.m_finiteMinT = this.m_finiteCurT;
            }
            if (this.m_finiteMinIndex > -1) {
                ((RTObject)this.m_nextCellOutput.nextCell.getLinkedObjects().get(this.m_finiteMinIndex)).getIntersectionDescription(intersectionDescription);
                return true;
            }
            this.m_cellGenerator.nextCell(this.m_nextCellOutput);
        }
        if (this.m_nextCellOutput.errorOccurred) {
            System.out.println("error in octree intersection processor - using defaut intersection");
            this.m_finiteMinT = Float.MAX_VALUE;
            this.m_finiteMinIndex = -1;
            for (n = 0; n < this.m_objects.length; ++n) {
                if (this.m_objects[n] == rayContext.excludeObject) continue;
                this.m_finiteCurT = this.m_objects[n].getDistance(ray, rayContext);
                if (!(this.m_finiteCurT <= this.m_finiteMinT)) continue;
                this.m_finiteMinIndex = n;
                this.m_finiteMinT = this.m_finiteCurT;
            }
            if (this.m_finiteMinIndex > -1) {
                this.m_objects[this.m_finiteMinIndex].getIntersectionDescription(intersectionDescription);
                return true;
            }
        }
        return false;
    }

    public boolean getFirstIntersectionDescription_infiniteObjects(Ray ray, RayContext rayContext, IntersectionDescription intersectionDescription) {
        int n;
        this.m_infiniteMinT = Float.MAX_VALUE;
        this.m_infiniteMinIndex = -1;
        for (n = 0; n < this.m_infiniteObjects.size(); ++n) {
            if (this.m_infiniteObjects.get(n) == rayContext.excludeObject) continue;
            this.m_infiniteCurT = ((RTObject)this.m_infiniteObjects.get(n)).getDistance(ray, rayContext);
            if (!(this.m_infiniteCurT <= this.m_infiniteMinT)) continue;
            this.m_infiniteMinIndex = n;
            this.m_infiniteMinT = this.m_infiniteCurT;
        }
        this.m_cellGenerator.setRay(ray);
        this.m_cellGenerator.nextCell(this.m_nextCellOutput);
        while (this.m_nextCellOutput.nextCell != null) {
            this.m_finiteMinT = Float.MAX_VALUE;
            this.m_finiteMinIndex = -1;
            for (n = 0; n < this.m_nextCellOutput.nextCell.getLinkedObjects().size(); ++n) {
                if (this.m_nextCellOutput.nextCell.getLinkedObjects().get(n) == rayContext.excludeObject) continue;
                this.m_finiteCurT = ((RTObject)this.m_nextCellOutput.nextCell.getLinkedObjects().get(n)).getDistance(ray, rayContext);
                if (this.m_finiteCurT != this.m_finiteCurT || (double)this.m_finiteCurT > this.m_nextCellOutput.leavingT || !(this.m_finiteCurT <= this.m_finiteMinT)) continue;
                this.m_finiteMinIndex = n;
                this.m_finiteMinT = this.m_finiteCurT;
            }
            if (this.m_infiniteMinIndex > -1 && (double)this.m_infiniteMinT < this.m_nextCellOutput.leavingT) {
                if (this.m_finiteMinIndex > -1 && this.m_finiteMinT < this.m_infiniteMinT) {
                    ((RTObject)this.m_nextCellOutput.nextCell.getLinkedObjects().get(this.m_finiteMinIndex)).getIntersectionDescription(intersectionDescription);
                    return true;
                }
                ((RTObject)this.m_infiniteObjects.get(this.m_infiniteMinIndex)).getIntersectionDescription(intersectionDescription);
                return true;
            }
            if (this.m_finiteMinIndex > -1) {
                ((RTObject)this.m_nextCellOutput.nextCell.getLinkedObjects().get(this.m_finiteMinIndex)).getIntersectionDescription(intersectionDescription);
                return true;
            }
            this.m_cellGenerator.nextCell(this.m_nextCellOutput);
        }
        if (this.m_nextCellOutput.errorOccurred) {
            System.err.println("### error has occurred ###");
            this.m_finiteMinT = Float.MAX_VALUE;
            this.m_finiteMinIndex = -1;
            for (n = 0; n < this.m_objects.length; ++n) {
                if (this.m_objects[n] == rayContext.excludeObject) continue;
                this.m_finiteCurT = this.m_objects[n].getDistance(ray, rayContext);
                if (!(this.m_finiteCurT <= this.m_finiteMinT)) continue;
                this.m_finiteMinIndex = n;
                this.m_finiteMinT = this.m_finiteCurT;
            }
            if (this.m_finiteMinIndex > -1) {
                this.m_objects[this.m_finiteMinIndex].getIntersectionDescription(intersectionDescription);
                return true;
            }
        } else if (this.m_infiniteMinIndex > -1) {
            ((RTObject)this.m_infiniteObjects.get(this.m_infiniteMinIndex)).getIntersectionDescription(intersectionDescription);
            return true;
        }
        return false;
    }

    public float getFirstIntersectionT(Ray ray, RayContext rayContext) {
        float f = 0.0f;
        f = this.m_infiniteObjects.size() == 0 ? this.getFirstIntersectionT_noInfiniteObjects(ray, rayContext) : this.getFirstIntersectionT_infiniteObjects(ray, rayContext);
        return f;
    }

    public float getFirstIntersectionT_noInfiniteObjects(Ray ray, RayContext rayContext) {
        int n;
        this.m_cellGenerator.setRay(ray);
        this.m_cellGenerator.nextCell(this.m_nextCellOutput);
        while (this.m_nextCellOutput.nextCell != null) {
            this.m_finiteMinT = Float.MAX_VALUE;
            for (n = 0; n < this.m_nextCellOutput.nextCell.getLinkedObjects().size(); ++n) {
                if (this.m_nextCellOutput.nextCell.getLinkedObjects().get(n) == rayContext.excludeObject) continue;
                this.m_finiteCurT = ((RTObject)this.m_nextCellOutput.nextCell.getLinkedObjects().get(n)).getDistance(ray, rayContext);
                if (this.m_finiteCurT != this.m_finiteCurT || (double)this.m_finiteCurT > this.m_nextCellOutput.leavingT || !(this.m_finiteCurT <= this.m_finiteMinT)) continue;
                this.m_finiteMinIndex = n;
                this.m_finiteMinT = this.m_finiteCurT;
            }
            if (this.m_finiteMinT < Float.MAX_VALUE) {
                return this.m_finiteMinT;
            }
            this.m_cellGenerator.nextCell(this.m_nextCellOutput);
        }
        if (this.m_nextCellOutput.errorOccurred) {
            System.out.println("error in octree intersection processor - using defaut intersection");
            this.m_finiteMinT = Float.MAX_VALUE;
            for (n = 0; n < this.m_objects.length; ++n) {
                if (this.m_objects[n] == rayContext.excludeObject) continue;
                this.m_finiteCurT = this.m_objects[n].getDistance(ray, rayContext);
                if (!(this.m_finiteCurT <= this.m_finiteMinT)) continue;
                this.m_finiteMinT = this.m_finiteCurT;
            }
            if (this.m_finiteMinT < Float.MAX_VALUE) {
                return this.m_finiteMinT;
            }
            return Float.NaN;
        }
        return Float.NaN;
    }

    public float getFirstIntersectionT_infiniteObjects(Ray ray, RayContext rayContext) {
        int n;
        this.m_infiniteMinT = Float.MAX_VALUE;
        for (n = 0; n < this.m_infiniteObjects.size(); ++n) {
            if (this.m_infiniteObjects.get(n) == rayContext.excludeObject) continue;
            this.m_infiniteCurT = ((RTObject)this.m_infiniteObjects.get(n)).getDistance(ray, rayContext);
            if (!(this.m_infiniteCurT <= this.m_infiniteMinT)) continue;
            this.m_infiniteMinT = this.m_infiniteCurT;
        }
        this.m_cellGenerator.setRay(ray);
        this.m_cellGenerator.nextCell(this.m_nextCellOutput);
        while (this.m_nextCellOutput.nextCell != null) {
            this.m_finiteMinT = Float.MAX_VALUE;
            for (n = 0; n < this.m_nextCellOutput.nextCell.getLinkedObjects().size(); ++n) {
                if (this.m_nextCellOutput.nextCell.getLinkedObjects().get(n) == rayContext.excludeObject) continue;
                this.m_finiteCurT = ((RTObject)this.m_nextCellOutput.nextCell.getLinkedObjects().get(n)).getDistance(ray, rayContext);
                if (this.m_finiteCurT != this.m_finiteCurT || (double)this.m_finiteCurT > this.m_nextCellOutput.leavingT || !(this.m_finiteCurT <= this.m_finiteMinT)) continue;
                this.m_finiteMinT = this.m_finiteCurT;
            }
            if (this.m_finiteMinT < Float.MAX_VALUE) {
                if (this.m_finiteMinT < this.m_infiniteMinT) {
                    return this.m_finiteMinT;
                }
                if (this.m_infiniteMinT < this.m_finiteMinT) {
                    return this.m_infiniteMinT;
                }
            }
            this.m_cellGenerator.nextCell(this.m_nextCellOutput);
        }
        if (this.m_nextCellOutput.errorOccurred) {
            System.out.println("error in octree intersection processor - using defaut intersection");
            this.m_finiteMinT = Float.MAX_VALUE;
            for (n = 0; n < this.m_objects.length; ++n) {
                if (this.m_objects[n] == rayContext.excludeObject) continue;
                this.m_finiteCurT = this.m_objects[n].getDistance(ray, rayContext);
                if (!(this.m_finiteCurT <= this.m_finiteMinT)) continue;
                this.m_finiteMinT = this.m_finiteCurT;
            }
            if (this.m_finiteMinT < Float.MAX_VALUE) {
                return this.m_finiteMinT;
            }
            return Float.NaN;
        }
        if (this.m_infiniteMinT < Float.MAX_VALUE) {
            return this.m_infiniteMinT;
        }
        return Float.NaN;
    }

    public void getAdditionColor(Ray ray, Color4f color4f) {
        color4f.set(0.0f, 0.0f, 0.0f, 0.0f);
    }

    private void recursivelyGetAdditionalColor(OctreeCell octreeCell, Ray ray, Color4f color4f) {
        if (!this.m_weiter) {
            return;
        }
        if (octreeCell.hasChildren()) {
            for (int i = 0; i < 8; ++i) {
                this.recursivelyGetAdditionalColor(octreeCell.getChild(i), ray, color4f);
            }
        } else if (octreeCell.testInt > 0 && octreeCell.hasIntersection(ray)) {
            color4f.w = 0.5f;
            this.m_weiter = false;
        }
    }

    public void cleanupProcessing() {
    }

    private void recursivelyExportFirstCells(OctreeCell octreeCell, BufferedWriter bufferedWriter) {
        block4: {
            block3: {
                if (!octreeCell.hasChildren()) break block3;
                for (int i = 0; i < 8; ++i) {
                    this.recursivelyExportFirstCells(octreeCell.getChild(i), bufferedWriter);
                }
                break block4;
            }
            if (octreeCell.testInt <= 0) break block4;
            float f = (octreeCell.getMaxValues().x - octreeCell.getMinValues().x) / 2.0f;
            float f2 = (octreeCell.getMaxValues().y - octreeCell.getMinValues().y) / 2.0f;
            float f3 = (octreeCell.getMaxValues().z - octreeCell.getMinValues().z) / 2.0f;
            float f4 = octreeCell.getMinValues().x + f / 1.0f;
            float f5 = octreeCell.getMinValues().y + f2 / 1.0f;
            float f6 = octreeCell.getMinValues().z + f3 / 1.0f;
            try {
                bufferedWriter.write("Transform {");
                bufferedWriter.newLine();
                bufferedWriter.write("  children [");
                bufferedWriter.newLine();
                bufferedWriter.write("    Shape {");
                bufferedWriter.newLine();
                bufferedWriter.write("      appearance Appearance {");
                bufferedWriter.newLine();
                bufferedWriter.write("        material Material {}");
                bufferedWriter.newLine();
                bufferedWriter.write("      }");
                bufferedWriter.newLine();
                bufferedWriter.write("      geometry Box {}");
                bufferedWriter.newLine();
                bufferedWriter.write("    }");
                bufferedWriter.newLine();
                bufferedWriter.write("  ]");
                bufferedWriter.newLine();
                bufferedWriter.write("  scale " + f + " " + f2 + " " + f3);
                bufferedWriter.newLine();
                bufferedWriter.write("  translation " + f4 + " " + f5 + " " + f6);
                bufferedWriter.newLine();
                bufferedWriter.write("}");
                bufferedWriter.newLine();
                bufferedWriter.write("");
                bufferedWriter.newLine();
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }
}

