/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.physics;

import de.grogra.ray.physics.Collector;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3d;
import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;

public class Collector3d
extends Spectrum3d
implements Collector,
Serializable {
    protected long rayCount;
    protected boolean asCollector = false;
    protected double squareSumDirectionX = 0.0;
    protected double squareSumDirectionY = 0.0;
    protected double squareSumDirectionZ = 0.0;
    protected double sumDirectionX = 0.0;
    protected double sumDirectionY = 0.0;
    protected double sumDirectionZ = 0.0;
    protected double squareSumSpectrumX = 0.0;
    protected double squareSumSpectrumY = 0.0;
    protected double squareSumSpectrumZ = 0.0;
    protected double sumSpectrumX = 0.0;
    protected double sumSpectrumY = 0.0;
    protected double sumSpectrumZ = 0.0;

    public Collector3d() {
    }

    public Collector3d(double d, double d2, double d3) {
        super(d, d2, d3);
        this.add((Spectrum)this);
    }

    public Collector3d(Spectrum spectrum) {
        this.add(spectrum);
    }

    public Collector3d newInstance() {
        return new Collector3d();
    }

    public void setAsCollector() {
        this.asCollector = true;
    }

    public boolean isCollector() {
        return this.asCollector;
    }

    public void add(Spectrum spectrum) {
        if (!(spectrum instanceof Collector) || !((Collector)spectrum).isCollector()) {
            super.add(spectrum);
        } else {
            this.add((Collector)spectrum);
        }
    }

    public void addToStatistic(Tuple3d tuple3d, Spectrum spectrum, double d, boolean bl) {
        this.addToStatistic(tuple3d, (Spectrum3d)spectrum, d, bl);
    }

    public void addToStatistic(Tuple3d tuple3d, Spectrum3d spectrum3d, double d, boolean bl) {
        ++this.rayCount;
        double d2 = spectrum3d.integrate() * d;
        Collector3d.normalize(tuple3d);
        tuple3d.negate();
        this.sumDirectionX += d2 * tuple3d.x;
        this.sumDirectionY += d2 * tuple3d.y;
        this.sumDirectionZ += d2 * tuple3d.z;
        this.squareSumDirectionX += tuple3d.x * tuple3d.x;
        this.squareSumDirectionY += tuple3d.y * tuple3d.y;
        this.squareSumDirectionZ += tuple3d.z * tuple3d.z;
        this.sumSpectrumX += spectrum3d.x;
        this.sumSpectrumY += spectrum3d.y;
        this.sumSpectrumZ += spectrum3d.z;
        this.squareSumSpectrumX += spectrum3d.x * spectrum3d.x;
        this.squareSumSpectrumY += spectrum3d.y * spectrum3d.y;
        this.squareSumSpectrumZ += spectrum3d.z * spectrum3d.z;
    }

    public void getSpectrumVariance(Spectrum spectrum) {
        spectrum.set((Tuple3d)new Vector3d((this.squareSumSpectrumX - this.sumSpectrumX) / (double)this.rayCount, (this.squareSumSpectrumY - this.sumSpectrumY) / (double)this.rayCount, (this.squareSumSpectrumZ - this.sumSpectrumZ) / (double)this.rayCount));
    }

    public void getDirectionVariance(Tuple3d tuple3d) {
        tuple3d.x = (this.squareSumDirectionX - this.sumDirectionX * this.sumDirectionX) / (double)this.rayCount;
        tuple3d.y = (this.squareSumDirectionY - this.sumDirectionY * this.sumDirectionY) / (double)this.rayCount;
        tuple3d.z = (this.squareSumDirectionZ - this.sumDirectionZ * this.sumDirectionZ) / (double)this.rayCount;
    }

    public void getDirectionVariance(Tuple3f tuple3f) {
        tuple3f.x = (float)((this.squareSumDirectionX - this.sumDirectionX * this.sumDirectionX) / (double)this.rayCount);
        tuple3f.y = (float)((this.squareSumDirectionY - this.sumDirectionY * this.sumDirectionY) / (double)this.rayCount);
        tuple3f.z = (float)((this.squareSumDirectionZ - this.sumDirectionZ * this.sumDirectionZ) / (double)this.rayCount);
    }

    public void getDirectionArithmeticMean(Tuple3d tuple3d) {
        tuple3d.x = this.sumDirectionX / (double)this.rayCount;
        tuple3d.y = this.sumDirectionY / (double)this.rayCount;
        tuple3d.z = this.sumDirectionZ / (double)this.rayCount;
    }

    public void getDirectionArithmeticMean(Tuple3f tuple3f) {
        tuple3f.x = (float)(this.sumDirectionX / (double)this.rayCount);
        tuple3f.y = (float)(this.sumDirectionY / (double)this.rayCount);
        tuple3f.z = (float)(this.sumDirectionZ / (double)this.rayCount);
    }

    public void getSpectrumArithmeticMean(Spectrum spectrum) {
        spectrum.set((Tuple3d)new Vector3d(this.sumSpectrumX / (double)this.rayCount, this.sumSpectrumY / (double)this.rayCount, this.sumSpectrumZ / (double)this.rayCount));
    }

    public long getRayCount() {
        return this.rayCount;
    }

    public void setZero() {
        this.rayCount = 0L;
        super.setZero();
        this.squareSumDirectionX = 0.0;
        this.squareSumDirectionY = 0.0;
        this.squareSumDirectionZ = 0.0;
        this.sumDirectionX = 0.0;
        this.sumDirectionY = 0.0;
        this.sumDirectionZ = 0.0;
        this.squareSumSpectrumX = 0.0;
        this.squareSumSpectrumY = 0.0;
        this.squareSumSpectrumZ = 0.0;
        this.sumSpectrumX = 0.0;
        this.sumSpectrumY = 0.0;
        this.sumSpectrumZ = 0.0;
    }

    public static void normalize(Tuple3d tuple3d) {
        double d = Math.sqrt(tuple3d.x * tuple3d.x + tuple3d.y * tuple3d.y + tuple3d.z * tuple3d.z);
        tuple3d.scale(1.0 / d);
    }

    public static void normalize(Tuple3f tuple3f) {
        float f = (float)Math.sqrt(tuple3f.x * tuple3f.x + tuple3f.y * tuple3f.y + tuple3f.z * tuple3f.z);
        tuple3f.scale(1.0f / f);
    }

    public void add(Collector collector) {
        super.add(collector);
        this.rayCount += collector.getRayCount();
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        Point3d point3d4 = new Point3d();
        collector.getCollectedValues((Tuple3d)point3d, (Tuple3d)point3d2, (Tuple3d)point3d3, (Tuple3d)point3d4);
        this.sumDirectionX += point3d.x;
        this.sumDirectionY += point3d.y;
        this.sumDirectionZ += point3d.z;
        this.squareSumDirectionX += point3d2.x;
        this.squareSumDirectionY += point3d2.y;
        this.squareSumDirectionZ += point3d2.z;
        this.sumSpectrumX += point3d3.x;
        this.sumSpectrumY += point3d3.y;
        this.sumSpectrumZ += point3d3.z;
        this.squareSumSpectrumX += point3d4.x;
        this.squareSumSpectrumY += point3d4.y;
        this.squareSumSpectrumZ += point3d4.z;
    }

    public void getCollectedValues(Tuple3d tuple3d, Tuple3d tuple3d2, Tuple3d tuple3d3, Tuple3d tuple3d4) {
        tuple3d.x = this.sumDirectionX;
        tuple3d.y = this.sumDirectionY;
        tuple3d.z = this.sumDirectionZ;
        tuple3d2.x = this.squareSumDirectionX;
        tuple3d2.y = this.squareSumDirectionY;
        tuple3d2.z = this.squareSumDirectionZ;
        tuple3d3.x = this.sumSpectrumX;
        tuple3d3.y = this.sumSpectrumY;
        tuple3d3.z = this.sumSpectrumZ;
        tuple3d4.x = this.squareSumSpectrumX;
        tuple3d4.y = this.squareSumSpectrumY;
        tuple3d4.z = this.squareSumSpectrumZ;
    }

    public Collector3d clone() {
        Collector3d collector3d = new Collector3d();
        if (!this.asCollector) {
            collector3d.add((Spectrum)this);
        } else {
            collector3d.x = this.x;
            collector3d.y = this.y;
            collector3d.z = this.z;
            collector3d.rayCount = this.rayCount;
            collector3d.squareSumDirectionX = this.squareSumDirectionX;
            collector3d.squareSumDirectionY = this.squareSumDirectionY;
            collector3d.squareSumDirectionZ = this.squareSumDirectionZ;
            collector3d.sumDirectionX = this.sumDirectionX;
            collector3d.sumDirectionY = this.sumDirectionY;
            collector3d.sumDirectionZ = this.sumDirectionZ;
            collector3d.squareSumSpectrumX = this.squareSumSpectrumX;
            collector3d.squareSumSpectrumY = this.squareSumSpectrumY;
            collector3d.squareSumSpectrumZ = this.squareSumSpectrumZ;
            collector3d.sumSpectrumX = this.sumSpectrumX;
            collector3d.sumSpectrumY = this.sumSpectrumY;
            collector3d.sumSpectrumZ = this.sumSpectrumZ;
        }
        return collector3d;
    }
}

