/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.physics;

import de.grogra.ray.physics.Spectrum;
import de.grogra.ray2.Scene;
import de.grogra.vecmath.geom.BoundingBox;
import de.grogra.vecmath.geom.Intersection;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point2d;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Environment {
    public static final int STANDARD_RAY_TRACER = 0;
    public static final int PATH_TRACER = 1;
    public static final int RADIATION_MODEL = 2;
    public final int type;
    public final BoundingBox bounds;
    public final Vector3d boundsCenter;
    public final double boundsRadius;
    public Matrix4f localToGlobal = new Matrix4f();
    public Matrix4f globalToLocal = new Matrix4f();
    public final Point3f localPoint = new Point3f();
    public final Point3f point = new Point3f();
    public final Vector3f normal = new Vector3f();
    public final Point2f uv = new Point2f();
    public final Vector3f dpdu = new Vector3f();
    public final Vector3f dpdv = new Vector3f();
    public boolean solid = true;
    public float iorRatio = 1.0f;
    public final Matrix3f userMatrix = new Matrix3f();
    public final Matrix3f userMatrix2 = new Matrix3f();
    public final Matrix3f userMatrix3 = new Matrix3f();
    public final Vector3f userVector = new Vector3f();
    public final Vector3f userVector2 = new Vector3f();
    public final Vector3f userVector3 = new Vector3f();
    public final Point3d tmpPoint0 = new Point3d();
    public final Point3d tmpPoint1 = new Point3d();
    public final Vector3d tmpVector0 = new Vector3d();
    public final Vector3d tmpVector1 = new Vector3d();
    public final Point2d tmpPoint2d0 = new Point2d();
    public final Matrix3d tmpMatrix30 = new Matrix3d();
    public final Spectrum tmpSpectrum0;
    public final Spectrum tmpSpectrum1;
    public Object userObjectOwner;
    public Object userObject;

    public Environment() {
        this.bounds = null;
        this.tmpSpectrum0 = null;
        this.tmpSpectrum1 = null;
        this.type = 0;
        this.boundsRadius = 0.0;
        this.boundsCenter = null;
    }

    public Environment(BoundingBox boundingBox, Spectrum spectrum, int n) {
        this.bounds = boundingBox;
        this.type = n;
        if (boundingBox == null) {
            this.boundsCenter = null;
            this.boundsRadius = 0.0;
        } else {
            this.boundsCenter = new Vector3d();
            this.boundsCenter.sub((Tuple3d)boundingBox.max, (Tuple3d)boundingBox.min);
            this.boundsRadius = 0.5 * this.boundsCenter.length();
            this.boundsCenter.add((Tuple3d)boundingBox.max, (Tuple3d)boundingBox.min);
            this.boundsCenter.scale(0.5);
        }
        this.tmpSpectrum0 = spectrum.newInstance();
        this.tmpSpectrum1 = spectrum.newInstance();
    }

    public void set(Intersection intersection, int n, Scene scene) {
        if ((n & 2) != 0) {
            if (intersection.parameter == Double.POSITIVE_INFINITY) {
                this.tmpVector0.normalize(intersection.line.direction);
                this.point.set((Tuple3d)this.tmpVector0);
                this.tmpVector0.scale(1.0E100);
                scene.transform(intersection.volume, (Tuple3d)this.tmpVector0, (Tuple3d)this.tmpVector0);
                this.tmpVector0.normalize();
                this.localPoint.set((Tuple3d)this.tmpVector0);
            } else {
                Point3d point3d = intersection.getPoint();
                this.point.set((Tuple3d)point3d);
                scene.transform(intersection.volume, (Tuple3d)point3d, (Tuple3d)this.tmpVector0);
                this.localPoint.set((Tuple3d)this.tmpVector0);
            }
        }
        if ((n & 4) != 0) {
            this.normal.set((Tuple3d)intersection.getNormal());
        }
        if ((n & 0x10) != 0) {
            this.uv.set((Tuple2d)intersection.getUV());
        }
        if ((n & 8) != 0) {
            this.dpdu.set((Tuple3d)intersection.getUTangent());
            this.dpdv.set((Tuple3d)intersection.getVTangent());
        }
        this.solid = intersection.type != 0;
    }
}

