/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.physics;

import de.grogra.ray.physics.Spectrum;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;

public class Spectrum3f
extends Color3f
implements Spectrum {
    public Spectrum3f() {
    }

    public Spectrum3f(float f, float f2, float f3) {
        super(f, f2, f3);
    }

    public void clampMinZero() {
        this.clampMin(0.0f);
    }

    public double evaluateDouble(double d) {
        return 0.0;
    }

    public void setZero() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public void setIdentity() {
        this.z = 1.0f;
        this.y = 1.0f;
        this.x = 1.0f;
    }

    public Spectrum3f clone() {
        return new Spectrum3f(this.x, this.y, this.z);
    }

    public Spectrum3f newInstance() {
        return new Spectrum3f();
    }

    public void scale(double d) {
        this.x = (float)((double)this.x * d);
        this.y = (float)((double)this.y * d);
        this.z = (float)((double)this.z * d);
    }

    public void add(Spectrum spectrum) {
        if (spectrum instanceof Tuple3d) {
            Tuple3d tuple3d = (Tuple3d)spectrum;
            this.x = (float)((double)this.x + tuple3d.x);
            this.y = (float)((double)this.y + tuple3d.y);
            this.z = (float)((double)this.z + tuple3d.z);
        } else {
            this.add((Tuple3f)spectrum);
        }
    }

    public void sub(Spectrum spectrum) {
        if (spectrum instanceof Tuple3d) {
            Tuple3d tuple3d = (Tuple3d)spectrum;
            this.x = (float)((double)this.x - tuple3d.x);
            this.y = (float)((double)this.y - tuple3d.y);
            this.z = (float)((double)this.z - tuple3d.z);
        } else {
            this.sub((Tuple3f)spectrum);
        }
    }

    public void dot(Spectrum spectrum, Tuple3d tuple3d) {
        if (spectrum instanceof Tuple3d) {
            Tuple3d tuple3d2 = (Tuple3d)spectrum;
            tuple3d.x = (double)this.x * tuple3d2.x;
            tuple3d.y = (double)this.y * tuple3d2.y;
            tuple3d.z = (double)this.z * tuple3d2.z;
        } else {
            Tuple3f tuple3f = (Tuple3f)spectrum;
            tuple3d.x = this.x * tuple3f.x;
            tuple3d.y = this.y * tuple3f.y;
            tuple3d.z = this.z * tuple3f.z;
        }
    }

    public void mul(Spectrum spectrum) {
        if (spectrum instanceof Tuple3d) {
            this.mul((Tuple3d)spectrum);
        } else {
            this.mul((Tuple3f)spectrum);
        }
    }

    public void mul(Tuple3d tuple3d) {
        this.x = (float)((double)this.x * tuple3d.x);
        this.y = (float)((double)this.y * tuple3d.y);
        this.z = (float)((double)this.z * tuple3d.z);
    }

    public void mul(Tuple3f tuple3f) {
        this.x *= tuple3f.x;
        this.y *= tuple3f.y;
        this.z *= tuple3f.z;
    }

    public void div(Spectrum spectrum) {
        if (spectrum instanceof Tuple3d) {
            this.div((Tuple3d)spectrum);
        } else {
            this.div((Tuple3f)spectrum);
        }
    }

    public void div(Tuple3d tuple3d) {
        if (this.x != 0.0f) {
            this.x = (float)((double)this.x / tuple3d.x);
        }
        if (this.y != 0.0f) {
            this.y = (float)((double)this.y / tuple3d.y);
        }
        if (this.z != 0.0f) {
            this.z = (float)((double)this.z / tuple3d.z);
        }
    }

    public void div(Tuple3f tuple3f) {
        if (this.x != 0.0f) {
            this.x /= tuple3f.x;
        }
        if (this.y != 0.0f) {
            this.y /= tuple3f.y;
        }
        if (this.z != 0.0f) {
            this.z /= tuple3f.z;
        }
    }

    public void get(Tuple3d tuple3d) {
        tuple3d.set((Tuple3f)this);
    }

    public double integrate() {
        return this.x + this.y + this.z;
    }

    public void set(Spectrum spectrum) {
        spectrum.get((Tuple3f)this);
    }

    public double sum() {
        return this.x + this.y + this.z;
    }

    public double getMax() {
        double d = this.x;
        d = Math.max(d, (double)this.y);
        d = Math.max(d, (double)this.z);
        return d;
    }
}

