/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.antialiasing;

import de.grogra.ray.util.Ray;
import de.grogra.ray2.Scene;
import de.grogra.ray2.antialiasing.Antialiasing;
import de.grogra.ray2.antialiasing.NoAntialiasing;
import de.grogra.ray2.tracing.MetropolisProcessor;
import de.grogra.ray2.tracing.MetropolisRenderer;
import de.grogra.ray2.tracing.PixelwiseRenderer;
import de.grogra.vecmath.geom.Line;
import java.util.ArrayList;
import java.util.Random;
import javax.vecmath.Tuple3f;
import net.goui.util.MTRandom;

public class MetropolisAntiAliasing
extends NoAntialiasing {
    public static final String SEED_COUNT = "MetropolisPathTracer/seedCount";
    public static final String MUTATION_PP_COUNT = "MetropolisPathTracer/mutationPPCount";
    int width;
    int height;
    int pixelCount;
    MTRandom pathRand;
    float r1;
    float r2;
    int maxMutationPPCount;
    int maxY = 0;
    float maxYFloat = 0.0f;
    ArrayList<float[]> freePixelList;
    int[][] stratifiedCounterField;

    public void initialize(PixelwiseRenderer pixelwiseRenderer, Scene scene) {
        this.renderer = pixelwiseRenderer;
        this.scene = scene;
        this.initLocals();
        this.pathRand = new MTRandom(pixelwiseRenderer.getSeed());
        this.processor = new MetropolisProcessor();
        ((MetropolisProcessor)this.processor).initialize(pixelwiseRenderer, scene);
        MetropolisRenderer cfr_ignored_0 = (MetropolisRenderer)pixelwiseRenderer;
        this.maxMutationPPCount = MetropolisRenderer.mutationPPCount;
    }

    public Antialiasing dup(Scene scene) {
        MetropolisAntiAliasing metropolisAntiAliasing = new MetropolisAntiAliasing();
        metropolisAntiAliasing.processor = this.processor.dup(scene);
        metropolisAntiAliasing.scene = scene;
        metropolisAntiAliasing.renderer = this.renderer;
        metropolisAntiAliasing.initLocals();
        metropolisAntiAliasing.width = this.width;
        metropolisAntiAliasing.height = this.height;
        metropolisAntiAliasing.pixelCount = this.pixelCount;
        metropolisAntiAliasing.pathRand = this.pathRand;
        metropolisAntiAliasing.maxMutationPPCount = this.maxMutationPPCount;
        return metropolisAntiAliasing;
    }

    public void resetAll() {
        ((MetropolisProcessor)this.processor).resetAll();
    }

    public void setImageValues(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.freePixelList = new ArrayList();
        this.stratifiedCounterField = new int[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.stratifiedCounterField[i][j] = 0;
                float[] fArray = new float[]{(float)i + 0.5f, (float)j + 0.5f};
                this.freePixelList.add(fArray);
            }
        }
        float f = 2.0f / (float)n;
        this.r1 = 0.1f * f;
        this.r2 = (float)Math.sqrt((double)(0.05f * (float)n * (float)n2) / Math.PI);
        System.err.println("Metro-AA: setImgVal: width=" + this.width + " height=" + this.height);
    }

    public void initializeProccessorLoop(float f, int n, int n2, int n3, MetropolisRenderer.MetropolisResult metropolisResult, int n4) {
        this.setImageValues(n, n2);
        ((MetropolisProcessor)this.processor).initializeLoop(f, n, n2, n3, metropolisResult, n4);
    }

    public int getProcessorMutatedPixels() {
        return ((MetropolisProcessor)this.processor).getMutatedPixels();
    }

    public void signAntialiser2Processor() {
        ((MetropolisProcessor)this.processor).tracingMediator.setAntialiser(this);
    }

    public void stopProcessor() {
        MetropolisProcessor cfr_ignored_0 = (MetropolisProcessor)this.processor;
        MetropolisProcessor.stopped = true;
    }

    public Line getNewLensEdge() {
        float f = (float)(this.pixelCount % this.width) + 0.5f;
        float f2 = (float)(this.pixelCount / this.width) + 0.5f;
        ++this.pixelCount;
        if (this.pixelCount >= this.height * this.width) {
            this.pixelCount = 0;
        }
        double d = 2.0 / (double)this.width;
        double d2 = 2.0 / (double)this.height;
        this.setPixelXY(f, f2);
        return this.getRayByCoordinates((double)f * d - 1.0, (0.5 * (double)this.height - (double)(f2 + 1.0f)) * d, d, d, this.pathRand);
    }

    public Line getPerturbedLensEdge(Line line) {
        float f = this.pathRand.nextFloat();
        float f2 = this.r2 * (float)Math.exp(-Math.log(this.r2 / this.r1) * (double)f);
        float f3 = (float)(Math.PI * 2 * (double)this.pathRand.nextFloat());
        float f4 = line.x;
        float f5 = line.y;
        f4 += (float)Math.round(Math.sin(f3) * (double)f2);
        f5 += (float)Math.round(Math.cos(f3) * (double)f2);
        if (f4 < 0.0f) {
            f4 += (float)this.width;
        }
        if (f5 < 0.0f) {
            f5 += (float)this.height;
        }
        if (f4 >= (float)this.width) {
            f4 -= (float)this.width;
        }
        if (f5 >= (float)this.height) {
            f5 -= (float)this.height;
        }
        double d = 2.0 / (double)this.width;
        double d2 = 2.0 / (double)this.height;
        this.setPixelXY(f4, f5);
        f4 = (float)((double)f4 * d - 1.0);
        f5 = (float)((0.5 * (double)this.height - (double)(f5 + 1.0f)) * d);
        Ray ray = this.list.rays[0];
        this.env.uv.set(f4, f5);
        this.renderer.getCamera().generateRandomOrigins(this.env, this.list, this.pathRand);
        this.tmpSpectrum.set(ray.spectrum);
        this.env.point.set((Tuple3f)ray.origin);
        this.env.globalToLocal.transform(this.env.point, this.env.localPoint);
        this.renderer.getCamera().generateRandomRays(this.env, null, this.tmpSpectrum, this.list, false, this.pathRand);
        Line line2 = ray.convert2Line();
        line2.x = this.xPixel;
        line2.y = this.yPixel;
        return line2;
    }

    private float[] rover() {
        if (this.freePixelList.size() > 0) {
            float f;
            int n = this.pathRand.nextInt(this.freePixelList.size());
            float[] fArray = this.freePixelList.get(n);
            float f2 = fArray[0];
            if ((float)this.stratifiedCounterField[(int)f2][(int)(f = fArray[1])] >= (float)this.maxMutationPPCount / 2.0f) {
                this.freePixelList.remove(n);
            }
            return fArray;
        }
        return null;
    }

    public Line getStratifiedLensEdge() {
        float[] fArray = this.rover();
        if (fArray == null) {
            System.err.println(" MetroAA: getStratifiedLensEdge:  Unsuspected stop!");
            return null;
        }
        float f = fArray[0];
        float f2 = fArray[1];
        double d = 2.0 / (double)this.width;
        double d2 = 2.0 / (double)this.height;
        this.setPixelXY(f, f2);
        this.maxY = (int)Math.max(f2, (float)this.maxY);
        this.maxYFloat = Math.min((float)((0.5 * (double)this.height - (double)(this.maxY + 1)) * d), this.maxYFloat);
        return this.getRayByCoordinates((double)f * d - 1.0, (0.5 * (double)this.height - (double)(f2 + 1.0f)) * d, d, d, this.pathRand);
    }

    public Line getRayByCoordinates(double d, double d2, double d3, double d4, Random random) {
        float f = random.nextFloat() - 0.5f;
        float f2 = random.nextFloat() - 0.5f;
        Ray ray = this.list.rays[0];
        this.env.uv.set((float)(d + d3 * (double)f), (float)(d2 + d4 * (double)f2));
        this.renderer.getCamera().generateRandomOrigins(this.env, this.list, random);
        this.tmpSpectrum.set(ray.spectrum);
        this.env.point.set((Tuple3f)ray.origin);
        this.env.globalToLocal.transform(this.env.point, this.env.localPoint);
        this.renderer.getCamera().generateRandomRays(this.env, null, this.tmpSpectrum, this.list, false, random);
        Line line = ray.convert2Line();
        line.x = this.xPixel;
        line.y = this.yPixel;
        return line;
    }

    public void setPixelXY(float f, float f2) {
        super.setPixelXY(f, f2);
    }

    public void registerUsedLensEdge(float f, float f2) {
        this.stratifiedCounterField[(int)f][(int)f2] = this.stratifiedCounterField[(int)f][(int)f2] + 1;
    }

    public void pathChanged() {
        ((MetropolisProcessor)this.processor).pathChanged();
    }
}

