/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.metropolis;

import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Scattering;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3d;
import de.grogra.ray.util.RayList;
import de.grogra.ray2.light.LightProcessor;
import de.grogra.ray2.tracing.modular.CombinedPathValues;
import de.grogra.vecmath.geom.Intersection;
import java.util.ArrayList;
import java.util.Random;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3f;

public class DirectLightingCalculator {
    LightProcessor lightProcessor;
    Tuple3d color;
    RayList rays;
    Tuple3d tmpColor = new Point3d();
    Spectrum3d tmpSpectrum = new Spectrum3d();
    Vector3f view = new Vector3f();

    public DirectLightingCalculator() {
        this.rays = new RayList();
        this.color = new Point3d();
    }

    public void setLightProccessor(LightProcessor lightProcessor) {
        this.lightProcessor = lightProcessor;
    }

    public Tuple3d calculateDirectLight(CombinedPathValues combinedPathValues, int n, Random random) {
        Scattering scattering = (Scattering)combinedPathValues.shaderList.get(n);
        Intersection intersection = (Intersection)combinedPathValues.intersecList.get(n);
        Environment environment = (Environment)combinedPathValues.envList.get(n);
        Spectrum spectrum = combinedPathValues.weightListEB.get(n);
        boolean bl = intersection != null ? intersection.parameter < Double.POSITIVE_INFINITY : false;
        this.color.set(0.0, 0.0, 0.0);
        if (scattering != null && bl) {
            this.rays.clear();
            this.view.set((Tuple3d)intersection.line.direction);
            this.view.negate();
            this.lightProcessor.getLightRays(intersection.line.direction.dot(intersection.getNormal()) < 0.0, intersection, this.rays, new ArrayList(), random);
            for (int i = this.rays.size() - 1; i >= 0; --i) {
                scattering.computeBSDF(environment, this.view, this.rays.rays[i].spectrum, this.rays.rays[i].direction, true, this.tmpSpectrum);
                this.tmpSpectrum.dot(spectrum, this.tmpColor);
                this.color.add(this.tmpColor);
            }
        }
        return this.color;
    }
}

