/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.radiosity;

import de.grogra.ray.physics.Shader;
import de.grogra.ray2.radiosity.PatchGroup;
import de.grogra.ray2.radiosity.Vector3d;
import java.util.Vector;
import javax.vecmath.Color3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupListBuilder {
    private static final int maskR = 0xFF0000;
    private static final int shiftR = 16;
    private static final int maskG = 65280;
    private static final int shiftG = 8;
    private static final int maskB = 255;
    private static final int shiftB = 0;
    private Vector<PatchGroup> groups = new Vector();
    private int id = 0;

    public void add(Shader shader, Vector3d[] vector3dArray, Color3f color3f) {
        int n = shader.getAverageColor();
        float f = (float)((n & 0xFF0000) >> 16) / 255.0f;
        float f2 = (float)((n & 0xFF00) >> 8) / 255.0f;
        float f3 = (float)((n & 0xFF) >> 0) / 255.0f;
        this.groups.add(new PatchGroup(vector3dArray, this.id, color3f, new Color3f(f, f2, f3), new Color3f(), true));
        ++this.id;
    }

    public void add(Shader shader, Vector3d[] vector3dArray) {
        int n = shader.getAverageColor();
        float f = (float)((n & 0xFF0000) >> 16) / 255.0f;
        float f2 = (float)((n & 0xFF00) >> 8) / 255.0f;
        float f3 = (float)((n & 0xFF) >> 0) / 255.0f;
        this.groups.add(new PatchGroup(vector3dArray, this.id, new Color3f(), new Color3f(f, f2, f3), new Color3f(), true));
        ++this.id;
    }

    public void add(Vector3d[] vector3dArray, Color3f color3f, boolean bl) {
        this.groups.add(new PatchGroup(vector3dArray, this.id, color3f, new Color3f(), new Color3f(), bl));
        ++this.id;
    }

    public Vector<PatchGroup> getGroups() {
        return this.groups;
    }
}

