/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.radiosity.triangulation;

import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Light;
import de.grogra.ray.util.RayList;
import de.grogra.ray2.Scene;
import de.grogra.ray2.radiosity.GroupListBuilder;
import de.grogra.ray2.radiosity.triangulation.Cone;
import de.grogra.ray2.radiosity.triangulation.Cube;
import de.grogra.ray2.radiosity.triangulation.Cylinder;
import de.grogra.ray2.radiosity.triangulation.Frustum;
import de.grogra.ray2.radiosity.triangulation.PointLight;
import de.grogra.ray2.radiosity.triangulation.Sphere;
import de.grogra.ray2.radiosity.triangulation.Square;
import de.grogra.ray2.radiosity.triangulation.TriangulationException;
import de.grogra.vecmath.geom.TransformableVolume;
import de.grogra.vecmath.geom.Volume;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import net.goui.util.MTRandom;

public class Triangulizer {
    public static void triangulize(GroupListBuilder groupListBuilder, Scene scene, Volume volume) throws TriangulationException {
        if (volume instanceof de.grogra.vecmath.geom.Cube) {
            Cube.computePatches(groupListBuilder, (TransformableVolume)volume, scene.getShader(volume));
            return;
        }
        if (volume instanceof de.grogra.vecmath.geom.Sphere) {
            Sphere.computePatches(groupListBuilder, (TransformableVolume)volume, scene.getShader(volume));
            return;
        }
        if (volume instanceof de.grogra.vecmath.geom.Cylinder) {
            Cylinder.computePatches(groupListBuilder, (TransformableVolume)volume, scene.getShader(volume));
            return;
        }
        if (volume instanceof de.grogra.vecmath.geom.Frustum) {
            Frustum.computePatches(groupListBuilder, (TransformableVolume)volume, scene.getShader(volume));
            return;
        }
        if (volume instanceof de.grogra.vecmath.geom.Cone) {
            Cone.computePatches(groupListBuilder, (TransformableVolume)volume, scene.getShader(volume));
            return;
        }
        if (volume instanceof de.grogra.vecmath.geom.Square) {
            Color3f color3f = new Color3f();
            int n = scene.getLight(volume);
            if (n != -1) {
                Light light = scene.getLights()[n];
                RayList rayList = new RayList(1);
                Environment environment = new Environment(scene.getBoundingBox(), scene.createSpectrum(), 0);
                environment.localToGlobal.set(scene.getLightTransformation(n));
                light.generateRandomOrigins(environment, rayList, new MTRandom());
                color3f.x = rayList.rays[0].color.x;
                color3f.y = rayList.rays[0].color.y;
                color3f.z = rayList.rays[0].color.z;
            }
            Square.computePatches(groupListBuilder, (TransformableVolume)volume, scene.getShader(volume), color3f);
            return;
        }
        throw new TriangulationException("Triangulation not possible for this object: " + volume);
    }

    public static void triangulize(GroupListBuilder groupListBuilder, Scene scene, int n) throws TriangulationException {
        Light light = scene.getLights()[n];
        if ("de.grogra.imp3d.objects.Parallelogram".equals(light.getClass().getName())) {
            return;
        }
        if ("de.grogra.imp3d.objects.PointLight".equals(light.getClass().getName())) {
            Matrix4d matrix4d = scene.getLightTransformation(n);
            Point3d point3d = new Point3d(matrix4d.m03, matrix4d.m13, matrix4d.m23);
            Environment environment = new Environment(scene.getBoundingBox(), scene.createSpectrum(), 0);
            environment.localToGlobal.set(matrix4d);
            RayList rayList = new RayList(1);
            light.generateRandomOrigins(environment, rayList, new MTRandom());
            PointLight.computePatches(groupListBuilder, point3d, rayList.rays[0].color);
            return;
        }
        throw new TriangulationException("Triangulation not possible for this light: " + light);
    }
}

