/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.tracing;

import de.grogra.ray.physics.Light;
import de.grogra.ray.physics.Shader;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import de.grogra.ray2.Resources;
import de.grogra.ray2.light.DefaultLightProcessor;
import de.grogra.ray2.tracing.ProcessorBase;
import de.grogra.ray2.tracing.RayProcessorBase;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.Line;
import java.util.Random;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class DefaultRayProcessor
extends RayProcessorBase {
    private static final float MAX_VARIANCE = 1.7608814f;
    private static final float MIN_WEIGHT = 0.03f;
    private long reflectedCount = 0L;
    private long transmittedCount = 0L;
    private Vector3f reflectedVariance;
    private Vector3f refractedVariance;
    private RayList rays;
    private Vector3f view;

    public DefaultRayProcessor() {
        this.setLightProcessor(new DefaultLightProcessor());
    }

    protected void initLocals() {
        super.initLocals();
        this.reflectedVariance = new Vector3f();
        this.refractedVariance = new Vector3f();
        this.rays = new RayList(this.scene.createSpectrum());
        this.view = new Vector3f();
    }

    int getEnvironmentType() {
        return 0;
    }

    float traceRay(int n, Intersection intersection, Spectrum spectrum, Tuple3d tuple3d, RayProcessorBase.Locals locals, Random random) {
        Spectrum spectrum2 = locals.newWeight;
        Ray ray = locals.reflected;
        Ray ray2 = locals.transmitted;
        Spectrum spectrum3 = locals.tmpSpectrum;
        Line line = locals.tmpRay;
        float f = 0.0f;
        boolean bl = intersection.parameter < Double.POSITIVE_INFINITY;
        this.view.set((Tuple3d)intersection.line.direction);
        this.view.negate();
        assert (Math.abs(this.view.lengthSquared() - 1.0f) < 1.0E-4f);
        Shader shader = this.scene.getShader(intersection.volume);
        int n2 = this.scene.getLight(intersection.volume);
        Light light = n2 >= 0 ? this.scene.getLights()[n2] : null;
        locals.env.set(intersection, (shader != null ? shader.getFlags() : 0) | (light != null ? light.getFlags() : 0), this.scene);
        locals.env.iorRatio = (float)this.getIOR(intersection, spectrum);
        if (light != null && !light.isIgnoredWhenHit()) {
            this.rays.setSize(1);
            Ray ray3 = this.rays.rays[0];
            ray3.direction.set((Tuple3d)intersection.getNormal());
            ray3.direction.negate();
            ray3.direction.normalize();
            locals.env.localToGlobal.set(this.scene.getLightTransformation(n2));
            locals.env.globalToLocal.set(this.scene.getInverseLightTransformation(n2));
            light.computeExitance(locals.env, ray3.spectrum);
            light.computeBSDF(locals.env, ray3.direction, ray3.spectrum, this.view, false, spectrum3);
            spectrum3.dot(spectrum, this.tmpColor);
            ray3.spectrum.set(spectrum3);
            tuple3d.add(this.tmpColor);
        }
        this.rays.clear();
        if (bl && shader != null) {
            this.lightProcessor.getLightRays(intersection.line.direction.dot(intersection.getNormal()) < 0.0, intersection, this.rays, locals.lightCache, random);
            if (this.rays.size() > 0) {
                shader.shade(locals.env, this.rays, this.view, spectrum, this.tmpColor);
                tuple3d.add(this.tmpColor);
            }
        }
        if (bl && n <= this.maxDepth) {
            int n3;
            int n4;
            line.origin.set((Tuple3d)intersection.getPoint());
            if (shader != null) {
                shader.computeMaxRays(locals.env, this.view, spectrum, ray, (Tuple3f)this.reflectedVariance, ray2, (Tuple3f)this.refractedVariance);
            } else {
                this.reflectedVariance.set(1.7608814f, 1.7608814f, 1.7608814f);
                ray.spectrum.setZero();
                this.refractedVariance.set(0.0f, 0.0f, 0.0f);
                ray2.direction.set((Tuple3d)intersection.line.direction);
                ray2.spectrum.set(spectrum);
            }
            float f2 = this.reflectedVariance.x + this.reflectedVariance.y + this.reflectedVariance.z;
            float f3 = this.refractedVariance.x + this.refractedVariance.y + this.refractedVariance.z;
            if (f2 < 1.7608814f && ray.spectrum.integrate() > (double)0.03f) {
                ++this.reflectedCount;
                spectrum2.set(ray.spectrum);
                n4 = this.ilist.size;
                line.direction.set((Tuple3f)ray.direction);
                this.scene.computeIntersections(line, 1, this.ilist, intersection, null);
                if (this.ilist.size > n4) {
                    n3 = this.record(intersection, true);
                    this.traceRay(n + 1, this.ilist.elements[n4], spectrum2, tuple3d, locals.nextReflected(), random);
                    this.unrecord(intersection, n3);
                    this.ilist.setSize(n4);
                }
            }
            if (f3 < 1.7608814f && ray2.spectrum.integrate() > (double)0.03f) {
                ++this.transmittedCount;
                spectrum2.set(ray2.spectrum);
                n4 = this.ilist.size;
                line.direction.set((Tuple3f)ray2.direction);
                this.scene.computeIntersections(line, 1, this.ilist, intersection, null);
                if (this.ilist.size > n4) {
                    n3 = this.record(intersection, false);
                    f = this.traceRay(n + 1, this.ilist.elements[n4], spectrum2, tuple3d, locals.nextTransmitted(), random);
                    this.unrecord(intersection, n3);
                    this.ilist.setSize(n4);
                } else {
                    f = (float)spectrum2.integrate();
                }
            }
        }
        return f;
    }

    protected void mergeStatistics(ProcessorBase processorBase) {
        super.mergeStatistics(processorBase);
        this.reflectedCount += ((DefaultRayProcessor)processorBase).reflectedCount;
        this.transmittedCount += ((DefaultRayProcessor)processorBase).transmittedCount;
    }

    protected void appendStatisticsImpl(StringBuffer stringBuffer) {
        stringBuffer.append(Resources.msg("rayprocessor.default.statistics", new Long(this.primaryCount), new Long(this.reflectedCount), new Long(this.transmittedCount)));
        this.lightProcessor.appendStatistics(stringBuffer);
    }
}

