/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.task;

import de.grogra.task.PartialTask;
import de.grogra.task.Solver;

public abstract class SolverInOwnThread
extends Solver
implements Runnable {
    private boolean running;
    private boolean disposed;
    private boolean useThread;
    private int id;

    protected abstract Thread createThread();

    protected abstract void solveImpl(PartialTask var1);

    protected synchronized void solve() {
        if (!this.running) {
            Thread thread = this.createThread();
            boolean bl = this.useThread = thread != null;
            if (this.useThread) {
                thread.start();
            }
            this.running = true;
        }
        if (this.useThread) {
            this.notifyAll();
        } else {
            this.solveImpl(this.getCurrentPartialTask());
            this.getTask().partialTaskDone(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!this.getTask().isStopped()) {
                PartialTask partialTask;
                SolverInOwnThread solverInOwnThread = this;
                synchronized (solverInOwnThread) {
                    if (this.disposed) {
                        break;
                    }
                    partialTask = this.getCurrentPartialTask();
                    if (partialTask == null) {
                        this.wait();
                    }
                }
                if (partialTask == null) continue;
                this.solveImpl(partialTask);
                this.getTask().partialTaskDone(this);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        finally {
            this.getTask().removeSolver(this);
        }
    }

    public synchronized void dispose() {
        this.disposed = true;
        this.notifyAll();
    }
}

