/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.grogra;

import de.grogra.grammar.LexicalException;
import de.grogra.grammar.RecognitionException;
import de.grogra.grammar.SemanticException;
import de.grogra.grammar.Token;
import de.grogra.grammar.Tokenizer;
import de.grogra.grammar.UnexpectedTokenException;
import de.grogra.graph.impl.Node;
import de.grogra.grogra.DTGShoot;
import de.grogra.math.TMatrix4d;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.ReaderSource;
import de.grogra.turtle.F;
import de.grogra.util.IOWrapException;
import de.grogra.xl.util.IntHashMap;
import de.grogra.xl.util.IntList;
import java.io.IOException;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class DTGFilter
extends FilterBase
implements ObjectSource {
    public static final FilterSource.MetaDataKey<Float> SCALE = new FilterSource.MetaDataKey("scale");

    public DTGFilter(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(IOFlavor.NODE);
    }

    public Object getObject() throws IOException {
        DTGTokenizer dTGTokenizer = new DTGTokenizer();
        IntHashMap intHashMap = new IntHashMap(100);
        IntList intList = new IntList();
        float f = ((Float)this.getMetaData(SCALE, Float.valueOf(0.001f))).floatValue();
        dTGTokenizer.setSource(((ReaderSource)this.source).getReader(), this.source.getSystemId());
        try {
            Object object;
            ShootInfo shootInfo;
            Token token;
            dTGTokenizer.consume(12);
            Vector3f vector3f = new Vector3f();
            while ((token = dTGTokenizer.getToken()).getType() == 13) {
                shootInfo = new ShootInfo();
                int n = dTGTokenizer.getInt();
                int n2 = dTGTokenizer.getInt();
                dTGTokenizer.getFloat();
                object = new DTGShoot();
                shootInfo.shoot = object;
                object.diameter = f * dTGTokenizer.getFloat();
                dTGTokenizer.getFloat();
                object.parameter = dTGTokenizer.getFloat();
                object.internodeCount = dTGTokenizer.getInt();
                object.color = dTGTokenizer.getInt();
                shootInfo.order = dTGTokenizer.getInt();
                dTGTokenizer.getInt();
                object.generativeDistance = dTGTokenizer.getInt();
                object.relPosition = dTGTokenizer.getFloat();
                dTGTokenizer.consumeFloats(6);
                dTGTokenizer.getTuple((Tuple3f)shootInfo);
                shootInfo.scale(f);
                dTGTokenizer.getTuple((Tuple3f)shootInfo.tip);
                shootInfo.tip.scale(f);
                vector3f.sub((Tuple3f)shootInfo.tip, (Tuple3f)shootInfo);
                object.length = vector3f.length();
                dTGTokenizer.getTuple((Tuple3f)vector3f);
                vector3f.normalize();
                shootInfo.xf.setColumn(2, vector3f);
                dTGTokenizer.getTuple((Tuple3f)vector3f);
                vector3f.normalize();
                shootInfo.xf.setColumn(0, vector3f);
                dTGTokenizer.getTuple((Tuple3f)vector3f);
                vector3f.normalize();
                shootInfo.xf.setColumn(1, vector3f);
                intHashMap.put(n, (Object)shootInfo);
                intList.push(n).push(n2);
            }
            if (token.getType() != 14) {
                throw new UnexpectedTokenException(token.getText(), "e").set((Tokenizer)dTGTokenizer);
            }
            shootInfo = null;
            object = new Matrix3f();
            Matrix4d matrix4d = new Matrix4d();
            matrix4d.setIdentity();
            while (!intList.isEmpty()) {
                ShootInfo shootInfo2 = (ShootInfo)((Object)intHashMap.get(intList.pop(), null));
                ShootInfo shootInfo3 = (ShootInfo)((Object)intHashMap.get(intList.pop(), null));
                if (shootInfo2 == null) {
                    if (shootInfo != null) {
                        throw new SemanticException("Invalid parent").set((Tokenizer)dTGTokenizer);
                    }
                    shootInfo = shootInfo3;
                    object.setIdentity();
                } else {
                    object.invert(shootInfo2.xf);
                    shootInfo3.sub((Tuple3f)shootInfo2.tip);
                }
                object.transform((Tuple3f)shootInfo3);
                object.mul(object, shootInfo3.xf);
                matrix4d.setRotationScale(object);
                matrix4d.m03 = shootInfo3.x;
                matrix4d.m13 = shootInfo3.y;
                matrix4d.m23 = shootInfo3.z;
                shootInfo3.shoot.setTransform(new TMatrix4d(matrix4d));
                if (shootInfo2 == null) continue;
                shootInfo2.shoot.addEdgeBitsTo((Node)shootInfo3.shoot, shootInfo3.order == shootInfo2.order ? 256 : 512, null);
            }
            if (shootInfo == null) {
                throw new SemanticException("No root").set((Tokenizer)dTGTokenizer);
            }
            return shootInfo.shoot;
        }
        catch (RecognitionException recognitionException) {
            throw new IOWrapException((Throwable)recognitionException);
        }
    }

    private static final class ShootInfo
    extends Point3f {
        F shoot;
        int order;
        final Matrix3f xf = new Matrix3f();
        final Vector3f tip = new Vector3f();

        private ShootInfo() {
        }
    }

    private static final class DTGTokenizer
    extends Tokenizer {
        static final int N = 12;
        static final int S = 13;
        static final int E = 14;

        DTGTokenizer() {
            super(22);
            this.addToken(12, "n");
            this.addToken(13, "S");
            this.addToken(14, "e");
        }

        void getTuple(Tuple3f tuple3f) throws IOException, LexicalException {
            tuple3f.set(this.getFloat(), this.getFloat(), this.getFloat());
        }

        void consumeFloats(int n) throws IOException, LexicalException {
            for (int i = 0; i < n; ++i) {
                this.getFloat();
            }
        }

        protected boolean isWhitespace(char c) {
            return c < ' ' || super.isWhitespace(c);
        }

        protected boolean isIdentifierStart(char c) {
            return !this.isWhitespace(c) && super.isIdentifierStart(c);
        }

        protected boolean isIdentifierPart(char c) {
            return !this.isWhitespace(c) && super.isIdentifierPart(c);
        }
    }
}

