/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.mtg;

import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.io.SceneGraphExport;
import de.grogra.imp3d.objects.SceneTree;
import de.grogra.mtg.MTGError;
import de.grogra.mtg.MTGKeys;
import de.grogra.persistence.ManageableType;
import de.grogra.pf.io.FileWriterSource;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.registry.PluginDescriptor;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.ui.Workbench;
import de.grogra.reflect.Method;
import de.grogra.reflect.Type;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class MTGExport
extends SceneGraphExport
implements FileWriterSource {
    private ArrayList<String> code;
    private ArrayList<ArrayList<String>> classes;
    private ArrayList<String> description;
    private ArrayList<String> features;
    private ArrayList<String> mtg;
    private ArrayList<ArrayList<String>> classesGroIMP;
    private ArrayList<ArrayList<String>> classesMTG;
    private ArrayList<String> fieldsGroIMP;
    private ArrayList<Node> latest;
    private ArrayList<ArrayList<Node>> stack;
    private ArrayList<Integer> stackLastTrav;
    private int maxStackSize;
    private int scale;
    private int symbolCode;
    private int nodeId;
    private Workbench workbench = null;

    public MTGExport(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(filterItem.getOutputFlavor());
        this.workbench = Workbench.current();
        this.initContentBuffers();
    }

    private void initContentBufferCode() {
        this.code = new ArrayList();
        this.code.add("#Generated by GroIMP " + ((PluginDescriptor)this.workbench.getRegistry().getPluginDirectory().getBranch()).getPluginVersion());
        this.code.add("CODE:\tFORM-A");
    }

    private void initContentBufferClasses() {
        this.classes = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("CLASSES:");
        arrayList.add("SYMBOL\tSCALE\tDECOMPOSITION\tINDEXATION\tDEFINITION");
        arrayList.add("$ \t0\tFREE\tFREE\tIMPLICIT");
        this.classes.add(arrayList);
    }

    private void initContentBufferDescription() {
        this.description = new ArrayList();
        this.description.add("DESCRIPTION :");
        this.description.add("LEFT\tRIGHT\tRELTYPE\tMAX");
    }

    private void initContentBufferFeatures() {
        this.features = new ArrayList();
        this.features.add("FEATURES:");
        this.features.add("NAME\tTYPE");
    }

    private void initContentBufferMtg() {
        int n;
        this.mtg = new ArrayList();
        this.mtg.add("MTG:");
        this.mtg.add("");
        String string = new String();
        string = string + "ENTITY-CODE";
        int n2 = this.maxStackSize + 1;
        for (n = 0; n < n2; ++n) {
            string = string + "\t";
        }
        for (n = 0; n < this.fieldsGroIMP.size(); ++n) {
            string = string + this.fieldsGroIMP.get(n);
            if (n == this.fieldsGroIMP.size() - 1) continue;
            string = string + "\t";
        }
        this.mtg.add(string);
    }

    private void initContentBuffers() {
        this.initContentBufferCode();
        this.initContentBufferClasses();
        this.initContentBufferDescription();
        this.initContentBufferFeatures();
    }

    private void initStatesStacks() {
        this.classesGroIMP = new ArrayList();
        this.classesMTG = new ArrayList();
        this.fieldsGroIMP = new ArrayList();
        this.latest = new ArrayList();
        this.stack = new ArrayList();
        this.stackLastTrav = new ArrayList();
        this.maxStackSize = 0;
        this.scale = 1;
        this.symbolCode = 65;
        this.nodeId = 0;
    }

    private void clearStatesStacks() {
        this.classesGroIMP.clear();
        this.classesMTG.clear();
        this.latest.clear();
        this.stack.clear();
        this.stackLastTrav.clear();
        this.scale = 1;
        this.symbolCode = 65;
        this.nodeId = 0;
    }

    private int nextNodeId() {
        int n = this.nodeId++;
        return n;
    }

    private void fillBufferDescription() {
        for (int i = 0; i < this.classesMTG.size(); ++i) {
            ArrayList<String> arrayList = this.classesMTG.get(i);
            for (int j = 0; j < arrayList.size(); ++j) {
                String string = arrayList.get(j);
                String string2 = "";
                String string3 = "";
                string2 = string2 + string;
                string2 = string2 + "\t";
                string3 = string3 + string;
                string3 = string3 + "\t";
                for (int k = 0; k < arrayList.size(); ++k) {
                    string2 = string2 + arrayList.get(k);
                    string3 = string3 + arrayList.get(k);
                    if (k == arrayList.size() - 1) continue;
                    string2 = string2 + ",";
                    string3 = string3 + ",";
                }
                string2 = string2 + "\t";
                string3 = string3 + "\t";
                string2 = string2 + "+";
                string3 = string3 + "<";
                string2 = string2 + "\t";
                string3 = string3 + "\t";
                string2 = string2 + "?";
                string3 = string3 + "?";
                this.description.add(string2);
                this.description.add(string3);
            }
        }
    }

    private void fillBuffers(Registry registry) throws MTGError.MTGExportException {
        Node node = registry.getProjectGraph().getRoot();
        for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
            if (edge.getSource() != node || edge.getTarget() == node) continue;
            node = edge.getTarget();
            break;
        }
        this.initStatesStacks();
        this.traverseGraph(node, true);
        this.clearStatesStacks();
        this.initContentBufferMtg();
        this.traverseGraph(node, false);
        this.fillBufferDescription();
    }

    private void pushStack(Node node, int n) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < this.latest.size(); ++i) {
            arrayList.add(this.latest.get(i));
        }
        this.stack.add(arrayList);
        this.stackLastTrav.add(new Integer(n));
    }

    private void popStack() {
        int n;
        if (this.stack.size() <= 0) {
            return;
        }
        ArrayList<Node> arrayList = this.stack.get(this.stack.size() - 1);
        this.stack.remove(this.stack.size() - 1);
        for (n = 0; n < arrayList.size(); ++n) {
            if (this.latest.size() - 1 < n) {
                this.latest.add(null);
            }
            this.latest.set(n, arrayList.get(n));
        }
        if (this.latest.size() > arrayList.size()) {
            this.scale = arrayList.size() - 1;
            for (n = this.latest.size() - 1; n > arrayList.size() - 1; --n) {
                this.latest.remove(n);
            }
        }
        this.scale = arrayList.size() - 1;
    }

    private int popStackLastTrav() {
        if (this.stackLastTrav.size() <= 0) {
            return -1;
        }
        int n = this.stackLastTrav.get(this.stackLastTrav.size() - 1);
        this.stackLastTrav.remove(this.stackLastTrav.size() - 1);
        return n;
    }

    private void traverseGraph(Node node, boolean bl) throws MTGError.MTGExportException {
        Node node2 = node;
        int n = 4096;
        int n2 = 0;
        boolean bl2 = false;
        while (node2 != null) {
            Edge edge;
            if (!bl2) {
                this.traverseNode(n, node2, bl);
            } else {
                bl2 = false;
            }
            boolean bl3 = false;
            for (Edge edge2 = node2.getFirstEdge(); edge2 != null; edge2 = edge2.getNext(node2)) {
                if (!edge2.testEdgeBits(4096) || edge2.getSource() != node2) continue;
                node2 = edge2.getTarget();
                n = 4096;
                ++this.scale;
                bl3 = true;
                break;
            }
            if (bl3) continue;
            int n3 = 0;
            for (edge = node2.getFirstEdge(); edge != null; edge = edge.getNext(node2)) {
                if (!edge.testEdgeBits(512) || edge.getSource() != node2) continue;
                ++n3;
                if (n2 > 0) {
                    --n2;
                    continue;
                }
                this.pushStack(edge.getTarget(), n3);
                node2 = edge.getTarget();
                n = 512;
                bl3 = true;
                break;
            }
            if (bl3) {
                n2 = 0;
                continue;
            }
            for (edge = node2.getFirstEdge(); edge != null; edge = edge.getNext(node2)) {
                if (!edge.testEdgeBits(256) || edge.getSource() != node2) continue;
                node2 = edge.getTarget();
                n = 256;
                bl3 = true;
                break;
            }
            if (bl3) {
                n2 = 0;
                continue;
            }
            this.popStack();
            n2 = this.popStackLastTrav();
            bl2 = true;
            if (node2 == this.latest.get(this.latest.size() - 1)) {
                node2 = null;
                continue;
            }
            node2 = this.latest.get(this.latest.size() - 1);
        }
    }

    private void incrementSymbolCode() throws MTGError.MTGExportException {
        ++this.symbolCode;
        if (this.symbolCode == 91) {
            this.symbolCode = 97;
        }
        if (this.symbolCode > 122) {
            throw new MTGError.MTGExportException("Insufficient default class symbols.");
        }
    }

    private String getNextSymbolCode() throws MTGError.MTGExportException {
        String string = Character.toString((char)this.symbolCode);
        this.incrementSymbolCode();
        while (this.hasAssignedClass(string) != -1) {
            string = Character.toString((char)this.symbolCode);
            this.incrementSymbolCode();
        }
        return string;
    }

    private String getMTGClassName(String string) throws MTGError.MTGExportException {
        if (string == null) {
            throw new MTGError.MTGExportException("GroIMP class name is null.");
        }
        if (string.length() == 0) {
            throw new MTGError.MTGExportException("GroIMP class name is empty string.");
        }
        if (string.contains("mtg_") && string.length() == 5 && string.substring(4, 5).matches("[a-zA-Z$]")) {
            String string2 = string.substring(4, 5);
            if (this.hasAssignedClass(string2) != -1) {
                return this.getNextSymbolCode();
            }
            return string2;
        }
        char c = string.charAt(0);
        if (Character.toString(c).matches("[a-zA-Z$]")) {
            String string3 = string.substring(0, 1);
            if (this.hasAssignedClass(string3) != -1) {
                return this.getNextSymbolCode();
            }
            return string3;
        }
        return this.getNextSymbolCode();
    }

    private void addBufferClass(String string, int n) {
        int n2;
        int n3 = this.classes.size();
        if (n3 - 1 < n) {
            for (n2 = 0; n2 < n - (n3 - 1); ++n2) {
                this.classes.add(new ArrayList());
            }
        }
        this.classes.get(n).add(string + "\t" + n + "\tFREE\tFREE\tEXPLICIT");
        n3 = this.classesMTG.size();
        if (n3 - 1 < n) {
            for (n2 = 0; n2 < n - (n3 - 1); ++n2) {
                this.classesMTG.add(new ArrayList());
            }
        }
        this.classesMTG.get(n).add(string);
    }

    private boolean isStandardAttributeSet(Node node, String string) throws MTGError.MTGExportException {
        boolean bl = false;
        boolean bl2 = MTGKeys.isStandardAttribute(string);
        if (bl2) {
            Node.NType nType = node.getNType();
            boolean bl3 = false;
            String string2 = "has" + string;
            try {
                while (!bl3) {
                    int n = nType.getDeclaredMethodCount();
                    for (int i = 0; i < n; ++i) {
                        Method method = nType.getDeclaredMethod(i);
                        String string3 = method.getName();
                        if (!method.getName().equals(string2)) continue;
                        Object[] objectArray = new Object[]{};
                        bl = (Boolean)method.invoke((Object)node, objectArray);
                        bl3 = true;
                    }
                    if ((nType = nType.getSupertype()) != null) continue;
                    throw new MTGError.MTGExportException("Unable to find flag indicator for standard MTG attribute.");
                }
                return bl;
            }
            catch (Throwable throwable) {
                throw new MTGError.MTGExportException("Error obtaining attribute value.");
            }
        }
        return false;
    }

    private void addFeatures(Node node) throws MTGError.MTGExportException {
        Node.NType nType = node.getNType();
        int n = nType.getManagedFieldCount();
        for (int i = 0; i < n; ++i) {
            int n2;
            ManageableType.Field field = nType.getManagedField(i);
            Type type = field.getType();
            String string = type.getName();
            String string2 = field.getName();
            String string3 = MTGKeys.javaTypeToMTGType(string);
            if (string3 == null) continue;
            boolean bl = false;
            for (n2 = 0; n2 < this.fieldsGroIMP.size(); ++n2) {
                if (!this.fieldsGroIMP.get(n2).equals(string2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            n2 = 0;
            boolean bl2 = MTGKeys.isStandardAttribute(string2);
            if (bl2) {
                n2 = this.isStandardAttributeSet(node, string2) ? 1 : 0;
            }
            if ((!bl2 || n2 == 0) && bl2) continue;
            this.fieldsGroIMP.add(string2);
            this.features.add(string2 + "\t" + string3);
        }
    }

    private void addBufferMtg(Node node, int n, int n2, boolean bl) throws MTGError.MTGExportException {
        int n3;
        String string = this.addClass(node.getNType().getSimpleName(), n2);
        String string2 = "";
        for (int i = 0; i < this.stack.size(); ++i) {
            string2 = string2 + "\t";
        }
        if ((n != 512 || n == 512 && !bl) && this.latest.size() > 0) {
            string2 = string2 + "^";
        }
        if (bl) {
            String string3 = MTGKeys.edgeBitToSymbol(n);
            if (string3 == null) {
                throw new MTGError.MTGExportException("Unrecognized edge type.");
            }
            string2 = string2 + string3;
        } else {
            string2 = string2 + "/";
        }
        string2 = string2 + string;
        string2 = string2 + Integer.toString(this.nextNodeId());
        int n4 = this.maxStackSize + 1 - this.stack.size();
        for (n3 = 0; n3 < n4; ++n3) {
            string2 = string2 + "\t";
        }
        for (n3 = 0; n3 < this.fieldsGroIMP.size(); ++n3) {
            String string4 = this.fieldsGroIMP.get(n3);
            Node.NType nType = node.getNType();
            int n5 = nType.getManagedFieldCount();
            for (int i = 0; i < n5; ++i) {
                ManageableType.Field field = nType.getManagedField(i);
                Type type = field.getType();
                String string5 = type.getName();
                String string6 = field.getName();
                if (!string6.equals(string4)) continue;
                try {
                    boolean bl2 = false;
                    boolean bl3 = MTGKeys.isStandardAttribute(string4);
                    if (bl3) {
                        bl2 = this.isStandardAttributeSet(node, string4);
                    }
                    if ((!bl3 || !bl2) && bl3) continue;
                    if (string5.equals("int")) {
                        string2 = string2 + field.getInt((Object)node);
                    }
                    if (string5.equals("double")) {
                        string2 = string2 + field.getDouble((Object)node);
                    }
                    if (!string5.equals("String")) continue;
                    string2 = string2 + (String)field.getObject((Object)node);
                    continue;
                }
                catch (Throwable throwable) {
                    throw new MTGError.MTGExportException("Error obtaining attribute value.");
                }
            }
            string2 = string2 + "\t";
        }
        this.mtg.add(string2);
    }

    private String addClass(String string, int n) throws MTGError.MTGExportException {
        int n2 = this.hasEncounteredClass(string, n);
        String string2 = null;
        if (n2 == -1) {
            string2 = this.getMTGClassName(string);
            int n3 = this.classesGroIMP.size();
            if (n3 - 1 < n) {
                for (int i = 0; i < n - (n3 - 1); ++i) {
                    this.classesGroIMP.add(new ArrayList());
                }
            }
            this.classesGroIMP.get(n).add(string);
            this.addBufferClass(string2, n);
        } else {
            if (n2 == -2) {
                throw new MTGError.MTGExportException("Same module name in different scales. Error exporting.");
            }
            if (n2 >= this.classesGroIMP.get(n).size()) {
                throw new MTGError.MTGExportException("No corresponding MTG class symbol for GroIMP module name");
            }
            string2 = this.classesMTG.get(n).get(n2);
        }
        return string2;
    }

    private void setLatestTrav(Node node, int n) {
        if (this.latest.size() - 1 < n) {
            int n2 = this.latest.size();
            for (int i = 0; i < n - (n2 - 1); ++i) {
                this.latest.add(null);
            }
        }
        this.latest.set(n, node);
    }

    private void traverseNode(int n, Node node, boolean bl) throws MTGError.MTGExportException {
        boolean bl2 = false;
        if (this.scale > 1) {
            for (int i = 1; i < this.scale; ++i) {
                Edge edge;
                Node node2 = node;
                int n2 = this.scale - i;
                block1: while (n2 > 0) {
                    for (edge = node2.getFirstEdge(); edge != null; edge = edge.getNext(node2)) {
                        if (edge.getTarget() != node2 || !edge.testEdgeBits(4096)) continue;
                        node2 = edge.getSource();
                        --n2;
                        continue block1;
                    }
                }
                if (this.latest.size() - 1 < i || (edge = this.latest.get(i)) == node2) continue;
                if (!bl) {
                    this.addBufferMtg(node2, n, i, !bl2);
                } else {
                    this.addFeatures(node2);
                    if (this.stack.size() > this.maxStackSize) {
                        this.maxStackSize = this.stack.size();
                    }
                }
                this.setLatestTrav(node2, i);
                bl2 = true;
            }
        }
        if (!bl) {
            this.addBufferMtg(node, n, this.scale, !bl2);
        } else {
            this.addFeatures(node);
            if (this.stack.size() > this.maxStackSize) {
                this.maxStackSize = this.stack.size();
            }
        }
        this.setLatestTrav(node, this.scale);
    }

    private int hasEncounteredClass(String string, int n) {
        if (this.classesGroIMP.size() - 1 >= n) {
            for (int i = 0; i < this.classesGroIMP.size(); ++i) {
                for (int j = 0; j < this.classesGroIMP.get(i).size(); ++j) {
                    if (!this.classesGroIMP.get(i).get(j).equals(string)) continue;
                    if (i == n) {
                        return j;
                    }
                    return -2;
                }
            }
        }
        return -1;
    }

    private int hasAssignedClass(String string) {
        for (int i = 0; i < this.classesMTG.size(); ++i) {
            if (!this.classesMTG.get(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    private void writeBuffers(OutputStream outputStream) throws IOException {
        int n;
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        for (n = 0; n < this.code.size(); ++n) {
            outputStreamWriter.write(this.code.get(n) + "\n");
        }
        outputStreamWriter.write("\n");
        for (n = 0; n < this.classes.size(); ++n) {
            ArrayList<String> arrayList = this.classes.get(n);
            for (int i = 0; i < arrayList.size(); ++i) {
                outputStreamWriter.write(arrayList.get(i) + "\n");
            }
        }
        outputStreamWriter.write("\n");
        for (n = 0; n < this.description.size(); ++n) {
            outputStreamWriter.write(this.description.get(n) + "\n");
        }
        outputStreamWriter.write("\n");
        for (n = 0; n < this.features.size(); ++n) {
            outputStreamWriter.write(this.features.get(n) + "\n");
        }
        outputStreamWriter.write("\n");
        for (n = 0; n < this.mtg.size(); ++n) {
            outputStreamWriter.write(this.mtg.get(n) + "\n");
        }
        outputStreamWriter.close();
    }

    public void write(File file) throws IOException {
        Registry registry = this.workbench.getRegistry();
        try {
            this.fillBuffers(registry);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.writeBuffers(fileOutputStream);
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected SceneTree createSceneTree(View3D view3D) {
        return null;
    }

    protected void beginGroup(SceneTree.InnerNode innerNode) throws IOException {
    }

    protected void endGroup(SceneTree.InnerNode innerNode) throws IOException {
    }
}

