/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.mtg;

import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.Node;
import de.grogra.mtg.MTGError;
import de.grogra.mtg.MTGGraphBuilderBodyData;
import de.grogra.mtg.MTGGraphBuilderHeaderAttributes;
import de.grogra.mtg.MTGGraphBuilderHeaderClasses;
import de.grogra.mtg.MTGGraphBuilderHeaderCode;
import de.grogra.mtg.MTGGraphBuilderHeaderTopo;
import de.grogra.mtg.MTGNode;
import de.grogra.mtg.MTGRoot;
import java.util.ArrayList;

public class MTGGraphBuilder {
    private MTGNode rootNode = new MTGRoot();
    private ArrayList<MTGNode> nodes;
    private int stage;
    protected static final int MTG_HEADER_CODE = 0;
    protected static final int MTG_HEADER_CLASSES = 1;
    protected static final int MTG_HEADER_TOPO = 2;
    protected static final int MTG_HEADER_ATTRIBUTES = 3;
    protected static final int MTG_BODY_DATA = 4;
    private MTGGraphBuilderHeaderCode builderHeaderCode;
    private MTGGraphBuilderHeaderClasses builderHeaderClasses;
    private MTGGraphBuilderHeaderTopo builderHeaderTopo;
    private MTGGraphBuilderHeaderAttributes builderHeaderAttributes;
    private MTGGraphBuilderBodyData builderBodyData;
    private String systemId;
    private boolean createModules;

    public MTGGraphBuilder(String string) {
        this.systemId = string;
        this.nodes = new ArrayList();
        this.createModules = false;
        this.builderHeaderCode = new MTGGraphBuilderHeaderCode(this.rootNode);
        this.builderHeaderClasses = new MTGGraphBuilderHeaderClasses(this.rootNode);
        this.builderHeaderTopo = new MTGGraphBuilderHeaderTopo(this.rootNode);
        this.builderHeaderAttributes = new MTGGraphBuilderHeaderAttributes(this.rootNode);
        this.builderBodyData = new MTGGraphBuilderBodyData(this.rootNode, this.nodes);
    }

    protected MTGNode getMTGRootNode() {
        return this.rootNode;
    }

    public MTGNode getFirstNode() {
        return this.rootNode;
    }

    private void removeRootLinks() {
        for (Edge edge = this.rootNode.getFirstEdge(); edge != null; edge = edge.getNext((Node)this.rootNode)) {
            if (edge.getSource() == this.rootNode) {
                this.rootNode.removeEdgeBitsTo(edge.getTarget(), edge.getEdgeBits(), null);
            }
            if (edge.getTarget() != this.rootNode) continue;
            edge.getSource().removeEdgeBitsTo((Node)this.rootNode, edge.getEdgeBits(), null);
        }
    }

    public long getMTGNodeCount() {
        return this.nodes.size();
    }

    public long getStage() {
        return this.stage;
    }

    public void storeNodeListInRoot() {
        ((MTGRoot)this.rootNode).setObject("Node List", this.nodes);
    }

    public void removeInterScaleTopoRelations() throws MTGError.MTGPlantFrameException {
        ((MTGRoot)this.rootNode).removeInterScaleTopoRelations();
    }

    public boolean processTokens(String[] stringArray) throws MTGError.MTGGraphBuildException {
        boolean bl = false;
        switch (this.stage) {
            case 0: {
                if (this.builderHeaderCode.processTokensHeaderCode(stringArray) != 2) break;
                this.stage = 1;
                break;
            }
            case 1: {
                if (this.builderHeaderClasses.processTokensHeaderClasses(stringArray) != 3) break;
                this.stage = 2;
                bl = true;
                break;
            }
            case 2: {
                if (this.builderHeaderTopo.processTokensHeaderTopo(stringArray) != 3) break;
                this.stage = 3;
                bl = true;
                break;
            }
            case 3: {
                if (this.builderHeaderAttributes.processTokensHeaderAttributes(stringArray) != 3) break;
                this.stage = 4;
                bl = true;
                return true;
            }
            case 4: {
                this.builderBodyData.processTokensBodyData(stringArray);
                break;
            }
            default: {
                throw new MTGError.MTGGraphBuildException("Unknown MTG File section.");
            }
        }
        if (bl) {
            this.processTokens(stringArray);
        }
        return false;
    }

    public void removeTypes() {
        ((MTGRoot)this.rootNode).setObject("RGGModules", null);
    }
}

