/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.mtg;

import de.grogra.graph.impl.Node;
import de.grogra.mtg.MTGError;
import de.grogra.mtg.MTGKeys;
import de.grogra.mtg.MTGNode;
import de.grogra.mtg.MTGNodeDataClasses;
import de.grogra.mtg.MTGNodeDataFeature;
import de.grogra.mtg.MTGRoot;
import de.grogra.mtg.MTGTokenizer;
import de.grogra.persistence.PersistenceCapable;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.TypeItem;
import de.grogra.reflect.Method;
import de.grogra.reflect.Type;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.vecmath.Vector3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTGGraphBuilderBodyData {
    protected static final int MTG_BODY_STAGE_MTG = 0;
    protected static final int MTG_BODY_STAGE_COLUMN_HEADERS = 1;
    protected static final int MTG_BODY_STAGE_INFO = 2;
    int stage = 0;
    MTGNode rootNode;
    ArrayList<MTGNode> nodes;
    HashMap<Integer, MTGNode> lastNodeTraversedEachScale;
    ArrayList<String> lastTokensAtTabs;
    ArrayList<String> traverseBuffer;
    int tabCount;
    int tabCountBetweenKeyword;
    int infoLineCount;
    int[] nodesWithData;
    HashMap<String, Object> featureData;
    int currEdgeTypeIndex;
    String currEntityClassChar;
    int currEntityClassIndex;
    int currEntityIndex;
    int currEntityClassScale;
    int prevEdgeTypeIndex;
    String prevEntityClassChar;
    int prevEntityClassIndex;
    int prevEntityIndex;
    int prevEntityClassScale;
    int lastSuccOrBran;

    public MTGGraphBuilderBodyData(MTGNode mTGNode, ArrayList<MTGNode> arrayList) {
        this.rootNode = mTGNode;
        this.nodes = arrayList;
        this.tabCount = 0;
        this.infoLineCount = 0;
        this.nodesWithData = null;
        this.tabCountBetweenKeyword = 0;
        this.lastNodeTraversedEachScale = new HashMap();
        this.lastNodeTraversedEachScale.put(new Integer(0), mTGNode);
        this.lastTokensAtTabs = new ArrayList();
        this.traverseBuffer = new ArrayList();
        this.lastSuccOrBran = -1;
    }

    private void processMTG(String[] stringArray) throws MTGError.MTGGraphBuildException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.equals("MTG") && !string.equals("MTG:")) continue;
            this.stage = 1;
        }
    }

    private void processColumnHeaders(String[] stringArray) throws MTGError.MTGGraphBuildException {
        int n;
        Object object = ((MTGRoot)this.rootNode).getObject("FEATURES");
        ArrayList arrayList = object == null ? null : (ArrayList)object;
        int n2 = -1;
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            if (string.equals("\t")) continue;
            if (!string.equals("ENTITY-CODE")) {
                throw new MTGError.MTGGraphBuildException("Expected Identifier 'ENTITY-CODE' in MTG File Body section not found.");
            }
            n2 = n;
            break;
        }
        if (n2 == -1) {
            return;
        }
        this.tabCountBetweenKeyword = 0;
        if (arrayList != null) {
            if (stringArray.length - n2 - 1 < arrayList.size() * 2 - 1) {
                throw new MTGError.MTGGraphBuildException("Expected number of column headers in MTG File Body section not found.");
            }
            n = 0;
            for (int i = n2 + 1; i < stringArray.length; ++i) {
                if (stringArray[i].equals("\t")) {
                    if (n != 0) continue;
                    ++this.tabCountBetweenKeyword;
                    continue;
                }
                if (n != 0) {
                    throw new MTGError.MTGGraphBuildException("Unexpected token in MTG File - Body - Column headers section not found.");
                }
                if (arrayList == null) continue;
                int n3 = arrayList.size();
                for (int j = 0; j < n3; ++j) {
                    if (!stringArray[i + j * 2].equals(((MTGNodeDataFeature)arrayList.get(j)).getFeatureName())) {
                        throw new MTGError.MTGGraphBuildException("Expected feature name in MTG File - Body - Column headers section not found.");
                    }
                    if (j == n3 - 1 || stringArray[i + j * 2 + 1].equals("\t")) continue;
                    throw new MTGError.MTGGraphBuildException("Unacceptable separating token in MTG File - Body - Column headers section not found.");
                }
                i = i + n3 * 2 - 1;
                n = 1;
            }
        }
        this.stage = 2;
    }

    private int countHeadingTabCharacters(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length && stringArray[i].equals("\t"); ++i) {
            ++n;
        }
        return n;
    }

    private ArrayList<MTGNodeDataClasses> getClassesInfo() throws MTGError.MTGGraphBuildException {
        try {
            return ((MTGRoot)this.rootNode).getClassesInfo();
        }
        catch (MTGError.MTGPlantFrameException mTGPlantFrameException) {
            throw new MTGError.MTGGraphBuildException("Expected class information in MTG root node not found.");
        }
    }

    private MTGNode createNewNodeType(String string) throws MTGError.MTGGraphBuildException {
        Registry registry = Registry.current();
        Item item = registry.getItem("/classes");
        for (Item item2 = (Item)item.getBranch(); item2 != null; item2 = (Item)item2.getSuccessor()) {
            if (!item2.getName().contains(MTGKeys.getGeneratedModuleName(string))) continue;
            Type type = (Type)((TypeItem)item2).getObject();
            try {
                MTGNode mTGNode = (MTGNode)type.newInstance();
                long l = registry.getProjectGraph().prepareId((PersistenceCapable)mTGNode);
                registry.getProjectGraph().makePersistent((PersistenceCapable)mTGNode, l, null);
                return mTGNode;
            }
            catch (InstantiationException instantiationException) {
                throw new MTGError.MTGGraphBuildException("Missing RGG module equivalent to MTG class.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MTGError.MTGGraphBuildException("Missing RGG module equivalent to MTG class.");
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new MTGError.MTGGraphBuildException("Missing RGG module equivalent to MTG class.");
            }
        }
        throw new MTGError.MTGGraphBuildException("Missing RGG module equivalent to MTG class.");
    }

    private int getEntityClassIndex(String string) throws MTGError.MTGGraphBuildException {
        this.currEntityClassChar = string.substring(0, 1);
        int n = ((MTGRoot)this.rootNode).classSymbolToClassIndex(this.currEntityClassChar);
        return n;
    }

    private int getEntityIndex(String string) {
        String string2 = string.substring(1, string.length());
        int n = -1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return n;
    }

    private int getEntityClassScale(int n) throws MTGError.MTGGraphBuildException {
        ArrayList<MTGNodeDataClasses> arrayList = this.getClassesInfo();
        MTGNodeDataClasses mTGNodeDataClasses = arrayList.get(n);
        return mTGNodeDataClasses.getScale();
    }

    private Object castFeatureValueStringToDataType(String string, int n) throws MTGError.MTGGraphBuildException {
        try {
            switch (n) {
                case 0: {
                    return Integer.parseInt(string);
                }
                case 1: {
                    return Double.parseDouble(string);
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    return string;
                }
            }
        }
        catch (Throwable throwable) {
            throw new MTGError.MTGGraphBuildException("Unable to cast feature value to specified feature data type.");
        }
        return null;
    }

    private void setStandardFeatureValue(MTGNode mTGNode, Object object, String string, int n) throws MTGError.MTGGraphBuildException {
        double d = 0.0;
        int n2 = 0;
        if (n == 0) {
            n2 = (Integer)object;
            d = MTGKeys.integerToDouble(object);
        }
        if (n == 1) {
            n2 = MTGKeys.doubleToInt(object);
            d = (Double)object;
        }
        if (n == 1 || n == 0) {
            if (string.equals("L1")) {
                mTGNode.L1 = d;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("L1"));
            } else if (string.equals("L2")) {
                mTGNode.L2 = d;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("L2"));
            } else if (string.equals("L3")) {
                mTGNode.L3 = d;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("L3"));
            } else if (string.equals("DAB")) {
                mTGNode.DAB = d;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("DAB"));
            } else if (string.equals("DAC")) {
                mTGNode.DAC = d;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("DAC"));
            } else if (string.equals("DBC")) {
                mTGNode.DBC = d;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("DBC"));
            } else if (string.equals("XX")) {
                mTGNode.XX = d;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("XX"));
            } else if (string.equals("YY")) {
                mTGNode.YY = d;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("YY"));
            } else if (string.equals("ZZ")) {
                mTGNode.ZZ = d;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("ZZ"));
            } else if (string.equals("Length")) {
                mTGNode.Length = d;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("Length"));
            } else if (string.equals("Azimut")) {
                mTGNode.Azimut = d;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("Azimut"));
            } else if (string.equals("Alpha")) {
                mTGNode.Alpha = d;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("Alpha"));
            } else if (string.equals("AA")) {
                mTGNode.AA = d;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("AA"));
            } else if (string.equals("BB")) {
                mTGNode.BB = d;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("BB"));
            } else if (string.equals("CC")) {
                mTGNode.CC = d;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("CC"));
            } else if (string.equals("TopDia")) {
                mTGNode.TopDia = d;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("TopDia"));
            } else if (string.equals("BotDia")) {
                mTGNode.BotDia = d;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("BotDia"));
            } else if (string.equals("Position")) {
                mTGNode.Position = d;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("Position"));
            } else if (string.equals("Category")) {
                mTGNode.Category = n2;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("Category"));
            } else if (string.equals("Order")) {
                mTGNode.Order = n2;
                mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("Order"));
            }
        }
        if (string.equals("DirectionPrimary")) {
            mTGNode.setDirectoryPrimary((Vector3d)object);
            mTGNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask("DirectionPrimary"));
        }
    }

    private void addFeatureValuesToNodes() throws MTGError.MTGGraphBuildException {
        if (this.featureData == null || this.nodesWithData == null) {
            return;
        }
        if (this.featureData.size() == 0) {
            return;
        }
        if (this.nodesWithData.length == 0) {
            return;
        }
        Object object = ((MTGRoot)this.rootNode).getObject("FEATURES");
        ArrayList arrayList = object == null ? null : (ArrayList)object;
        try {
            for (int i = 0; i < this.nodesWithData.length; ++i) {
                if (i == this.nodesWithData.length - 1) continue;
                int n = this.nodesWithData[i];
                if (n >= this.nodes.size() || n < 0) {
                    throw new MTGError.MTGGraphBuildException("Unable to load data into node with unexpected index.");
                }
                MTGNode mTGNode = this.nodes.get(n);
                if (mTGNode == null) {
                    throw new MTGError.MTGGraphBuildException("Unable to load data into node that does not exist.");
                }
                if (arrayList.size() > 0 && this.featureData.size() > 0) {
                    mTGNode.dataFlag = 1;
                }
                block9: for (int j = 0; j < arrayList.size(); ++j) {
                    MTGNodeDataFeature mTGNodeDataFeature = (MTGNodeDataFeature)arrayList.get(j);
                    int n2 = mTGNodeDataFeature.getFeatureTypeIndex();
                    String string = mTGNodeDataFeature.getFeatureName();
                    Object object2 = this.featureData.get(string);
                    if (MTGKeys.isStandardAttribute(string)) {
                        if (object2 == null) continue;
                        this.setStandardFeatureValue(mTGNode, object2, string, n2);
                        continue;
                    }
                    Registry registry = Registry.current();
                    Item item = registry.getItem("/classes");
                    String string2 = mTGNode.mtgClass;
                    boolean bl = false;
                    boolean bl2 = false;
                    for (Item item2 = (Item)item.getBranch(); item2 != null; item2 = (Item)item2.getSuccessor()) {
                        if (item2.getName().contains(MTGKeys.getGeneratedModuleName(string2))) {
                            Type type = (Type)((TypeItem)item2).getObject();
                            int n3 = type.getDeclaredMethodCount();
                            for (int k = 0; k < n3; ++k) {
                                Object[] objectArray;
                                Method method = type.getDeclaredMethod(k);
                                if (method.getName().equals("set" + mTGNodeDataFeature.getFeatureName())) {
                                    objectArray = new Object[1];
                                    if (object2 != null) {
                                        objectArray[0] = object2;
                                    } else {
                                        switch (n2) {
                                            case 0: {
                                                objectArray[0] = 0;
                                                break;
                                            }
                                            case 1: {
                                                objectArray[0] = 0.0;
                                                break;
                                            }
                                            case 2: 
                                            case 11: {
                                                objectArray[0] = "";
                                                break;
                                            }
                                            case 3: 
                                            case 4: 
                                            case 5: 
                                            case 6: 
                                            case 7: 
                                            case 8: 
                                            case 9: 
                                            case 10: {
                                                objectArray[0] = "";
                                                break;
                                            }
                                            default: {
                                                throw new MTGError.MTGGraphBuildException("Unable to initialize value for unknown feature value type.");
                                            }
                                        }
                                    }
                                    method.invoke((Object)mTGNode, objectArray);
                                    bl = true;
                                }
                                if (method.getName().equals("setHas" + mTGNodeDataFeature.getFeatureName())) {
                                    objectArray = new Object[]{object2 != null ? Boolean.valueOf(true) : Boolean.valueOf(false)};
                                    method.invoke((Object)mTGNode, objectArray);
                                    bl2 = true;
                                }
                                if (bl && bl2) break;
                            }
                        }
                        if (bl && bl2) continue block9;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throw new MTGError.MTGGraphBuildException("Unable to load feature value in nodes.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processFeatureValues(String[] stringArray, int n) throws MTGError.MTGGraphBuildException {
        if (this.featureData != null) {
            this.featureData.clear();
        } else {
            this.featureData = new HashMap();
        }
        Object object = ((MTGRoot)this.rootNode).getObject("FEATURES");
        ArrayList arrayList = object == null ? null : (ArrayList)object;
        int n2 = 0;
        if (arrayList != null) {
            n2 = arrayList.size();
        }
        if (n2 == 0) {
            while (n < stringArray.length) {
                if (!stringArray[n].equals("\t")) {
                    throw new MTGError.MTGGraphBuildException("Unexpected feature value in MTG Body section.");
                }
                ++n;
            }
            return;
        }
        int n3 = 0;
        int n4 = this.tabCountBetweenKeyword - this.tabCount;
        while (n < stringArray.length) {
            if (n4 > 0) {
                if (!stringArray[n].equals("\t")) throw new MTGError.MTGGraphBuildException("Incorrect number of tabs between entity-code and feature value.");
                --n4;
            } else if (stringArray[n].equals("\t")) {
                ++n3;
            } else {
                MTGNodeDataFeature mTGNodeDataFeature = (MTGNodeDataFeature)arrayList.get(n3);
                if (mTGNodeDataFeature == null) {
                    throw new MTGError.MTGGraphBuildException("No matching feature for data value.");
                }
                int n5 = mTGNodeDataFeature.getFeatureTypeIndex();
                this.featureData.put(mTGNodeDataFeature.getFeatureName(), this.castFeatureValueStringToDataType(stringArray[n], n5));
            }
            ++n;
        }
        this.addFeatureValuesToNodes();
    }

    private String assembleEntityFullNameSub(String string, int n, boolean bl) throws MTGError.MTGGraphBuildException {
        String string2 = new String("");
        if (this.lastTokensAtTabs.size() - 1 < n) {
            if (this.lastTokensAtTabs.size() >= 1) {
                string2 = this.lastTokensAtTabs.get(this.lastTokensAtTabs.size() - 1);
            }
        } else {
            string2 = this.lastTokensAtTabs.get(n);
        }
        if (bl) {
            return string2 + string.substring(1, string.length());
        }
        return string2 + string;
    }

    private String assembleEntityFullName(String string) throws MTGError.MTGGraphBuildException {
        if (this.tabCount == 0 && string.charAt(0) != '^') {
            return string;
        }
        if (string.charAt(0) == '^') {
            return this.assembleEntityFullNameSub(string, this.tabCount, true);
        }
        return this.assembleEntityFullNameSub(string, this.tabCount - 1, false);
    }

    private int getNextEdgeSymbol(String[] stringArray, int n) throws MTGError.MTGGraphBuildException {
        if (stringArray[n].equals("<")) {
            if (n < stringArray.length - 1 && stringArray[n + 1].equals("<")) {
                return 3;
            }
            if (n < stringArray.length - 2 && stringArray[n + 1].equals(".") && stringArray[n + 2].equals("<")) {
                return 5;
            }
            return 0;
        }
        if (stringArray[n].equals("+")) {
            if (n < stringArray.length - 1 && stringArray[n + 1].equals("+")) {
                return 4;
            }
            if (n < stringArray.length - 2 && stringArray[n + 1].equals(".") && stringArray[n + 2].equals("+")) {
                return 6;
            }
            return 1;
        }
        if (stringArray[n].equals("/")) {
            return 2;
        }
        throw new MTGError.MTGGraphBuildException("Expected edge connection symbol not found.");
    }

    private int getNextEntity(String[] stringArray, int n) throws MTGError.MTGGraphBuildException {
        String string = new String();
        int n2 = 0;
        switch (this.currEdgeTypeIndex) {
            case 0: 
            case 1: 
            case 2: {
                string = stringArray[n + 1];
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                string = stringArray[n + 2];
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                string = stringArray[n + 3];
                n2 = 4;
                break;
            }
            default: {
                throw new MTGError.MTGGraphBuildException("Unknown edge type.");
            }
        }
        this.currEntityClassIndex = this.getEntityClassIndex(string);
        this.currEntityIndex = this.getEntityIndex(string);
        this.currEntityClassScale = this.getEntityClassScale(this.currEntityClassIndex);
        if (this.currEntityClassIndex == -1 || this.currEntityIndex == -1) {
            throw new MTGError.MTGGraphBuildException("Undeclared entity class used.");
        }
        return n2;
    }

    private MTGNode previousNodeTraversed() {
        return this.lastNodeTraversedEachScale.get(new Integer(this.prevEntityClassScale));
    }

    private void addLastNodeToNodesWithData() {
        this.nodesWithData = new int[2];
        this.nodesWithData[0] = this.nodes.size() - 1;
        MTGNode mTGNode = this.lastNodeTraversedEachScale.get(new Integer(this.currEntityClassScale - 1));
        this.nodesWithData[1] = mTGNode.mtgID;
    }

    private void addToNodeList(MTGNode mTGNode, String string, int n, int n2) throws MTGError.MTGGraphBuildException {
        this.nodes.add(mTGNode);
        mTGNode.mtgClass = string;
        mTGNode.mtgClassID = n;
        mTGNode.mtgID = n2;
        ArrayList<MTGNodeDataClasses> arrayList = this.getClassesInfo();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = mTGNode.mtgClass;
            if (!arrayList.get(i).getSymbol().equals(string2)) continue;
            mTGNode.mtgScale = arrayList.get(i).getScale();
        }
    }

    private void traverseSuccBranMany(boolean bl, boolean bl2, boolean bl3) throws MTGError.MTGGraphBuildException {
        int n = this.prevEntityIndex + 1;
        int n2 = this.currEntityIndex;
        if (n == n2) {
            this.traverseSuccBran(bl, bl2);
            return;
        }
        if (this.prevEntityClassIndex != this.currEntityClassIndex) {
            throw new MTGError.MTGGraphBuildException("Invalid usage of <<, ++, <.< or +.+ symbol. Entity class does not match.");
        }
        if (n > this.currEntityIndex) {
            throw new MTGError.MTGGraphBuildException("Invalid usage of <<, ++, <.< or +.+ symbol. Previous entity index same or larger than next entity index.");
        }
        int n3 = -1;
        n3 = this.currEdgeTypeIndex == 4 || this.currEdgeTypeIndex == 4 ? 1 : 0;
        String string = this.currEntityClassChar;
        int n4 = this.currEntityClassIndex;
        int n5 = this.currEntityClassScale;
        boolean bl4 = false;
        int n6 = n;
        while (n6 <= n2) {
            MTGNode mTGNode = this.previousNodeTraversed();
            if (mTGNode == null) {
                throw new MTGError.MTGGraphBuildException("Stack not updated with previous specified entity.");
            }
            MTGNode mTGNode2 = null;
            mTGNode2 = bl ? mTGNode.findAdjacentMTG(true, 256, this.currEntityClassChar, n6) : mTGNode.findAdjacentMTG(true, 512, this.currEntityClassChar, n6);
            if (mTGNode2 == null) {
                MTGNode mTGNode3 = this.createNewNodeType(string);
                this.addToNodeList(mTGNode3, string, n6, this.nodes.size());
                if (bl) {
                    mTGNode.addEdgeBitsTo((Node)mTGNode3, 256, null);
                } else {
                    mTGNode.addEdgeBitsTo((Node)mTGNode3, 512, null);
                }
                this.lastNodeTraversedEachScale.put(new Integer(n5), mTGNode3);
                int n7 = n5 - 1;
                MTGNode mTGNode4 = this.lastNodeTraversedEachScale.get(new Integer(n7));
                if (mTGNode4 != null) {
                    mTGNode4.addEdgeBitsTo((Node)mTGNode3, 4096, null);
                }
                bl4 = true;
            } else {
                this.lastNodeTraversedEachScale.put(new Integer(n5), mTGNode2);
            }
            this.prevEdgeTypeIndex = n3;
            this.prevEntityClassChar = string;
            this.prevEntityClassIndex = n4;
            this.prevEntityIndex = n6++;
            this.prevEntityClassScale = n5;
        }
        this.lastSuccOrBran = bl ? 0 : 1;
        if (bl2 && bl4) {
            if (this.currEdgeTypeIndex == 5 || this.currEdgeTypeIndex == 6) {
                this.nodesWithData = new int[this.currEntityIndex - this.prevEntityIndex + 1 + 1];
                for (int i = 0; i < this.nodesWithData.length; ++i) {
                    this.nodesWithData[i] = this.nodes.size() - 1 - i;
                }
                MTGNode mTGNode = this.lastNodeTraversedEachScale.get(new Integer(this.currEntityClassScale - 1));
                this.nodesWithData[this.nodesWithData.length - 1] = mTGNode.mtgID;
            } else if (this.currEdgeTypeIndex == 3 || this.currEdgeTypeIndex == 4) {
                this.addLastNodeToNodesWithData();
            }
        } else if (bl2 && !bl4) {
            throw new MTGError.MTGGraphBuildException("Repeated specification of attributes.");
        }
    }

    private void traverseSuccBran(boolean bl, boolean bl2) throws MTGError.MTGGraphBuildException {
        MTGNode mTGNode = this.previousNodeTraversed();
        if (mTGNode == null) {
            throw new MTGError.MTGGraphBuildException("Stack not updated with previous specified entity.");
        }
        MTGNode mTGNode2 = null;
        mTGNode2 = bl ? mTGNode.findAdjacentMTG(true, 256, this.currEntityClassChar, this.currEntityIndex) : mTGNode.findAdjacentMTG(true, 512, this.currEntityClassChar, this.currEntityIndex);
        if (mTGNode2 == null) {
            MTGNode mTGNode3;
            MTGNode mTGNode4 = this.createNewNodeType(this.currEntityClassChar);
            this.addToNodeList(mTGNode4, this.currEntityClassChar, this.currEntityIndex, this.nodes.size());
            if (bl) {
                mTGNode.addEdgeBitsTo((Node)mTGNode4, 256, null);
            } else {
                mTGNode.addEdgeBitsTo((Node)mTGNode4, 512, null);
            }
            int n = this.currEntityClassScale - 1;
            MTGNode mTGNode5 = this.lastNodeTraversedEachScale.get(new Integer(n));
            if (mTGNode5 != null) {
                mTGNode5.addEdgeBitsTo((Node)mTGNode4, 4096, null);
            }
            if (this.prevEntityClassScale != this.currEntityClassScale && (mTGNode3 = this.lastNodeTraversedEachScale.get(new Integer(this.currEntityClassScale))) != null) {
                if (bl) {
                    mTGNode3.addEdgeBitsTo((Node)mTGNode4, 256, null);
                } else {
                    mTGNode3.addEdgeBitsTo((Node)mTGNode4, 512, null);
                }
            }
            this.lastNodeTraversedEachScale.put(new Integer(this.currEntityClassScale), mTGNode4);
            if (bl2) {
                this.addLastNodeToNodesWithData();
            }
        } else {
            this.lastNodeTraversedEachScale.put(new Integer(this.currEntityClassScale), mTGNode2);
        }
        this.lastSuccOrBran = bl ? 0 : 1;
    }

    private void traverseRefine(boolean bl) throws MTGError.MTGGraphBuildException {
        MTGNode mTGNode = this.previousNodeTraversed();
        if (mTGNode == null) {
            throw new MTGError.MTGGraphBuildException("Stack not updated with previous specified entity.");
        }
        MTGNode mTGNode2 = mTGNode.findAdjacentMTG(true, 4096, this.currEntityClassChar, this.currEntityIndex);
        if (mTGNode2 == null) {
            MTGNode mTGNode3;
            MTGNode mTGNode4 = this.createNewNodeType(this.currEntityClassChar);
            this.addToNodeList(mTGNode4, this.currEntityClassChar, this.currEntityIndex, this.nodes.size());
            mTGNode.addEdgeBitsTo((Node)mTGNode4, 4096, null);
            if (this.lastSuccOrBran != -1 && (mTGNode3 = this.lastNodeTraversedEachScale.get(new Integer(this.currEntityClassScale))) != null) {
                if (this.lastSuccOrBran == 1) {
                    mTGNode3.addEdgeBitsTo((Node)mTGNode4, 512, null);
                } else if (this.lastSuccOrBran == 0) {
                    mTGNode3.addEdgeBitsTo((Node)mTGNode4, 256, null);
                }
            }
            this.lastNodeTraversedEachScale.put(new Integer(this.currEntityClassScale), mTGNode4);
            if (bl) {
                this.addLastNodeToNodesWithData();
            }
        } else {
            this.lastNodeTraversedEachScale.put(new Integer(this.currEntityClassScale), mTGNode2);
        }
    }

    private void firstNode() throws MTGError.MTGGraphBuildException {
        MTGNode mTGNode = this.rootNode.findAdjacentMTG(true, 4096, this.currEntityClassChar, this.currEntityIndex);
        if (mTGNode == null) {
            MTGNode mTGNode2 = this.createNewNodeType(this.currEntityClassChar);
            this.addToNodeList(mTGNode2, this.currEntityClassChar, this.currEntityIndex, 0);
            this.rootNode.addEdgeBitsTo((Node)mTGNode2, 4096, null);
            this.lastNodeTraversedEachScale.put(new Integer(this.currEntityClassScale), mTGNode2);
        } else {
            this.lastNodeTraversedEachScale.put(new Integer(this.currEntityClassScale), mTGNode);
        }
    }

    private void currentEntityToPrevious() {
        this.prevEdgeTypeIndex = this.currEdgeTypeIndex;
        this.prevEntityClassChar = this.currEntityClassChar;
        this.prevEntityClassIndex = this.currEntityClassIndex;
        this.prevEntityIndex = this.currEntityIndex;
        this.prevEntityClassScale = this.currEntityClassScale;
    }

    private void traverseGraph(String[] stringArray, int n) throws MTGError.MTGGraphBuildException {
        while (n != stringArray.length) {
            int n2;
            this.currentEntityToPrevious();
            this.currEdgeTypeIndex = this.getNextEdgeSymbol(stringArray, n);
            int n3 = this.getNextEntity(stringArray, n);
            if (n == 0) {
                if (this.currEdgeTypeIndex != 2) {
                    throw new MTGError.MTGGraphBuildException("Entity Code must begin with refinement edge symbol.");
                }
                this.firstNode();
            } else {
                n2 = 0;
                if (n + n3 == stringArray.length) {
                    n2 = 1;
                }
                switch (this.currEdgeTypeIndex) {
                    case 0: {
                        this.traverseSuccBran(true, n2 != 0);
                        break;
                    }
                    case 1: {
                        this.traverseSuccBran(false, n2 != 0);
                        break;
                    }
                    case 2: {
                        this.traverseRefine(n2 != 0);
                        break;
                    }
                    case 3: {
                        this.traverseSuccBranMany(true, n2 != 0, false);
                        break;
                    }
                    case 4: {
                        this.traverseSuccBranMany(false, n2 != 0, false);
                        break;
                    }
                    case 5: {
                        this.traverseSuccBranMany(true, n2 != 0, true);
                        break;
                    }
                    case 6: {
                        this.traverseSuccBranMany(false, n2 != 0, true);
                        break;
                    }
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                this.traverseBuffer.add(stringArray[n + n2]);
            }
            n += n3;
        }
    }

    private void processEntityNameTokens(String[] stringArray) throws MTGError.MTGGraphBuildException {
        int n = 0;
        this.traverseGraph(stringArray, n);
        String string = new String("");
        for (int i = 0; i < this.traverseBuffer.size(); ++i) {
            string = string + this.traverseBuffer.get(i);
        }
        if (this.lastTokensAtTabs.size() - 1 >= this.tabCount) {
            this.lastTokensAtTabs.remove(this.tabCount);
        }
        this.lastTokensAtTabs.add(this.tabCount, string);
    }

    private void processInfo(String[] stringArray) throws MTGError.MTGGraphBuildException {
        ++this.infoLineCount;
        this.tabCount = this.countHeadingTabCharacters(stringArray);
        if (this.tabCount == stringArray.length) {
            return;
        }
        String string = stringArray[this.tabCount];
        String string2 = this.assembleEntityFullName(string);
        String[] stringArray2 = MTGTokenizer.tokenizeEntityNames(string2);
        this.nodesWithData = null;
        this.lastNodeTraversedEachScale.clear();
        this.lastNodeTraversedEachScale.put(new Integer(0), this.rootNode);
        this.traverseBuffer.clear();
        this.processEntityNameTokens(stringArray2);
        if (this.tabCount + 1 < stringArray.length) {
            this.processFeatureValues(stringArray, this.tabCount + 1);
        }
    }

    public int processTokensBodyData(String[] stringArray) throws MTGError.MTGGraphBuildException {
        if (this.stage == 0) {
            this.processMTG(stringArray);
        } else if (this.stage == 1) {
            this.processColumnHeaders(stringArray);
        } else if (this.stage == 2) {
            this.processInfo(stringArray);
        } else {
            throw new MTGError.MTGGraphBuildException("Unexpected end stage parsing in MTG Body section.");
        }
        return this.stage;
    }
}

