/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.mtg;

import de.grogra.mtg.MTGError;
import de.grogra.mtg.MTGKeys;
import de.grogra.mtg.MTGNode;
import de.grogra.mtg.MTGNodeDataFeature;
import de.grogra.mtg.MTGRoot;
import java.util.ArrayList;

public class MTGGraphBuilderHeaderAttributes {
    protected static final int MTG_FEATURES_STAGE_FEATURES = 0;
    protected static final int MTG_FEATURES_STAGE_COLUMN_NAMES = 1;
    protected static final int MTG_FEATURES_STAGE_INFO = 2;
    protected static final int MTG_FEATURES_STAGE_END = 3;
    int stage;
    int infoCount;
    MTGNode rootNode;

    public MTGGraphBuilderHeaderAttributes(MTGNode mTGNode) {
        this.rootNode = mTGNode;
        this.stage = 0;
        this.infoCount = 0;
    }

    private void processFeatures(String[] stringArray) throws MTGError.MTGGraphBuildException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.equals("FEATURES") && !string.equals("FEATURES:")) continue;
            this.stage = 1;
        }
    }

    private void processColumnHeaders(String[] stringArray) throws MTGError.MTGGraphBuildException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("\t")) continue;
            if (!string.equals("NAME")) {
                throw new MTGError.MTGGraphBuildException("Expected Identifier 'NAME' in MTG File Header-Features section not found.");
            }
            if (stringArray.length < i + 3) {
                throw new MTGError.MTGGraphBuildException("Incorrect number of column headers in MTG File Header-Features section not found.");
            }
            if (!stringArray[i + 1].equals("\t")) {
                throw new MTGError.MTGGraphBuildException("Expected column tab in MTG File Header-Features section not found.");
            }
            if (!stringArray[i + 2].equals("TYPE")) {
                throw new MTGError.MTGGraphBuildException("Expected Identifier 'TYPE' in MTG File Header-Features section not found.");
            }
            this.stage = 2;
            return;
        }
    }

    private void processInfo(String[] stringArray) throws MTGError.MTGGraphBuildException {
        int n;
        if (stringArray.length >= 1 && (stringArray[0].equals("MTG") || stringArray[0].equals("MTG:"))) {
            this.stage = 3;
            return;
        }
        if (stringArray.length < 3) {
            throw new MTGError.MTGGraphBuildException("Unexpected number of tokens in MTG File Header-Features information Section.");
        }
        if (stringArray.length > 3) {
            for (n = 3; n < stringArray.length; ++n) {
                if (stringArray[n].equals("\t")) continue;
                throw new MTGError.MTGGraphBuildException("Unexpected number of tokens in MTG File Header-Features information Section.");
            }
        }
        if (!stringArray[0].matches("[a-zA-Z_][a-zA-Z0-9_]*")) {
            throw new MTGError.MTGGraphBuildException("Unacceptable Feature name in Column 'Name' in MTG File Header-Features information Section.");
        }
        n = MTGKeys.keywordToCodeStandardFeatureName(stringArray[0]);
        if (!stringArray[1].equals("\t")) {
            throw new MTGError.MTGGraphBuildException("Expected column tab in MTG File Header-Classes section not found.");
        }
        int n2 = MTGKeys.keywordToCodeStandardFeatureTypes(stringArray[2]);
        if (n2 == -1) {
            throw new MTGError.MTGGraphBuildException("Unacceptable Feature type in Column 'Type' in MTG File Header-Features information Section.");
        }
        if (n >= 0 && !MTGKeys.featureNameMatchesFeatureType(n, n2)) {
            throw new MTGError.MTGGraphBuildException("Standard Feature Name with unacceptable Feature Type in Column 'Type' in MTG File Header-Features information Section.");
        }
        Object object = ((MTGRoot)this.rootNode).getObject("FEATURES");
        if (object == null) {
            ((MTGRoot)this.rootNode).setObject("FEATURES", new ArrayList());
        }
        if ((object = ((MTGRoot)this.rootNode).getObject("FEATURES")) instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)((MTGRoot)this.rootNode).getObject("FEATURES");
            MTGNodeDataFeature mTGNodeDataFeature = new MTGNodeDataFeature(stringArray[0], n, n2);
            arrayList.add(mTGNodeDataFeature);
            this.rootNode.setStdAttFlagOn(MTGKeys.getStdAttFlagMask(stringArray[0]));
            ++this.infoCount;
        } else {
            throw new MTGError.MTGGraphBuildException("Unexpected data type in rootNode in MTG File Header-Features section.");
        }
    }

    public int processTokensHeaderAttributes(String[] stringArray) throws MTGError.MTGGraphBuildException {
        if (this.stage == 0) {
            this.processFeatures(stringArray);
        } else if (this.stage == 1) {
            this.processColumnHeaders(stringArray);
        } else if (this.stage == 2) {
            this.processInfo(stringArray);
        } else {
            throw new MTGError.MTGGraphBuildException("Unexpected end stage parsing in MTG-Header Features/Attributes section.");
        }
        return this.stage;
    }
}

